<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:docbook="http://docbook.org/ns/docbook"
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
    xmlns:fo="http://www.w3.org/1999/XSL/Format"
    xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
    xmlns:odf="org.ametys.odf.OdfXSLTHelper"
    exclude-result-prefixes="docbook"
    extension-element-prefixes="resolver odf">
    
    <xsl:import href="skin://stylesheets/content/program/program2pdf-main.xsl"/>
    	
    <xsl:template name="page-layout">page</xsl:template>
    
    <xsl:template match="content">
        <xsl:variable name="truelevel" select="1"/>
        
        <xsl:variable name="currentProgramItem" select="/view/structure/*[@id = /view/content/@id]"/>
        <xsl:variable name="hasChildProgramItems" select="count($currentProgramItem/subprogram|$currentProgramItem/container|$currentProgramItem/courselist) &gt; 0"/>
        
        <fo:page-sequence>
            <xsl:call-template name="master-reference-attribute"/>
            
            <xsl:call-template name="xsl-region-before"/>
            
            <xsl:call-template name="xsl-region-after"/>
            
            <!-- Body region -->    
            <fo:flow flow-name="xsl-region-body">
                <fo:block space-before="1cm" margin-top="0cm" margin-bottom="1cm" margin-left="0cm" margin-right="0cm" span="all">
                      <xsl:call-template name="header"/>
                </fo:block>
                
                <fo:block space-before="1cm"  margin-top="0cm" margin-bottom="1cm" margin-left="0cm" margin-right="0cm" span="all">
                    <!-- Benefits -->
                    <xsl:apply-templates select="/view/contentType/fieldset[@name='benefits']" mode="display"/>
                </fo:block>
                <fo:block span="all">
                      <xsl:call-template name="main-body-block"/>
                      <xsl:call-template name="body">
                          <xsl:with-param name="truelevel" select="$truelevel"/>
                      </xsl:call-template>
                </fo:block>
                
                
                <fo:block>
                    <xsl:call-template name="main-body-block"/>
                    <xsl:call-template name="bodyProgramPart">
                       <xsl:with-param name="truelevel" select="$truelevel"/>
                    </xsl:call-template>
                </fo:block>
                
                <fo:block id="theEnd" />
            </fo:flow>
        </fo:page-sequence>
    </xsl:template>
    
    <xsl:template name="header-category">
        <fo:block xsl:use-attribute-sets="header-category">
            <!-- Get the path in first parent program -->
            <xsl:value-of select="odf:getProgramPaths(@id, ' > ')"/>
        </fo:block>
    </xsl:template>
    
</xsl:stylesheet>
