<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2012 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                            xmlns:cms="http://ametys.org/cms/3.0"
                            xmlns:docbook="http://docbook.org/ns/docbook" 
							exclude-result-prefixes="ametys cms docbook">

	<xsl:import href="skin://stylesheets/content/program/program-cart.xsl"/>
	<xsl:import href="skin://stylesheets/utils.xsl"/>
    	
    <xsl:template name="cart-item-abstract">
        <xsl:if test="cms:isNotRichTextEmpty(metadata/description)">
            <div class="ametys-cart-list__item-text">
                <xsl:call-template name="common-content-body-simpletext">
                    <xsl:with-param name="text" select="''" />
                    <xsl:with-param name="defaultText" select="metadata/description/docbook:article" />
                    <xsl:with-param name="maxDefaultTextSize" select="180" />
                </xsl:call-template>
           </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="cart-item-info">
        <!-- Composante -->
        <xsl:call-template name="cart-item-data">
            <xsl:with-param name="title"><i18n:text i18n:key="SKIN_SERVICE_ODF_CART_ECTS" i18n:catalogue="skin.{$skin}"/></xsl:with-param>
            <xsl:with-param name="value" select="metadata/ects"/>
            <xsl:with-param name="max-width">110</xsl:with-param>
        </xsl:call-template>
        
        <!-- Duration -->
        <xsl:call-template name="cart-item-data">
            <xsl:with-param name="title"><i18n:text i18n:key="SKIN_SERVICE_ODF_CART_HOURS" i18n:catalogue="skin.{$skin}"/></xsl:with-param>
            <xsl:with-param name="value" select="metadata/nbHours"/>
            <xsl:with-param name="max-width">130</xsl:with-param>
        </xsl:call-template>
        
        <!-- Langues -->
        <xsl:call-template name="cart-item-data">
            <xsl:with-param name="title"><i18n:text i18n:key="SKIN_SERVICE_ODF_CART_LANGUAGES" i18n:catalogue="skin.{$skin}"/></xsl:with-param>
            <xsl:with-param name="value" select="metadata/teachingLanguage"/>
            <xsl:with-param name="max-width">110</xsl:with-param>
        </xsl:call-template>
        
        <!-- Période -->
         <xsl:call-template name="cart-item-data">
            <xsl:with-param name="title"><i18n:text i18n:key="SKIN_SERVICE_ODF_CART_PERIOD" i18n:catalogue="skin.{$skin}"/></xsl:with-param>
            <xsl:with-param name="value" select="metadata/teachingTerm"/>
            <xsl:with-param name="max-width">230</xsl:with-param>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template match="nbHours" mode="value">
        <xsl:variable name="nbHours"><xsl:call-template name="transform-double"><xsl:with-param name="value" select="."/></xsl:call-template></xsl:variable>
        <xsl:value-of select="$nbHours"/>h
    </xsl:template>
    
    <xsl:template match="ects" mode="value">
        <xsl:variable name="ects"><xsl:call-template name="transform-double"><xsl:with-param name="value" select="."/></xsl:call-template></xsl:variable>
        <xsl:value-of select="$ects"/> <i18n:text i18n:key="PROGRAM_ECTS_UNITS" i18n:catalogue="skin.{$skin}"/>
    </xsl:template>
    
    <xsl:template match="teachingTerm" mode="value">
        <xsl:variable name="value" select="@id" />
        <xsl:variable name="code" select="ametys:contentAttribute($value, 'code')" />
            
        <xsl:call-template name="period-calendar">
            <xsl:with-param name="period" select="$code"/>
        </xsl:call-template>
    </xsl:template>
    
</xsl:stylesheet>
