<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2012 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                            xmlns:math="http://exslt.org/math"
                            xmlns:exsl="http://exslt.org/common"
                            xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                            xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                            xmlns:docbook="http://docbook.org/ns/docbook" 
                            xmlns:xalan="http://xml.apache.org/xalan"
                            xmlns:odf="org.ametys.plugins.odfweb.xslt.OdfXSLTHelper"
                            xmlns:cms="http://ametys.org/cms/3.0" 
                            exclude-result-prefixes="ametys resolver docbook">

    
    <xsl:import href="skin://stylesheets/content/default-content.xsl"/>
    <xsl:import href="skin://stylesheets/content/common.xsl"/>
	<xsl:import href="skin://stylesheets/content/course/course.xsl"/>
    
    <xsl:import href="plugin:odf-web://stylesheets/helper/cart.xsl"/>

    <xsl:import href="skin://stylesheets/content/course/zone/header.xsl"/>   
    <xsl:import href="skin://stylesheets/content/course/zone/aside.xsl"/>   
    <xsl:import href="skin://stylesheets/content/course/zone/benefits.xsl"/>   
    <xsl:import href="skin://stylesheets/content/course/zone/structure.xsl"/>   
    <xsl:import href="skin://stylesheets/content/course/zone/mcc.xsl"/>   
    
    <xsl:template name="common-content-body-title"/>
    
    <xsl:template name="common-content-body-content">
        <xsl:call-template name="main-banner"/>
        <xsl:call-template name="main-content"/>
    </xsl:template>
    
    <xsl:template name="main-content">
        <div class="ametys-main-content course-single course">
            <!-- The top key info -->
			<xsl:call-template name="benefits"/>
            
            <xsl:apply-templates select="/view/contentType/fieldset[@role = 'tab'][1]" mode="display-first"/>
            <xsl:apply-templates select="/view/contentType/fieldset[@role = 'tab'][position() != 1]" mode="display"/>
		</div>
    </xsl:template>
    
    <xsl:template match="fieldset[@role='tab']" mode="display-first">
        <div class="container">
            <div class="ametys-courses-single-two-columns-content">
                                
                <div class="ametys-courses-single-two-columns-content__body">
                    <xsl:apply-templates select="metadata" mode="display"/> 
                    
                    <xsl:call-template name="course-structure">
                        <xsl:with-param name="currentProgramItem" select="/view/structure/*[@id = /view/content/@id]"/>
                        <xsl:with-param name="title"><i18n:text i18n:key="COURSE_STRUCTURE_TITLE" i18n:catalogue="skin.{$skin}"/></xsl:with-param>
                    </xsl:call-template>
                </div>
                
                <!-- Aside informations -->
                <xsl:apply-templates select="/view/contentType/fieldset[@name='aside']" mode="display"/> 
            </div>
        </div>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'ects']" mode="value">
        <xsl:param name="value"/>
        
        <xsl:variable name="currentEcts" select="odf:getCurrentEcts()"/>
        <xsl:variable name="ects"><xsl:call-template name="transform-double"><xsl:with-param name="value" select="$currentEcts"/></xsl:call-template></xsl:variable>
        <xsl:value-of select="$ects"/> <i18n:text i18n:key="PROGRAM_ECTS_UNITS" i18n:catalogue="skin.{$skin}"/>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'courseParts']" mode="display">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
        <xsl:if test="$value">
            <section class="g-mb-35">
                <div class="ametys-richtext">
                    <h3 class="ametys-richtext-title-4"><xsl:value-of select="label"/></h3>
                    
                    <ul id="courseParts-{generate-id()}" class="ametys-coursepart mb-0">
                        <xsl:variable name="definition" select="."/>
                        <xsl:for-each select="$value">
                            <xsl:apply-templates select="$definition" mode="value">
                                <xsl:with-param name="value" select="."/>
                            </xsl:apply-templates>
                        </xsl:for-each>
                    </ul>
                 </div>
            </section>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'courseParts']" mode="value">
        <xsl:param name="value"/>
        
        <xsl:variable name="coursepart" select="/view/structure//courseparts/coursepart[@id = $value/@id]"/>
        
        <li class="ametys-coursepart__item">
            <span class="ametys-coursepart__item-icon ametys-icon-clock"></span>
            <span class="ametys-coursepart__item-title"><xsl:value-of select="$coursepart/@title"/></span>
            <span class="ametys-coursepart__item-text"><xsl:value-of select="$coursepart/attributes/nature"/></span>
            
            <span class="ametys-coursepart__item-badge ametys-coursepart__item-badge--total">
                <xsl:if test="$coursepart/attributes/nbHours != 0">
                    <xsl:variable name="nbHours"><xsl:call-template name="transform-double"><xsl:with-param name="value" select="$coursepart/attributes/nbHours"/></xsl:call-template></xsl:variable>
                    <xsl:value-of select="$nbHours"/>h
                </xsl:if>
            </span>
        </li>
    </xsl:template>
    
    <!-- Compétences requises -->
    <xsl:template match="metadata[@name = 'requiredSkills']" mode="display">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
        <xsl:if test="$value">
            <section class="g-mb-40">
                                                    
                <h2 class="ametys-section-sub-title ametys-section-sub-title--has-line g-mb-30"><xsl:value-of select="label"/></h2>
            
                <xsl:call-template name="skill-badges">
                    <xsl:with-param name="skills" select="$value"/>
                </xsl:call-template>
            </section>
        </xsl:if>
    </xsl:template>
    
    <!-- Compétences requises -->
    <xsl:template match="metadata[@name = 'acquiredSkills']" mode="display">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
        <xsl:variable name="hiddenSkills" select="odf:areSkillsUnavailable(/view/content/@id, ametys:pageId())"/> 
        
        <xsl:if test="$value/@entryCount != '0' and not($hiddenSkills)">
            <section class="g-mb-40">
                                                    
                <h2 class="ametys-section-sub-title ametys-section-sub-title--has-line g-mb-30"><xsl:value-of select="label"/></h2>
                
                <div class="table-responsive">
                    <table class="table ametys-skills-table datalight">
                        <thead>
                            <tr>
                                <th colspan="2"><p>Compétences</p></th>
                                <th><p>Niveau d'acquisition</p></th>
                            </tr>
                        </thead>
                        <tbody>
                            <xsl:variable name="definition" select="."/>
                            <xsl:for-each select="$value">
                                <xsl:apply-templates select="$definition" mode="value">
                                    <xsl:with-param name="value" select="."/>
                                </xsl:apply-templates>
                            </xsl:for-each>
                        </tbody>
                    </table>
                </div>
            </section>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'acquiredSkills']" mode="value">
        <xsl:param name="value"/>
        
        <xsl:variable name="repeaterDef" select="."/>
        
        <xsl:for-each select="$value/entry">
            <tr>
                <th rowspan="{count(skills/entry)}"><xsl:value-of select="skillSet/@title"/></th>
                <xsl:apply-templates select="skills/entry[1]" mode="display-skill"/>
            </tr>
            <xsl:for-each select="skills/entry[position() &gt; 1]">
                <tr>
                    <xsl:apply-templates select="." mode="display-skill"/>
                </tr>
            </xsl:for-each>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template match="entry" mode="display-skill">
        <th><xsl:value-of select="skill/@title"/></th>
        <td>
            <xsl:choose>
                <xsl:when test="acquisitionLevel"><xsl:value-of select="acquisitionLevel/@title"/></xsl:when>
                <xsl:otherwise><i18n:text i18n:key="PLUGINS_ODF_SKILLS_TABLE_NO_LEVEL" i18n:catalogue="plugin.odf"/></xsl:otherwise>
            </xsl:choose>
        </td>
    </xsl:template>
</xsl:stylesheet>
