<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
        xmlns:fo="http://www.w3.org/1999/XSL/Format"
        xmlns:xalan="http://xml.apache.org/xalan"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:odf="org.ametys.odf.OdfXSLTHelper"
        xmlns:cms="http://ametys.org/cms/3.0"
        xmlns:docbook="http://docbook.org/ns/docbook" 
        exclude-result-prefixes="sitemap ametys resolver odf docbook cms">
    
    <!-- Compétences requises -->
    
    <xsl:template match="metadata[@name = 'acquiredSkills']" mode="display">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
        <xsl:if test="$value/@entryCount != '0'">
            <fo:block>
                <fo:block xsl:use-attribute-sets="section-title">
                    <xsl:value-of select="label"/>
                </fo:block>
                
                <xsl:apply-templates select="metadata" mode="display"/> 
            </fo:block>
            
            <fo:table table-layout="fixed" margin-top="5mm" padding="0pt" >
                <xsl:call-template name="skills-table-style"/>
                
                <fo:table-column/>
                <fo:table-column/>
                <fo:table-column column-width="4cm"/>    
                <fo:table-body>
                    <xsl:call-template name="skills-table-header"/>
                    
                    <xsl:variable name="definition" select="."/>
                    <xsl:for-each select="$value">
                        <xsl:apply-templates select="$definition" mode="value">
                            <xsl:with-param name="value" select="."/>
                        </xsl:apply-templates>
                    </xsl:for-each>
                </fo:table-body>
            </fo:table>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="skills-table-header">
        <fo:table-row>
            <fo:table-cell number-columns-spanned="2">
                <xsl:call-template name="skills-th-style"/>
                <fo:block>Compétences</fo:block>
            </fo:table-cell>
            <fo:table-cell>
                <xsl:call-template name="skills-th-style"/>
                <fo:block>Niveau d'acquisition</fo:block>
            </fo:table-cell>
        </fo:table-row>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'acquiredSkills']" mode="value">
        <xsl:param name="value"/>
        
        <xsl:variable name="repeaterDef" select="."/>
        
        <xsl:for-each select="$value/entry">
            <fo:table-row>
                <fo:table-cell number-rows-spanned="{count(skills/entry)}">
                    <xsl:call-template name="skills-td-style"/>
                    <fo:block><xsl:value-of select="skillSet/@title"/></fo:block>
                </fo:table-cell>
                <xsl:apply-templates select="skills/entry[1]" mode="display-skill"/>
            </fo:table-row>
            <xsl:for-each select="skills/entry[position() &gt; 1]">
                <fo:table-row>
                    <xsl:apply-templates select="." mode="display-skill"/>
                </fo:table-row>
            </xsl:for-each>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template match="entry" mode="display-skill">
        <fo:table-cell>
            <xsl:call-template name="skills-td-style"/>
            <fo:block><xsl:value-of select="skill/@title"/></fo:block>
        </fo:table-cell>
        <fo:table-cell>
            <xsl:call-template name="skills-td-style"/>
            <fo:block>
	            <xsl:choose>
	                <xsl:when test="acquisitionLevel"><xsl:value-of select="acquisitionLevel/@title"/></xsl:when>
	                <xsl:otherwise><i18n:text i18n:key="PLUGINS_ODF_SKILLS_TABLE_NO_LEVEL" i18n:catalogue="plugin.odf"/></xsl:otherwise>
	            </xsl:choose>
            </fo:block>
        </fo:table-cell>
    </xsl:template>
    
</xsl:stylesheet>