<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2012 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                            xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                            xmlns:docbook="http://docbook.org/ns/docbook" 
                            xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent" 
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                            xmlns:cms="http://ametys.org/cms/3.0"
                            exclude-result-prefixes="ametys resolver docbook cms">

    <xsl:import href="plugin:odf://stylesheets/content/program/program-cart.xsl"/>	
    <xsl:import href="skin://stylesheets/content/program/program.xsl"/>
    
    <xsl:template name="common-content-body-title"/>
    
    <xsl:template name="common-content-body-content">
        
        <xsl:call-template name="cart-item-abstract"/>
            
        <div class="ametys-table-of-content" style="width: 100%">
            <xsl:call-template name="cart-item-info"/>
        </div>
    </xsl:template>	
    
    <xsl:template name="cart-item-abstract">
        <xsl:if test="cms:isNotRichTextEmpty(metadata/presentation)">
            <div class="ametys-cart-list__item-text">
                <xsl:call-template name="common-content-body-simpletext">
                    <xsl:with-param name="text" select="''" />
                    <xsl:with-param name="defaultText" select="metadata/presentation/docbook:article" />
                    <xsl:with-param name="maxDefaultTextSize" select="180" />
                </xsl:call-template>
           </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="cart-item-info">
        <!-- Régimes d'étude -->
        <xsl:call-template name="cart-item-data">
            <xsl:with-param name="title"><i18n:text i18n:key="SKIN_SERVICE_ODF_CART_FORM_OF_TEACHING_ORG" i18n:catalogue="skin.{$skin}"/></xsl:with-param>
            <xsl:with-param name="value" select="metadata/formofteachingOrg"/>
        </xsl:call-template>
        
        <!-- Composante -->
        <xsl:call-template name="cart-item-data">
            <xsl:with-param name="title"><i18n:text i18n:key="SKIN_SERVICE_ODF_CART_ORGUNIT" i18n:catalogue="skin.{$skin}"/></xsl:with-param>
            <xsl:with-param name="value" select="metadata/orgUnit"/>
            <xsl:with-param name="max-width">220</xsl:with-param>
        </xsl:call-template>
        
        <!-- Duration -->
        <xsl:call-template name="cart-item-data">
            <xsl:with-param name="title"><i18n:text i18n:key="SKIN_SERVICE_ODF_CART_DURATION" i18n:catalogue="skin.{$skin}"/></xsl:with-param>
            <xsl:with-param name="value" select="metadata/duration"/>
            <xsl:with-param name="max-width">110</xsl:with-param>
        </xsl:call-template>
        
        <!-- Langues -->
        <xsl:call-template name="cart-item-data">
            <xsl:with-param name="title"><i18n:text i18n:key="SKIN_SERVICE_ODF_CART_LANGUAGES" i18n:catalogue="skin.{$skin}"/></xsl:with-param>
            <xsl:with-param name="value" select="metadata/educationLanguage"/>
            <xsl:with-param name="max-width">110</xsl:with-param>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="cart-item-data">
        <xsl:param name="title"/>
        <xsl:param name="value"/>
        <xsl:param name="max-width"/>
        
        <xsl:if test="$value">
            <div class="ametys-table-of-content__column">
                <xsl:if test="$max-width != ''"><xsl:attribute name="style">max-width: <xsl:value-of select="$max-width"/>px</xsl:attribute></xsl:if>
                <h5 class="ametys-table-of-content__title"><xsl:copy-of select="$title"/></h5>
                <p>
                    <xsl:apply-templates select="$value" mode="value"/>
                </p>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="*" mode="value">
        <xsl:choose>
            <xsl:when test="@title"><xsl:value-of select="@title"/></xsl:when>
            <xsl:otherwise><xsl:value-of select="."/></xsl:otherwise>
        </xsl:choose>
        <xsl:if test="position() != last()">, </xsl:if>
    </xsl:template>
    
</xsl:stylesheet>
