<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2012 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							xmlns:math="http://exslt.org/math"
							xmlns:exsl="http://exslt.org/common"
							xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                            xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                            xmlns:docbook="http://docbook.org/ns/docbook" 
                            xmlns:xalan="http://xml.apache.org/xalan"
                            xmlns:odf="org.ametys.plugins.odfweb.xslt.OdfXSLTHelper"
                            xmlns:cms="http://ametys.org/cms/3.0" 
							exclude-result-prefixes="ametys resolver cms">

    <xsl:import href="skin://stylesheets/content/default-content.xsl"/>
    <xsl:import href="skin://stylesheets/content/common.xsl"/>
	<xsl:import href="skin://stylesheets/content/program/program.xsl"/>
    
    <xsl:import href="plugin:odf-web://stylesheets/helper/cart.xsl"/>

    <xsl:import href="skin://stylesheets/content/program/zone/header.xsl"/>   
    <xsl:import href="skin://stylesheets/content/program/zone/aside.xsl"/>
    <xsl:import href="skin://stylesheets/content/program/zone/benefits.xsl"/>
    <xsl:import href="skin://stylesheets/content/program/zone/structure.xsl"/>
    <xsl:import href="skin://stylesheets/content/program/zone/skills.xsl"/>
    
    <xsl:import href="skin://stylesheets/content/program/tool/sticky-widget.xsl"/>
    <xsl:import href="skin://stylesheets/content/program/tool/how-to-apply.xsl"/>
    
	
    <xsl:template name="common-content-body-title"/>
    
    <xsl:template name="common-content-body-content">
        <xsl:call-template name="main-banner"/>
        <xsl:call-template name="main-content"/>
    </xsl:template>
    
    <xsl:template name="main-content">
        <div class="ametys-main-content course-single program">
        
            <!-- The top key info -->
			<xsl:call-template name="benefits"/>
			
            
            <!-- Tabs navigation -->
            <xsl:if test="/view/contentType/fieldset[@role = 'tab']">
                <xsl:call-template name="tabs-navigation"/>
            </xsl:if>
            
            <!-- Display tabs -->
            <xsl:apply-templates select="/view/contentType/fieldset[@role = 'tab'][1]" mode="display-first"/>
            <xsl:apply-templates select="/view/contentType/fieldset[@role = 'tab'][position() != 1]" mode="display"/>
            
            <xsl:call-template name="tabs-navigation-js"/>
		</div>
        
        <xsl:call-template name="sticky-right-widget"/>
    </xsl:template>
    
    <!-- +
         | Template for tabs navigation
         + -->
    <xsl:template name="tabs-navigation">
        <div id="pageNavWrap" style="height: 72px;">
            <nav id="pageNav" class="ametys-sections-nav-wrap">
                <div class="container">
                    <ul id="pageNavigation" class="ametys-sections-nav">
                        <xsl:apply-templates select="/view/contentType/fieldset[@role = 'tab']" mode="nav"/>
                    </ul>
                </div>
            </nav>
        </div>
    </xsl:template>
    
    <xsl:template match="fieldset[@role='tab' and @name='program']" mode="nav" priority="100">
        <xsl:variable name="self" select="."/>
        
        <!--  Get all subprograms and all containers of type 'year' among the direct children -->
        <xsl:variable name="currentProgramItem" select="/view/structure/*[@id = /view/content/@id]"/>
        <xsl:variable name="hasChildProgramItems" select="count($currentProgramItem/subprogram|$currentProgramItem/container|$currentProgramItem/courselist) &gt; 0"/>
    
        <xsl:if test="cms:isNotFieldsetEmpty($self) or $hasChildProgramItems">
            <li class="ametys-sections-nav__item">
                <a class="ametys-sections-nav__link" href="#tab-{generate-id()}"><xsl:value-of select="label"/></a>
            </li>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="fieldset[@role='tab']" mode="nav">
        <xsl:variable name="self" select="."/>
        
        <xsl:if test="cms:isNotFieldsetEmpty($self)">
            <li class="ametys-sections-nav__item">
                <a class="ametys-sections-nav__link" href="#tab-{generate-id()}"><xsl:value-of select="label"/></a>
            </li>
         </xsl:if>
    </xsl:template>
    
    <!-- +
         | JavaScript to handle tabs navigation
         +-->
    <xsl:template name="tabs-navigation-js">
        <script>
            $j.HSCore.components.HSScrollNavAlt.init($j('#pageNavigation'), {
                duration: 700,
                over: $j('.ametys-sections-nav-wrap')
            });
        </script>
    </xsl:template>
    
    <!-- +
         | Default template for display of first tab.
         | This tab display information on two columns.
         | A "main" and "aside" fieldsets are expected.
         + -->
    <xsl:template match="fieldset[@role='tab']" mode="display-first">
        <xsl:variable name="self" select="."/>
        
        <xsl:if test="cms:isNotFieldsetEmpty($self)">
            <div id="tab-{generate-id()}">
                <div class="container">
                    <section class="g-py-50">
                       <h2 class="ametys-section-title"><xsl:value-of select="label"/></h2>
                    
                        <xsl:apply-templates select="metadata" mode="display"/> 
                    </section>
                                        
                    <div class="ametys-courses-single-two-columns-content">
                        <xsl:if test="cms:isNotFieldsetEmpty(fieldset[@name='main']) or /view/skills/skillSet">
                            <div class="ametys-courses-single-two-columns-content__body">
                                <xsl:apply-templates select="fieldset[@name='main']/fieldset|fieldset[@name='main']/metadata" mode="display"/> 
                                <xsl:apply-templates select="/view/skills" mode="display"/>
                            </div>
                        </xsl:if>
                        
                        <!-- Aside informations -->
                        <xsl:apply-templates select="fieldset[@name='aside']" mode="display"/> 
                    </div>
                </div>
            </div>
        </xsl:if>
    </xsl:template>
    
    <!-- +
         | Template for "Program" lime
         | This lime contains the semesters table and/or the courses 
         + -->
    <xsl:template match="fieldset[@role='tab' and @name='program']" mode="display">
        <xsl:variable name="self" select="."/>
        
        <xsl:variable name="currentProgramItem" select="/view/structure/*[@id = /view/content/@id]"/>
        <xsl:variable name="hasChildProgramItems" select="count($currentProgramItem/subprogram|$currentProgramItem/container|$currentProgramItem/courselist) &gt; 0"/>
        
        <xsl:if test="cms:isNotFieldsetEmpty($self) or $hasChildProgramItems">
            <div id="tab-{generate-id()}" class="ametys-tab">
                <section class="g-py-55">
                    <div class="container">
                        <h2 class="ametys-section-title g-mb-45"><xsl:value-of select="label"/></h2>
                        
                        <xsl:apply-templates select="fieldset|metadata" mode="display"/>
                        
                        <!-- The program structure -->
                        <xsl:call-template name="program-structure">
                            <xsl:with-param name="currentProgramItem" select="$currentProgramItem"/>
                            <xsl:with-param name="title"><i18n:text i18n:key="PROGRAM_STRUCTURE_NAV_TITLE" i18n:catalogue="skin.{$skin}"/></xsl:with-param>
                        </xsl:call-template>
                    </div>
                </section>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="fieldset[@name = 'key-figures']" mode="display">
        <xsl:variable name="self" select="."/>
       
        <xsl:if test="cms:isNotFieldsetEmpty($self)">
            <section class="g-mb-50">
                <ul class="ametys-benefits-alt-2 g-mb-50">
                    <xsl:apply-templates select="metadata" mode="key-figure" />
                </ul>
             </section>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata" mode="key-figure">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
        <xsl:if test="$value">
            <li class="ametys-benefits-alt-2__item">
                <div class="ametys-benefits-alt-2__item-icon">
                    <xsl:apply-templates select="." mode="key-figure-icon"/>
                </div>
                
                <div class="ametys-benefits-alt-2__item-description">
                    <h2 class="ametys-benefits-alt-2__item-title">
                        <xsl:apply-templates select="." mode="value">
                            <xsl:with-param name="value" select="$value"/>
                        </xsl:apply-templates>
                    </h2>
                    <p class="ametys-benefits-alt-2__item-text"><xsl:value-of select="label"/></p>
                </div>
            </li>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'studentCapacity']" mode="key-figure-icon">
        <span class="ametys-icon-couple"></span>
    </xsl:template>
    
    <!-- Defaut icon for key figure -->
    <xsl:template match="metadata" mode="key-figure-icon">
        <span class="ametys-icon-graduation-cap-alt"></span>
    </xsl:template>
    
    <!-- Répartition poursuite d'étude -->
    <xsl:template match="metadata[@name = 'furtherStudyDistribution']" mode="display">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
         
        <xsl:if test="$value/@entryCount != '0'">
            <section class="g-mb-55">
                <h2 class="ametys-progress-title"><i18n:text i18n:key="PROGRAM_FURTHER_STUDY_DISTRIBUTION" i18n:catalogue="skin.{$skin}"/></h2>
                
                <xsl:variable name="definition" select="."/>
                <div class="ametys-progress-list">
                    <xsl:for-each select="$value">
                        <xsl:apply-templates select="$definition" mode="progress-list-items">
                            <xsl:with-param name="value" select="."/>
                        </xsl:apply-templates>
                    </xsl:for-each>
                </div>
            </section>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'furtherStudyDistribution']" mode="progress-list-items">
        <xsl:param name="value"/>
        
        <xsl:for-each select="$value/entry">
            <xsl:variable name="percentage" select="round(percentage)"/>
            
            <div class="ametys-progress-list__item">
                <div class="ametys-progress">
                    <div class="ametys-progress__bar" style="width: {$percentage}%;" role="progressbar" aria-valuenow="{$percentage}" aria-valuemin="0" aria-valuemax="100"></div>
                </div>
                
                <h3 class="ametys-progress-list__item-title">
                    <xsl:choose>
                        <xsl:when test="program/@id">
                            <a href="{resolver:resolve('odf', program/@id)}">
                                <xsl:choose>
                                    <xsl:when test="normalize-space(title) != ''"><xsl:value-of select="title"/></xsl:when>
                                    <xsl:otherwise><xsl:value-of select="program/@title"/></xsl:otherwise>
                                </xsl:choose>
                            </a>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="title"/>
                        </xsl:otherwise>
                    </xsl:choose>
                    <span class="ametys-progress-list__item-value"><xsl:value-of select="$percentage"/>%</span>
                </h3>
            </div>
        </xsl:for-each>
    </xsl:template>
    
    <!-- Compétences requises -->
    <xsl:template match="metadata[@name = 'requiredSkills']" mode="display">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
        <xsl:if test="$value">
            <section class="g-mb-40">
                                                    
                <h2 class="ametys-section-sub-title ametys-section-sub-title--has-line g-mb-30"><xsl:value-of select="label"/></h2>
            
                <xsl:call-template name="skill-badges">
                    <xsl:with-param name="skills" select="$value"/>
                </xsl:call-template>
            </section>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata[@name='presentation' and @type='rich-text']" mode="display">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
        <xsl:if test="$value/docbook:article">
            <xsl:variable name="definition" select="."/>                      
            <xsl:apply-templates select="$definition" mode="value">
                <xsl:with-param name="value" select="$value"/>
            </xsl:apply-templates>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata[@name='presentation' and @type='rich-text']" mode="value" priority="100">
        <xsl:param name="value"/>
        <xsl:param name="level" select="2"/>
        
        <xsl:call-template name="limited-rich-text">
            <xsl:with-param name="value" select="$value"/>
            <xsl:with-param name="level" select="$level"/>
            <xsl:with-param name="maxHeight" select="'150'"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template match="metadata[@name='teachingOrganization']" mode="display">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
        <xsl:if test="$value/docbook:article">
            <xsl:variable name="definition" select="."/>                      
            <xsl:apply-templates select="$definition" mode="value">
                <xsl:with-param name="value" select="$value"/>
            </xsl:apply-templates>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata[@name='furtherStudyPrograms']" mode="display">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
        <xsl:if test="$value">
            <section class="g-mb-35">
                <h2 class="ametys-section-sub-title ametys-section-sub-title--has-line g-mb-30"><xsl:value-of select="label"/></h2>
                
                <xsl:variable name="definition" select="."/>                      
                <ul>
                    <xsl:for-each select="$value">
                        <li>
                            <xsl:apply-templates select="$definition" mode="value">
                                <xsl:with-param name="value" select="."/>
                            </xsl:apply-templates>
                        </li>
                    </xsl:for-each>
                </ul>
            </section>
        </xsl:if>
    </xsl:template>
    
    <!-- **************************************** -->
    <!--                 Alternance               -->
    <!-- **************************************** -->
    <xsl:template match="metadata[@name='apprenticeshipOpen']" mode="display">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
        <xsl:if test="$value = 'true'">
            <section class="g-mb-35">
                <h2 class="ametys-section-sub-title ametys-section-sub-title--has-line g-mb-30"><i18n:text i18n:key="CONTENT_PROGRAM_APPRENTICESHIP_OPEN" i18n:catalogue="plugin.odf"/></h2>
                
                <xsl:choose>
                    <xsl:when test="/view/content/metadata/*[local-name() = 'apprenticeshipContract'] or /view/content/metadata/*[local-name() = 'apprenticeshipPeriod']/docbook:article or /view/content/metadata/*[local-name() = 'apprenticeshipModalities']/docbook:article">
                        <xsl:if test="/view/content/metadata/*[local-name() = 'apprenticeshipContract']">
                            <table class="data" style="width: 100%;">
                                <tbody>
                                    <tr></tr>
                                    <xsl:apply-templates select="/view/contentType//metadata[@name='apprenticeshipContract']" mode="table-row"/>
                                </tbody>
                            </table>
                        </xsl:if>
                
                        <xsl:apply-templates select="/view/contentType//metadata[@name='apprenticeshipPeriod']" mode="apprenticeship"/>
                        
                        <xsl:apply-templates select="/view/contentType//metadata[@name='apprenticeshipModalities']" mode="apprenticeship"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <p><i18n:text i18n:key="PROGRAM_APPRENTICESHIP_OPEN" i18n:catalogue="skin.{$skin}"/></p>
                    </xsl:otherwise>
                </xsl:choose>
            </section>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata[@name='apprenticeshipContract']" mode="display"/>
    
    <xsl:template match="metadata[@name='apprenticeshipPeriod']" mode="display"/>
    <xsl:template match="metadata[@name='apprenticeshipPeriod']" mode="apprenticeship">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
                
        <xsl:variable name="definition" select="."/>                      
        <xsl:apply-templates select="$definition" mode="value">
            <xsl:with-param name="value" select="$value"/>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template match="metadata[@name='apprenticeshipModalities']" mode="display"/>
    <xsl:template match="metadata[@name='apprenticeshipModalities']" mode="apprenticeship">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
        <xsl:variable name="definition" select="."/>                      
        <xsl:apply-templates select="$definition" mode="value">
            <xsl:with-param name="value" select="$value"/>
        </xsl:apply-templates>
    </xsl:template>
    
    <!-- **************************************** -->
    <!--                 Stage                    -->
    <!-- **************************************** -->
    <xsl:template match="metadata[@name='internshipOpen']" mode="display">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
        <xsl:if test="$value = 'true' or /view/content/metadata/*[local-name() = 'internshipDescription']/@entryCount != '0'">
            <section class="g-mb-35">
                <h2 class="ametys-section-sub-title ametys-section-sub-title--has-line g-mb-30"><i18n:text i18n:key="CONTENT_PROGRAM_TRAINING_STRATEGY" i18n:catalogue="plugin.odf"/></h2>
                
                 <xsl:choose>
                    <xsl:when test="/view/content/metadata/*[local-name() = 'internship'] 
                                or /view/content/metadata/*[local-name() = 'internshipDuration'] 
                                or /view/content/metadata/*[local-name() = 'internshipAbroad']
                                or /view/content/metadata/*[local-name() = 'internshipAbroadDuration']
                                or /view/content/metadata/*[local-name() = 'trainingStrategy']/docbook:article">
                    
                            <xsl:if test="/view/content/metadata/*[local-name() = 'internship'] 
                                            or /view/content/metadata/*[local-name() = 'internshipDuration'] 
                                            or /view/content/metadata/*[local-name() = 'internshipAbroad']
                                            or /view/content/metadata/*[local-name() = 'internshipAbroadDuration']">
                                <table class="data" style="width: 100%;">
                                    <tbody>
                                        <tr></tr>
                                        <xsl:apply-templates select="/view/contentType//metadata[@name='internship']|/view/contentType//metadata[@name='internshipDuration']|/view/contentType//metadata[@name='internship']|/view/contentType//metadata[@name='internshipAbroad']|/view/contentType//metadata[@name='internshipAbroadDuration']" mode="table-row"/>
                                    </tbody>
                                </table>
                            </xsl:if>
                            
                            <xsl:apply-templates select="/view/contentType//metadata[@name='trainingStrategy']" mode="internship"/>
                    </xsl:when>
                    <xsl:when test="not(/view/content/metadata/*[local-name() = 'internshipDescription']) or /view/content/metadata/*[local-name() = 'internshipDescription']/@entryCount = '0'">
                         <p><i18n:text i18n:key="PROGRAM_INTERNSHIP_OPEN" i18n:catalogue="skin.{$skin}"/></p>
                    </xsl:when>
                </xsl:choose>
            </section>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata[@name='trainingStrategy']" mode="display"/>
    <xsl:template match="metadata[@name='trainingStrategy']" mode="internship">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
        <xsl:variable name="definition" select="."/>                      
        <xsl:apply-templates select="$definition" mode="value">
            <xsl:with-param name="value" select="$value"/>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template match="metadata[@name='internship']" mode="display"/>
    <xsl:template match="metadata[@name='internshipDuration']" mode="display"/>
    <xsl:template match="metadata[@name='internshipAbroad']" mode="display"/>
    <xsl:template match="metadata[@name='internshipAbroadDuration']" mode="display"/>
    
    <xsl:template match="metadata[@type='rich-text']" mode="table-row">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        <xsl:param name="entryUniqueId"/>
        
        <xsl:if test="$value">
            <tr>
                <th style="width: 28.5%;">
                    <p><xsl:value-of select="label"/></p>
                </th>
                <td>
                    <xsl:apply-templates select="." mode="value">
                        <xsl:with-param name="value" select="$value"/>
                        <xsl:with-param name="uniqueId" select="concat($entryUniqueId, '-', generate-id())"/>
                    </xsl:apply-templates>
                </td>
            </tr>
        </xsl:if>
    </xsl:template>   
    
    <xsl:template match="metadata" mode="table-row">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
        <xsl:if test="$value">
            <tr>
                <th style="width: 28.5%;">
                    <p><xsl:value-of select="label"/></p>
                </th>
                <td>
                    <p>
                        <xsl:variable name="definition" select="."/>
                        <xsl:for-each select="$value">
                            <xsl:if test="position() != 1"><xsl:text>, </xsl:text></xsl:if>
                            <xsl:apply-templates select="$definition" mode="value">
                                <xsl:with-param name="value" select="."/>
                            </xsl:apply-templates>
                        </xsl:for-each>
                    </p>
                </td>
            </tr>
        </xsl:if>
    </xsl:template>   
    
    <xsl:template match="metadata[@name='internshipDescription']" mode="display">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
        <xsl:if test="$value/@entryCount != '0' and $value/entry/title != ''">
            <xsl:variable name="repeaterDef" select="."/>
                    
            <xsl:for-each select="$value/entry">
                <h3 class="ametys-richtext-title-4"><xsl:value-of select="title"/></h3>
                
                <xsl:variable name="entry" select="."/>
                <xsl:variable name="entryUniqueId" select="generate-id()"/>
                
                <table class="data" style="width: 100%;">
                    <tbody>
                        <xsl:for-each select="$repeaterDef/metadata[@name != 'title']">
                            <xsl:variable name="name" select="@name"/>
                            <xsl:apply-templates select="." mode="table-row">
                                <xsl:with-param name="value" select="$entry/*[local-name() = $name]"/>
                                <xsl:with-param name="entryUniqueId" select="$entryUniqueId"/>
                            </xsl:apply-templates>
                        </xsl:for-each>
                    </tbody>
                </table>
            </xsl:for-each>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'ects' and @type='content']" mode="value">
        <xsl:param name="value"/>
        
        <xsl:value-of select="$value/@title"/> <i18n:text i18n:key="PROGRAM_ECTS_UNITS" i18n:catalogue="skin.{$skin}"/>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'ects' and @type='double']" mode="value">
        <xsl:param name="value"/>
        
        <xsl:variable name="ects"><xsl:call-template name="transform-double"><xsl:with-param name="value" select="$value"/></xsl:call-template></xsl:variable>
        <xsl:value-of select="$ects"/> <i18n:text i18n:key="PROGRAM_ECTS_UNITS" i18n:catalogue="skin.{$skin}"/>
    </xsl:template>
            
</xsl:stylesheet>
