<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2012 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
							exclude-result-prefixes="ametys">

    <xsl:param name="isODFContent" select="true()"/>
    
	<xsl:template name="common-content-head-css">
        <link rel="stylesheet" href="{ametys:skinURL('richtext/scss/richtext.css')}"/>
        
        <!-- Zone Courses Single -->
        <link rel="stylesheet" href="{ametys:skinURL('zones/courses-single/scss/main.css')}" />
        <link rel="stylesheet" href="{ametys:skinURL('zones/courses-single/scss/print.css')}" />
        <!-- End Zone Courses Single -->
        
        <!-- Leaflet CSS -->
        <link rel="stylesheet" href="{ametys:pluginResourceURL('leaflet', 'css/leaflet.css')}"/>
	</xsl:template>	
    
    <xsl:template name="common-content-head-js">
         <script src="{ametys:skinURL('richtext/js/ametys-richtext.js')}"></script>
        
         <script src="{ametys:skinURL('zones/search/js/ametys-invoker-change-text.js')}"></script>
         
         <script type="text/javascript" src="{ametys:pluginResourceURL('odf-web', 'js/cart/Cart.js')}"></script>
         
         <!-- Leaflet JS -->
         <script type="text/javascript" src="{ametys:pluginResourceURL('leaflet', 'js/leaflet.js')}"></script>
         <script src="{ametys:skinURL('templates/common/js/ametys-marker.js')}"></script>
         
         <xsl:call-template name="common-content-head-additional-js"/>
    </xsl:template>
    
    <xsl:template name="common-content-head-additional-js"/>
	
</xsl:stylesheet>
