<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2019 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
        xmlns:xalan="http://xml.apache.org/xalan"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:odf="org.ametys.plugins.odfweb.xslt.OdfXSLTHelper"
        xmlns:escaper="org.apache.commons.lang.StringEscapeUtils"
        xmlns:docbook="http://docbook.org/ns/docbook" 
        xmlns:exslt="http://exslt.org/common"
        exclude-result-prefixes="sitemap ametys resolver odf escaper docbook exslt">
    
    <xsl:import href="plugin:odf://pages/helper/skills.xsl"/>
    
    <xsl:template match="skills" mode="display">
        <xsl:variable name="hiddenSkills" select="odf:areSkillsUnavailable(/view/content/@id, ametys:pageId())"/>
        <xsl:if test="skillSet and not($hiddenSkills)">
            <section class="g-mb-40">
                                                    
                <h2 class="ametys-section-sub-title ametys-section-sub-title--has-line g-mb-30"><i18n:text i18n:key="PROGRAM_SKILLS" i18n:catalogue="skin.{$skin}"/></h2>
            
                <xsl:apply-templates select="skillSet" mode="display"/>
                
                <!-- Skills table -->
                <xsl:call-template name="program-skills">
                    <xsl:with-param name="currentProgramItem" select="/view/structure/*[@id = /view/content/@id]"/>
                </xsl:call-template>
            </section>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="skillSet" mode="display">
        <div class="ametys-richtext">
            <p>
                <strong><xsl:value-of select="@title"/></strong>
            </p>
        </div>
                                                
        <xsl:call-template name="skill-badges">
            <xsl:with-param name="skills" select="skill"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="program-skills">
        <xsl:param name="currentProgramItem"/>
        
        <xsl:if test="/view/skills/skillSet">
            <div class="ametys-skill-btn g-mt-30">
                <a class="download" id="popup-skills-invoker" href="#" data-src="#popup-skills"><i18n:text i18n:key="PROGRAM_SEE_SKILLS_TABLE" i18n:catalogue="skin.{$skin}"/></a>
            </div>
            
            <div id="popup-skills" class="ametys-popup ametys-popup--small-close-btn" style="display: none; max-width: 95%; max-height: 90%; min-height: 300px;">
            
                <div class="ametys-popup-content g-py-25 g-px-20">
                    <h2 class="ametys-section-sub-title"><i18n:text i18n:key="PROGRAM_SKILLS_TABLE" i18n:catalogue="skin.{$skin}"/></h2>
                     
                    <xsl:variable name="years" select="$currentProgramItem//container[attributes/nature/@code='annee'and not(@excludedFromSkills) and not(ancestor::*/@excludedFromSkills = 'true')]"/>
            
                    <div class="ametys-skills-table__wrapper" style="overflow: auto">
                        <xsl:choose>
                            <xsl:when test="$years">
                                <xsl:call-template name="skills-table">
                                    <xsl:with-param name="skills" select="/view/skills"/>
                                    <xsl:with-param name="years" select="$years"/>
                                    <xsl:with-param name="additionalCls">table</xsl:with-param>
                                </xsl:call-template>
                            </xsl:when>
                            <xsl:otherwise>
                                 <xsl:call-template name="skills-table">
                                    <xsl:with-param name="skills" select="/view/skills"/>
                                    <xsl:with-param name="semesters" select="$currentProgramItem//container[attributes/nature/@code='semestre' and not(@excludedFromSkills)]"/>
                                    <xsl:with-param name="additionalCls">table</xsl:with-param>
                                </xsl:call-template>
                            </xsl:otherwise>
                        </xsl:choose>
                    </div>
                </div>
            </div>
            <script type="text/javascript">
                $j.HSCore.components.HSPopup.init('#popup-skills-invoker', {
    				touch: false,
    				autoFocus: false
    			});
                
                __popupSkillsInitialized = false;
                
               $j('#popup-skills-invoker').on('click', function() {
               
                   var tableWrap = $j('.ametys-skills-table__wrapper'),
                        popupContent = tableWrap.parent(),
                        popup = popupContent.parent(),
                        popupHeight = popup.innerHeight(),
                        titleHeight = popupContent.find('.ametys-section-sub-title').outerHeight(true);
                        
                   popupContent.outerHeight(popupHeight);     
                   tableWrap.outerHeight(popupContent.height() - titleHeight);  
                       
                   if (!__popupSkillsInitialized)
                   {
                       var table = tableWrap.find('table');
                       var head01Top = table.find("thead > tr:nth-child(1) > th:nth-child(1)").position().top;
                       table.find("thead > tr:nth-child(1) > th").css('top', head01Top);
                       table.find("thead > tr:nth-child(1) > th").css('position', 'sticky');
                       
                       var head02Top = table.find("thead > tr:nth-child(2) > th:nth-child(1)").position().top;
                       table.find("thead > tr:nth-child(2) > th").css('top', head02Top);
                       table.find("thead > tr:nth-child(2) > th").css('position', 'sticky');
                       
                       var head03Top = table.find("thead > tr:nth-child(3) > th:nth-child(1)").position().top;
                       table.find("thead > tr:nth-child(3) > th").css('top', head03Top);
                       table.find("thead > tr:nth-child(3) > th").css('position', 'sticky');
                       
                       table.find("thead > tr > th:nth-child(1)").css('left', 0);
                       table.find("thead > tr > th:nth-child(1)").css('z-index', 10);
                       
                       
                       var head01Left = table.find("tbody > tr:nth-child(1) > th:nth-child(1)").position().left;
                       var head02Left = table.find("tbody > tr:nth-child(1) > th:nth-child(2)").position().left;
                       
                       table.find("tbody > tr > th").css('left', head02Left);
                       table.find("tbody > tr > th[rowspan]").css('left', head01Left);
                       table.find("tbody > tr > th").css('position', 'sticky');
                       table.find("tbody > tr > th").css('z-index', 5);
                       
                       __popupSkillsInitialized = true;
                    }
               }); 
            </script>
        </xsl:if>
    </xsl:template>
    
</xsl:stylesheet>