<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        exclude-result-prefixes="ametys resolver">

    <xsl:template name="categories-carousel">
        <xsl:param name="items"/>
        <xsl:param name="metadataName">domain</xsl:param>
        <xsl:param name="inputFacetPrefix">user.input.facet.ContentReturnable$</xsl:param>
        <xsl:param name="inputDefinitionPrefix">ProgramSearchable$indexingField$org.ametys.plugins.odf.Content.program$</xsl:param>
        
        <xsl:variable name="count" select="count($items/item[@code != 'HD'])"/>
        <xsl:variable name="visibleElmts">
            <xsl:choose>
                <xsl:when test="$count &gt; 6">6</xsl:when><!-- max of 6 visible elements  -->
                <xsl:when test="$count &lt;= 4">4</xsl:when><!-- no slide for less than 4 elements -->
                <xsl:otherwise><xsl:value-of select="$count - 1"/></xsl:otherwise><!-- force slide for 5 and 6 elements -->
            </xsl:choose>
        </xsl:variable>
        
        <div id="categoriesCarousel" class="js-carousel ametys-categories" style="max-width: 920px;"
                             data-speed="4000"
                             data-autoplay="false"
                             data-infinite="true"
                             data-center-mode="true"
                             data-center-padding="5px"
                             data-slides-show="{$visibleElmts}"
                             data-slides-scroll="{$visibleElmts}"
                             data-arrows-classes="ametys-arrow ametys-arrow--light"
                             data-arrow-left-classes="ametys-arrow--right fa fa-angle-left"
                             data-arrow-right-classes="ametys-arrow--left fa fa-angle-right">
           <xsl:attribute name="data-responsive">[{
             "breakpoint": 992,
             "settings": {
               "slidesToShow": 4,
               "slidesToScroll": 4
             }
           }, {
             "breakpoint": 768,
             "settings": {
               "slidesToShow": 3,
               "slidesToScroll": 3
             }
           }, {
             "breakpoint": 576,
             "settings": {
               "slidesToShow": 2,
               "slidesToScroll": 2
             }
           }]
           </xsl:attribute>
           
            <xsl:for-each select="$items/item[@code != 'HD']">
                <div class="js-slide">
                    <form action="{$odfSearchPageUri}">
                        <input type="hidden" name="{concat($inputFacetPrefix, $inputDefinitionPrefix, $metadataName)}" value="{@id}"/>
                        <input type="hidden" name="submit-form" value="true"/>
                        <a class="ametys-categories__item" href="#" onclick="$j(this).parent('form').submit()">
                            <xsl:call-template name="categories-carousel-item-icon"/>
                            <xsl:call-template name="categories-carousel-item-title"/>
                        </a>
                    </form>
                </div>
            </xsl:for-each>
        </div>
        
        <script>
            $.HSCore.components.HSCarousel.init('#categoriesCarousel');
        </script>
    </xsl:template>
    
    <xsl:template name="categories-carousel-item-icon">
        <span class="ametys-categories__item-icon">
            <xsl:variable name="iconUrl" select="concat('templates/common/fonts/ametys-icons/svg/', @code, '.svg')"/>
            <img src="{ametys:skinURL($iconUrl)}" alt=""/>
        </span>
    </xsl:template>
    
    <xsl:template name="categories-carousel-item-title">
        <h6 class="ametys-categories__item-title"><xsl:value-of select="@title"/></h6>
    </xsl:template>
    
</xsl:stylesheet>