<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2021 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                exclude-result-prefixes="resolver ametys i18n">

    <xsl:variable name="uri-prefix" select="ametys:uriPrefix()"/>
    <xsl:variable name="skin" select="ametys:skin()"/>
    
    <xsl:template match="/">
        <html xmlns="http://www.w3.org/1999/xhtml">
            <head>
                <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
                
                <xsl:call-template name="welcome-head-css"/>
                <xsl:call-template name="welcome-head-title"/>
            </head>
            <body>
                <xsl:call-template name="welcome-body"/>
            </body>
        </html>
    </xsl:template>
    
    <xsl:template name="welcome-head-title">
        <title>Help</title>
    </xsl:template>
    
    <xsl:template name="welcome-head-css">
        <link type="text/css" href="{ametys:skinURL('templates/common/scss/main.css')}" rel="stylesheet" media="screen" />
        <link rel="stylesheet" href="{ametys:pluginResourceURL('fontawesome6-free', 'css/all.css')}" />
        
        <link type="text/css" href="{ametys:skinURL('css/welcome/layout.css')}" rel="stylesheet" media="screen"/>
        <link type="text/css" href="{ametys:skinURL('css/welcome/print.css')}" rel="stylesheet" media="print" />
    </xsl:template>
    
    <xsl:template name="welcome-body">
        
        <xsl:call-template name="welcome-body-frame"/>
        
        <xsl:call-template name="print"/>
        
        <xsl:call-template name="main-presentation"/>
        
        <xsl:call-template name="get-started"/>
        
        <xsl:call-template name="skin-presentation"/>                 
    </xsl:template>
    
    <xsl:template name="welcome-body-frame">
        <div class="frame">
            <xsl:call-template name="ametys-community"/>
        </div>
    </xsl:template>
    
    <xsl:template name="ametys-community">
        <h2>Community</h2>
        <p>Ametys is Open Source, you can see the documentation and contribute here:</p>
        <ul>
            <li><a target="_blank" href="http://www.ametys.org/forum">Ametys Forum</a></li>
            <li><a target="_blank" href="http://docs.ametys.org/">Ametys Documentations</a></li>
            <li><a target="_blank" href="https://issues.ametys.org/browse/ODF">Issues and enhancement tool</a></li>
        </ul>
        <p>Visit also the Ametys website <a target="_blank" href="http://www.ametys.org">www.ametys.org</a>.</p>
    </xsl:template>
    
    <xsl:template name="print">
        <div class="print">
            <a href="javascript:window.print()" title="Imprimer"><i class="fas fa-print"/></a>
        </div>
    </xsl:template>
    
    <xsl:template name="main-presentation">
        <h1>Welcome to Ametys ODF</h1>
        <p>
            You are in the contributor workspace of the <strong>Ametys ODF</strong>.
        </p>
        
        <p>
            There are 3 connectors in Ametys for import and synchronization of training offer:
            <ul>
                <li><strong>Apogée</strong> : import and synchronization of programs with the Apogée base</li>
                <li><strong>CDM-fr/ROF</strong> : import and synchronization of programs with the XML files to CDM-fr format</li>
                <li><strong>Pégase</strong> : import and synchronization of programs with the Pégase application</li>
            </ul>
         </p>
         
         <p>
            Also, there are 2 connectors to export the training offer from Ametys:
            <ul>
                <li><strong>Pégase</strong> : export training offer and associated supported data by Pégase</li>
                <li><strong>OSE</strong> : export training offer and steering data to OSE</li>
            </ul>
         </p>
    </xsl:template>
    
    <xsl:template name="get-started">
        <h1>Get started</h1>
        <p>
            Use the <b><i>Sitemap</i></b> tool on the left to create or alter page.
            <br />
            Click twice on a page to open it. 
        </p>
        
        <h1>Need help?</h1>
        <p>Use the "Search a feature" search bar of the ribbon.<br/>
        Use the online help by pressing the <strong>F1 key </strong>on hover of a button or tool, or by clicking on the link <strong>Know more</strong> of tooltips
        </p>
        
    </xsl:template> 
    
    <xsl:template name="skin-presentation">
        <h1>Templates</h1>
        <h2>Home</h2>
        <img src="{$uri-prefix}/skins/{$skin}/templates/index/resources/thumbnail.png" alt="Page d'accueil" class="floatleft" />
        <p>
            The <i>home</i> template is only for the home page, named "index". <br/>
            This template is composed of 2 zones:
            <ul>
                <li>a header zone for search engine</li>
                <li>a main zone: it can contain editorial text, a presentation video, the training scheme, etc...</li>
            </ul>
            
            The other graphic elements that make up the home page are: 
            <ul>
                <li>a carousel of domains</li>
                <li>the favorites links or tools</li>
                <li>a carousel of orgunits</li>
            </ul>
        </p>
        <br style="clear:both"/>
            <h2>Page</h2>
            <img src="{$uri-prefix}/skins/{$skin}/templates/page/resources/thumbnail.png" alt="Page" class="floatleft" />
            <p>The <i>page</i> template is used for the majority of other pages. <br/>
                It has only one main zone. <br/>
                 The other graphic elements that make up this template are: 
            <ul>
                 <li>Banner: the banner consists of a fixed image. It is not
                     not possible to modify it </li>
                 <li>Navigation: The banner of the main sections is
                     automatically built, with the pages
                     tagged as "Main section". </li>
                 <li>Footer: Footer links are made up of pages tagged "Catalog", "Direct Access" and "Other Links".
                 </li>
             </ul> 
            </p>
        <div class="clear-L"></div>
    </xsl:template>
    
</xsl:stylesheet>
