/**
 * Limited content wrapper.
 *
 * @author Htmlstream
 * @version 1.0
 *
 */
;(function ($) {
  'use strict';

  $.HSCore.components.HSLimitedContent = {
    /**
     *
     *
     * @var Object _baseConfig
     */
    _baseConfig: {
      bodySelector: '.u-limited-content__body',
      btnSelector: '.u-limited-content__btn',
      btnOpenedClass: 'opened'
    },

    /**
     *
     *
     * @var jQuery pageCollection
     */
    pageCollection: $(),

    /**
     * Initialization of Limited content wrapper.
     *
     * @param String selector (optional)
     * @param Object config (optional)
     *
     * @return jQuery pageCollection - collection of initialized items.
     */

    init: function (selector, config) {

      this.collection = selector && $(selector).length ? $(selector) : $();
      if (!$(selector).length) return;

      this.config = config && $.isPlainObject(config) ?
        $.extend({}, this._baseConfig, config) : this._baseConfig;

      this.config.itemSelector = selector;

      this.initLimitedContent();

      return this.pageCollection;

    },

    initLimitedContent: function () {
      //Variables
      var $self = this,
        config = $self.config,
        collection = $self.pageCollection;

      //Actions
      this.collection.each(function (i, el) {
        //Variables
        var $this = $(el),
          $body = $this.find(config.bodySelector),
          $invoker = $this.find(config.btnSelector),
  
          bodyMaxHeight = $body.outerHeight(), // 215
          bodyMaxHeightInitial = $this.data('max-height'), // 220
          bodyMaxHeightMinus = 20, // Ametys add-on to avoid that a text that exceed max height for some pixels does not appears with a blur on the last phrase
  
          bodyIsOpened = false;
  
		  if (bodyMaxHeight < bodyMaxHeightInitial) {
			$body.addClass('ametys-limited-content__body--destoryed');
            bodyIsOpened = true;
		  }

          $body.css({
             maxHeight: bodyMaxHeightInitial - bodyMaxHeightMinus < bodyMaxHeight && bodyIsOpened ? bodyMaxHeight :  bodyMaxHeightInitial - bodyMaxHeightMinus // 220  - 20  = 200 => il manque 15 pixels
          });
  
        $invoker.on('click', function(e) {
    
          e.preventDefault();
    
          if(bodyIsOpened) {
  
            $(this).addClass('closed');
            $this.removeClass('opened');
      
            $body.css({
              maxHeight: bodyMaxHeightInitial - bodyMaxHeightMinus
            });
      
            bodyIsOpened = false;
      
          } else {
  
            $(this).removeClass('closed');
            $this.addClass('opened');
      
            $body.css({
              maxHeight: 'none'
            });
      
            bodyIsOpened = true;
      
          }
    
        });

        //Actions
        collection = collection.add($this);
      });
    }
  };
})(jQuery);