/**
 * HSScrollNavAlt Component.
 *
 * @author Htmlstream
 * @version 1.0
 * @requires jQuery
 *
 */
;(function ($) {
  'use strict';

  $.HSCore.components.HSScrollNavAlt = {

    /**
     * Base configuraion of the component.
     *
     * @private
     */
    _baseConfig: {
      duration: 400,
      easing: 'linear',
      over: $(),
      activeItemClass: 'active',
      afterShow: function(){},
      beforeShow: function(){},
      itemsOffsetLeft: [],
      itemOffsetC: 15
    },

    /**
     * All initialized item on the page.
     *
     * @private
     */
    _pageCollection: $(),


    /**
     * Initialization of the component.
     *
     * @param {jQuery} collection
     * @param {Object} config
     *
     * @public
     * @return {jQuery}
     */
    init: function(collection, config) {

      var self = this;

      if( !collection || !collection.length ) return $();

      collection.each(function(i, el) {

        var $this = $(el),
            itemConfig = config && $.isPlainObject(config) ?
                         $.extend(true, {}, self._baseConfig, config, $this.data()) :
                         $.extend(true, {}, self._baseConfig, $this.data());

        if( !$this.data('HSScrollNavAlt') ) {

          $this.data('HSScrollNavAlt', new HSScrollNavAlt($this, itemConfig));

          self._pageCollection = self._pageCollection.add( $this );

        }

      });

      $(window).on('scroll.HSScrollNavAlt', function(){

        self._pageCollection.each(function(i, el) {

          $(el).data('HSScrollNavAlt').highlight();

        });

      }).trigger('scroll.HSScrollNavAlt');

      return collection;

    }

  }


  /**
   * HSScrollNavAlt.
   *
   * @param {jQuery} element
   * @param {Object} config
   *
   * @constructor
   */
  function HSScrollNavAlt(element, config) {

    /**
     * Current element.
     *
     * @public
     */
    this.element = element;

    /**
     * Configuraion.
     *
     * @public
     */
    this.config = config;

    /**
     * Sections.
     *
     * @public
     */
    this._items = $();

    this._makeItems();
    this._bindEvents();
  }

  /**
   * Return collection of sections.
   *
   * @private
   * @return {jQuery}
   */
  HSScrollNavAlt.prototype._makeItems = function() {

    var self = this,
      config = self.config;

    this.element.find('a[href^="#"]').each(function(i, el) {

      var $this = $(el);
  
      config.itemsOffsetLeft.push($this.parent('li').offset().left);

      if( !$this.data('HSScrollNavAltSection') ) {

        $this.data('HSScrollNavAltSection', new HSScrollNavAltSection($this, self.config));

        self._items = self._items.add( $this );

      }

    });

  };

  /**
   * Binds necessary events.
   *
   * @private
   * @return {undefined}
   */
  HSScrollNavAlt.prototype._bindEvents = function() {

    var self = this;

    this.element.on('click.HSScrollNavAlt', 'a[href^="#"]', function(e) {

      var link = this;
      self._lockHightlight = true;
      if(self.current) self.current.unhighlight();
      link.blur();
      self.current = $(link).data('HSScrollNavAltSection');
      self.current.highlight();

      $(this).data('HSScrollNavAltSection').show( function(){
        self._lockHightlight = false;
      } );

      e.preventDefault();

    });

  };

  /**
   * Activates necessary menu item.
   *
   * @public
   */
  HSScrollNavAlt.prototype.highlight = function() {

    var self = this, items, currentItem, current, scrollTop;

    if(!this._items.length || this._lockHightlight) return;

    scrollTop = $(window).scrollTop();

    if(scrollTop + $(window).height() === $(document).height()) {

      this.current = this._items.last().data('HSScrollNavAltSection');

      this.unhighlight();
      this.current.highlight();

      return;
    }

    this._items.each(function(i, el){

      var Section = $(el).data('HSScrollNavAltSection'),
          $section = Section.section;

      if(scrollTop > Section.offset) {
        current = Section;
      }

    });

    if(current && this.current != current) {

      this.unhighlight();
      current.highlight();

      this.current = current;

    }

  };

  /**
   * Deactivates all menu items.
   *
   * @public
   */
  HSScrollNavAlt.prototype.unhighlight = function() {

    this._items.each(function(i, el){
      $(el).data('HSScrollNavAltSection').unhighlight();
    });

  };

  /**
   * HSScrollNavAltSection.
   *
   * @param {jQuery} element
   *
   * @constructor
   */
  function HSScrollNavAltSection(element, config) {

    var self = this;

    /**
     * Current section.
     *
     * @public
     */
    this.element = element;

    /**
     * Configuration.
     *
     * @public
     */
    this.config = config;

    /**
     * Getter for acces to the section element.
     *
     * @public
     */
    Object.defineProperty(this, 'section', {
      value: $(self.element.attr('href'))
    });

    /**
     * Getter for determinate position of the section relative to document.
     *
     * @public
     */

    Object.defineProperty(this, 'offset', {
      get: function() {

        var header = $('.ametys-header'),
            headerStyles = getComputedStyle(header.get(0)),
            headerPosition = headerStyles.position,
            offset = self.section.offset().top;



        if(header.length && headerPosition == 'fixed' && parseInt(headerStyles.top) == 0) {
          offset = offset - header.outerHeight() - parseInt(headerStyles.marginTop);
        }

        if(self.config.over.length) {
          offset = offset - self.config.over.outerHeight();
        }

        return offset;
      }
    });


  }

  /**
   * Moves to the section.
   *
   * @public
   */
  HSScrollNavAltSection.prototype.show = function(callback) {

    var self = this;

    if( !this.section.length ) return;

    self.config.beforeShow.call(self.section);

    $('html, body').stop().animate({
      scrollTop: self.offset + 3
    }, {
      duration: self.config.duration,
      easing: self.config.easing,
      complete: function() {
        $('html, body').stop().animate({
          scrollTop: self.offset + 3
        }, {
          duration: self.config.duration,
          easing: self.config.easing,
          complete: function() {
            self.config.afterShow.call(self.section);
            if($.isFunction(callback)) callback();
          }
        });
      }
    });

  };

  /**
   * Activates the menu item.
   *
   * @public
   */
  HSScrollNavAltSection.prototype.highlight = function() {

    var self = this,
      config = self.config,
      
      mainParent = self.element.parents('ul'),
      parent = self.element.parent('li');
    
    if(parent.length) parent.addClass(this.config.activeItemClass);
    
    if (mainParent[0].offsetWidth < mainParent[0].scrollWidth) {
  
      $(mainParent).animate({
        scrollLeft: config.itemsOffsetLeft[parent.index()] - config.itemOffsetC
      }, 600);
      
    }
  
  };

  /**
   * Deactivates the menu item.
   *
   * @public
   */
  HSScrollNavAltSection.prototype.unhighlight = function() {

    var parent = this.element.parent('li');
    if(parent.length) parent.removeClass(this.config.activeItemClass);

  };



})(jQuery);
