/**
 * Step form wrapper.
 *
 * @author Htmlstream
 * @version 1.0
 *
 */
;(function ($) {
	'use strict';
	
	$.HSCore.components.HSStepForm = {
		/**
		 *
		 *
		 * @var Object _baseConfig
		 */
		_baseConfig: {
			beforeSend: function () {},
			onComplete: function () {},
			onSuccess: function () {},
			onError: function () {},
			onNextStep: function () {}
		},
		
		/**
		 *
		 *
		 * @var jQuery pageCollection
		 */
		pageCollection: $(),
		
		/**
		 * Initialization of Step form wrapper.
		 *
		 * @param String selector (optional)
		 * @param Object config (optional)
		 *
		 * @return jQuery pageCollection - collection of initialized items.
		 */
		
		init: function (selector, config) {
			
			this.collection = selector && $(selector).length ? $(selector) : $();
			if (!$(selector).length) return;
			
			this.config = config && $.isPlainObject(config) ?
				$.extend({}, this._baseConfig, config) : this._baseConfig;
			
			this.config.itemSelector = selector;
			
			this.initStepForm();
			
			return this.pageCollection;
			
		},
		
		initStepForm: function () {
			//Variables
			var $self = this,
				config = $self.config,
				collection = $self.pageCollection;
			
			//Actions
			this.collection.each(function (i, el) {
				//Variables
				var $this = $(el),
					$form = $this.find('form'),
					$invoker = $this.find('[data-show-section]'),
					$progressItem = $this.find('[data-progress-item-for]');
				
				$invoker.on('click', function (e) {
					var $this = $(this),
						showSectionID = $this.data('show-section'),
						hideSectionID = $this.data('hide-section'),
						isForValidating = Boolean($this.data('is-for-validating'));
					
					if (!$form.valid() && isForValidating) {
						
						return false;
						
					}
					
					e.preventDefault();
					
					$(hideSectionID).hide();
					$(showSectionID).fadeIn(400, function() {
						
						config.onNextStep(showSectionID);
						
					});
					
					$progressItem.removeClass('active');
					$progressItem.each(function () {
						
						if (JSON.parse($(this).attr('data-progress-item-for')).includes(showSectionID)) {
							
							$(this).addClass('active');
							
						}
						
					});
					
				});
				
				$form.on('submit', function (e) {
					
					$.ajax({
						type: $form.attr('method'),
						url: $form.attr('action'),
						data: $form.serialize(),
						beforeSend: function(data) {
							config.beforeSend(data);
						},
						complete: function(data) {
							config.onComplete(data);
						},
						success: function (data) {
							config.onSuccess(data);
						},
						error: function (data) {
							config.onError(data);
						}
					});
					
					e.preventDefault();
					
				});
				
				//Actions
				collection = collection.add($this);
			});
		}
		
	};
	
})(jQuery);
