/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
 
;(function ($) {
  'use strict';

  var AmetysSearchAutocomplete = window.AmetysSearchAutocomplete || {};

  AmetysSearchAutocomplete = (function () {

    function AmetysSearchAutocomplete(element, options) {

      var $self = this;

      /**
       * Current element.
       *
       * @public
       */
      this.$element = $(element);

      /**
       * Current options set by the caller including defaults.
       *
       * @public
       */
      $self.options = $.extend(true, {}, AmetysSearchAutocomplete.defaults, options);

      this.initialize();

    }

    return AmetysSearchAutocomplete;

  }());

  AmetysSearchAutocomplete.defaults = {
    containerSelector: null,
    autocompleteTargetSelector: null,
    autocompletePagesSelector: null,
    autocompleteSkillsSelector: null,
    autocompleteTagsSelector: null,
    autocompleteServerUrl: null,
    autocompleteSiteName: null,
    autocompleteLang: null,
    autocompleteZoneItemId: null,
    searchUrl: null,
    openPageResultsInNewTab: false
  };

  /**
   * Initialization of the plugin.
   *
   * @protected
   */
  AmetysSearchAutocomplete.prototype.initialize = function () {
    // vars
    var $self = this,
        search = $self.$element[0].id,
        target = null,
        searchTimeout = null;

    $self.options.containerSelector = '#' + $self.$element[0].id;

    $self.options.autocompleteTargetSelector = $self.options.containerSelector + ' [data-autocomplete-target]';
    $self.options.autocompletePagesSelector = $self.options.containerSelector + ' [data-autocomplete-data="pages"]';
    $self.options.autocompleteSkillsSelector = $self.options.containerSelector + ' [data-autocomplete-data="skills"]';
    $self.options.autocompleteTagsSelector = $self.options.containerSelector + ' [data-autocomplete-data="tags"]';

    $($self.options.autocompleteTargetSelector).on('keyup', function () {
            
            if (searchTimeout != null) {
			    clearTimeout(searchTimeout);
			}

            var $this = $(this);
            var me = this;
			  
            searchTimeout = setTimeout(function() {
                searchTimeout = null;  
    
	            target = $this.data('autocomplete-target');
	            
	            var $target = $(target),
	                
	                $pages = $($self.options.autocompletePagesSelector),
	                $skills = $($self.options.autocompleteSkillsSelector),
	                $tags = $($self.options.autocompleteTagsSelector),
	                
	                pages = [],
	                skills = [],
	                tags = [],
                    
                    openPageResultsInNewTab = $self.options.openPageResultsInNewTab;
	            
	            // Show / Hide
	            if ($this.val().length > 2) {
	                
	                var params = {
	                    q: $this.val(),
	                    siteName: $self.options.autocompleteSiteName,
	                    lang: $self.options.autocompleteLang,
	                    zoneItemId: $self.options.autocompleteZoneItemId
	                }
	                // Fetch data
	                $.getJSON($self.options.autocompleteServerUrl, params).done(function (data) {
	                    
	                    if (data.pages && $pages) {
	                        
	                        $.each(data.pages, function (i) {
	                            
	                            pages.push('<li class="ametys-search-form-dropdown-content-list__item">' +
	                                '<a class="ametys-search-form-dropdown-content-list__link" href="' + data.pages[i].url + (!openPageResultsInNewTab || data.pages[i].url.indexOf("javascript:") == 0 ? '">' : '" target="_blank">') +
	                                '<span class="ametys-search-form-dropdown-content-list__item-icon fas fa-share"></span>' + data.pages[i].title + '' +
	                                '</a>' +
	                                '</li>');
	                            
	                        });
	                        
	                        $pages.html(pages.join(''));
	                        
	                    }
	                    
	                    if (data.skills && $skills) {
	                        
	                        $.each(data.skills, function (i) {
	                            
	                            skills.push('<li class="ametys-search-form-dropdown-content-list__item">' +
	                                '<a class="ametys-search-form-dropdown-content-list__link" href="' + $self.options.searchUrl + '?submit-form=&skillId=' + data.skills[i].id + '">' + data.skills[i].title + '</a>' +
	                                '</li>');
	                            
	                        });
	                        
	                        $skills.html(skills.join(''));
	                        
	                    }
	                    
	                    if (data.tags && $tags) {
	                        
	                        $.each(data.tags, function (i) {
	                            
	                            tags.push('<li class="ametys-checkbox-badge">' +
	                                '<a class="ametys-checkbox-badge__label" href="' + $self.options.searchUrl + '?submit-form=&tagId=' + data.tags[i].id + '">' + data.tags[i].title + '</a>' +
	                                '</li>');
	                            
	                        });
	                        
	                        $tags.html(tags.join(''));
	                        
	                    }
	                    
	                });
	                
	                // End Fetch data
	                
	                $target.fadeIn(200);
	                
	            } else {
	                
	                pages = [];
	                skills = [];
	                tags = [];
	                
	                $target.fadeOut(200, function () {
	                    
	                    if ($pages) $pages.html('');
	                    
	                    if ($skills) $skills.html('');
	                    
	                    if ($tags) $tags.html('');
	                    
	                });
	                
	            }
	            
	            // End Show / Hide
            }, 500);
        });
        
    // Hide
    $(document).on('click', 'body', function (e) {
    
        var $target = $(e.target).parents(target),
            $search = $(e.target).parents(search);
    
            if (($target.length === 1) || ($search.length === 1)) {
                return 0;
            } else {
                $(target).fadeOut(200);
            }
    });
  };

  $.fn.HSAmetysSearchAutocomplete = function () {

    var _ = this,
      opt = arguments[0],
      args = Array.prototype.slice.call(arguments, 1),
      l = _.length,
      i,
      ret;

    for (i = 0; i < l; i++) {
      if (typeof opt == 'object' || typeof opt == 'undefined') {

        _[i].AmetysSearchAutocomplete = new AmetysSearchAutocomplete(_[i], opt);

      } else {

        ret = _[i].AmetysSearchAutocomplete[opt].apply(_[i].AmetysSearchAutocomplete, args);

      }

      if (typeof ret != 'undefined') {

        return ret;

      }
    }

    return _;

  };

})(jQuery);