;(function ($) {
  'use strict';

  var AmetysToggle = window.AmetysToggle || {};

  AmetysToggle = (function () {

    function AmetysToggle(element, options) {

      var $self = this;

      /**
       * Current element.
       *
       * @public
       */
      this.$element = $(element);

      /**
       * Current options set by the caller including defaults.
       *
       * @public
       */
      $self.options = $.extend(true, {}, AmetysToggle.defaults, options);

      this.initialize();

    }

    return AmetysToggle;

  }());

  AmetysToggle.defaults = {
    containerSelector: null,
    toggleTargetSelector: null,
    toggleInvokerSelector: null,
    isOpened: false
  };

  /**
   * Initialization of the plugin.
   *
   * @protected
   */
  AmetysToggle.prototype.initialize = function () {
    // vars
    var $self = this;

    $self.options.containerSelector = '#' + $self.$element[0].id;

    $self.options.toggleTargetSelector = $self.options.containerSelector + ' [data-toggle-target]';
    $self.options.toggleInvokerSelector = $self.options.containerSelector + ' [data-toggle-invoker]';

    function toggle(e) {
      
      e.stopPropagation();
      
      if (!$self.options.isOpened) {

        $($self.options.toggleTargetSelector).fadeIn(200);

        $self.options.isOpened = true;

      } else {

        $($self.options.toggleTargetSelector).fadeOut(200);

        $self.options.isOpened = false;

      }
    }
    
    document.querySelector($self.options.toggleInvokerSelector).addEventListener('click', toggle);
  
    // $(document).on('click touchstart', 'body', function(e) {
    //
    //   if (window.innerWidth > 768) return false;
    //
    //   var $target = $(e.target).parents($self.options.toggleTargetSelector),
    //     $invoker = $(e.target).parents($self.options.toggleInvokerSelector);
    //
    //   if (($invoker.length === 1) || ($target.length === 1)) {
    //
    //     return false;
    //
    //   } else {
    //
    //     $($self.options.toggleTargetSelector).fadeOut(200);
    //
    //     $self.options.isOpened = false;
    //
    //   }
    //
    // });

    return this;

  };

  AmetysToggle.prototype.reset = function () {

    var $self = this,
      $target = $($self.options.toggleTargetSelector);

    $target.css('display', '');

  };

  $.fn.HSAmetysToggle = function () {

    var _ = this,
      opt = arguments[0],
      args = Array.prototype.slice.call(arguments, 1),
      l = _.length,
      i,
      ret;

    for (i = 0; i < l; i++) {
      if (typeof opt == 'object' || typeof opt == 'undefined') {

        _[i].AmetysToggle = new AmetysToggle(_[i], opt);

      } else {

        ret = _[i].AmetysToggle[opt].apply(_[i].AmetysToggle, args);

      }

      if (typeof ret != 'undefined') {

        return ret;

      }
    }

    return _;

  };

})(jQuery);
