(function ($) {
	
	function stickyHeader() {
		var $header = $('.ametys-header'),
			$target = $('#pageNavWrap'),
			$nav = $('#pageNav');
		
		if (!$target.length) return;
		
		$(window).on('scroll', function () {
			var $this = $(this),
				scrollTop = $this.scrollTop(),
				headerHeight = $header.outerHeight(),
				targetOffsetTop = $target.offset().top;
			
			if ((scrollTop + headerHeight) >= targetOffsetTop) {
				
				// $nav.css({
				// 	position: 'fixed',
				// 	top: $(window).innerWidth() >= 769 ? ((targetOffsetTop - scrollTop) >= 0 ? (targetOffsetTop - scrollTop) : 0) : headerHeight
				// });
				//
				// $header.css({
				// 	top: $(window).innerWidth() >= 769 ? (-((scrollTop + headerHeight) - targetOffsetTop)) : 0,
				// 	boxShadow: 'none'
				// });
				
				$nav.css({
					position: 'fixed',
					top: (targetOffsetTop - scrollTop) >= 0 ? (targetOffsetTop - scrollTop) : 0
				});
				
				$header.css({
					top: -((scrollTop + headerHeight) - targetOffsetTop),
					boxShadow: 'none'
				});
				
			} else {
				
				$nav.css({
					position: '',
					top: ''
				});
				
				$header.css({
					top: '',
					boxShadow: ''
				});
				
			}
			
		});
		
	}
	
	var isEventListenerAdded = false;
	
	function widget(el) {
		
		var widget = document.querySelector(el),
			$contents = $(widget).find('.collapse'),
			$autoCollapseItems = $(widget).find('.collapse.auto-collapse:not(.show)');
		
		function onMouseEnter() {
			$(widget).addClass('hovered');
			
			$(widget).one('webkitTransitionEnd otransitionend oTransitionEnd msTransitionEnd transitionend', function () {
				
				if ($(widget).hasClass('animated')) return;
				
				$(widget).addClass('animated');
				
				setTimeout(function () {
					
					if ($(widget).hasClass('hovered')) {
						
						$autoCollapseItems.collapse('show');
						
					}
					
				}, 200);
				
			});
		}
		
		function onMouseLeave() {
			var $openedItems = $(widget).find('.collapse.show'),
				openedItemsL = $openedItems.length;
			
			if (openedItemsL) {
				
				$openedItems.collapse('hide');
				
				$openedItems.on('hidden.bs.collapse', function () {
					
					$(widget).removeClass('hovered animated');
					
				})
				
			} else {
				
				$(widget).removeClass('hovered animated');
				
			}
		}
		
		if (!$(widget).length) return;
		
		if ($(window).innerWidth() >= 769) {
			
			$contents.each(function () {
				
				$(this).insertAfter('[data-target="#' + $(this).attr('id') + '"]');
				$(this).removeClass('show');
				
			});
			
			if (!isEventListenerAdded) {
				
				isEventListenerAdded = true;
				
				widget.addEventListener('mouseenter', onMouseEnter);
				
				widget.addEventListener('mouseleave', onMouseLeave);
				
			}
			
		} else {
			
			$contents.appendTo('#widgetMobileContentInner');
			
			if (isEventListenerAdded) {
				
				isEventListenerAdded = false;
				
				widget.removeEventListener('mouseenter', onMouseEnter);
				
				widget.removeEventListener('mouseleave', onMouseLeave);
				
			}
			
		}
		
	}
	
	$(document).on('ready', function () {
		
		stickyHeader();
		
		$(window).trigger('scroll');
		
		$(window).trigger('resize');
		
	});
	
	$(window).on('resize', function () {
		
		stickyHeader();
		
		widget('.ametys-widget--sticky-right');
		
	});
	
})(jQuery);
