;(function ($) {
  'use strict';

  var AmetysInvokerChangeText = window.AmetysInvokerChangeText || {};

  AmetysInvokerChangeText = (function () {

    function AmetysInvokerChangeText(element, options) {

      var $self = this;

      /**
       * Current element.
       *
       * @public
       */
      this.$element = $(element);

      /**
       * Current options set by the caller including defaults.
       *
       * @public
       */
      $self.options = $.extend(true, {}, AmetysInvokerChangeText.defaults, options);

      this.initialize();

    }

    return AmetysInvokerChangeText;

  }());

  AmetysInvokerChangeText.defaults = {
    containerSelector: null,
    invokerSelector: null,
    invokerTextSelector: null,
    invokerIconSelector: null,
    closedCheckClass: 'collapsed'
  };

  /**
   * Initialization of the plugin.
   *
   * @protected
   */
  AmetysInvokerChangeText.prototype.initialize = function () {
    // vars
    var $self = this;

    $self.options.containerSelector = '#' + $self.$element[0].id;

    $self.options.invokerSelector = $self.options.containerSelector + ' [data-invoker]';
    $self.options.invokerIconSelector = '[data-invoker-icon]';
    $self.options.invokerTextSelector = '[data-invoker-text]';

    $($self.options.invokerSelector).each(function() {

      var $this = $(this),
        $thisText = $this.find($self.options.invokerTextSelector),
        $thisIcon = $this.find($self.options.invokerIconSelector),
        closeText = $this.data('close-text'),
        openText = $this.data('open-text'),
        closeIcon = $this.data('close-icon'),
        openIcon = $this.data('open-icon');

      $this.on('click', function() {

        setTimeout(function() {

          if (!$this.hasClass($self.options.closedCheckClass)) {

            $thisText.text(openText);
            $thisIcon.removeClass(closeIcon);
            $thisIcon.addClass(openIcon);

          } else {

            $thisText.text(closeText);
            $thisIcon.removeClass(openIcon);
            $thisIcon.addClass(closeIcon);

          }

        })

      });

    });

    return this;

  };

  $.fn.HSAmetysInvokerChangeText = function () {

    var _ = this,
      opt = arguments[0],
      args = Array.prototype.slice.call(arguments, 1),
      l = _.length,
      i,
      ret;

    for (i = 0; i < l; i++) {
      if (typeof opt == 'object' || typeof opt == 'undefined') {

        _[i].AmetysInvokerChangeText = new AmetysInvokerChangeText(_[i], opt);

      } else {

        ret = _[i].AmetysInvokerChangeText[opt].apply(_[i].AmetysInvokerChangeText, args);

      }

      if (typeof ret != 'undefined') {

        return ret;

      }
    }

    return _;

  };

})(jQuery);