;(function ($) {
  'use strict';

  var AmetysTags = window.AmetysTags || {};

  AmetysTags = (function () {

    function AmetysTags(element, options) {

      var $self = this;

      /**
       * Current element.
       *
       * @public
       */
      this.$element = $(element);

      /**
       * Current options set by the caller including defaults.
       *
       * @public
       */
      $self.options = $.extend(true, {}, AmetysTags.defaults, options);

      this.initialize();

    }

    return AmetysTags;

  }());

  AmetysTags.defaults = {
    containerSelector: null,
    tagsWrapSelector: null,
    tagsSelector: null,
    tagsItemSelector: null,
    tagsControlSelector: null
  };

  /**
   * Initialization of the plugin.
   *
   * @protected
   */
  AmetysTags.prototype.initialize = function () {
    // vars
    var $self = this;

    $self.options.containerSelector = '#' + $self.$element[0].id;

    $self.options.tagsWrapSelector = $self.options.containerSelector + ' [data-tags-wrap]';
    $self.options.tagsSelector = $self.options.containerSelector + ' [data-tags]';
    $self.options.tagsItemSelector = $self.options.containerSelector + ' .tag';
    $self.options.tagsControlSelector = $self.options.containerSelector + ' [data-tags-control]';

    $($self.options.tagsSelector).tagsinput();
    
    $($self.options.tagsControlSelector).on('change', function() {

      var $this = $(this),
        itemVal = $this.val(),
        itemState = $this.prop('checked');

      if(itemState) {

        $($self.options.tagsSelector).tagsinput('add', itemVal);

      } else {

        $($self.options.tagsSelector).tagsinput('remove', itemVal);

      }

      if ($self.tagsQty() > 0) {

        $($self.options.tagsWrapSelector).show();

      } else {

        $($self.options.tagsWrapSelector).hide();

      }
      
    });

    $($self.options.tagsSelector).on('itemAdded', function(event) {

      var $tag = $(event.item);

      // console.log(event, $tag);

      $tag.data('toggle', 'tooltip');

      //  data-toggle="tooltip" data-placement="top" title="Tooltip on top"

    });

    $($self.options.tagsSelector).on('beforeItemRemove', function(event) {

      var tag = event.item;

      console.log(tag);

      $($self.options.tagsControlSelector).filter(function(){

        return this.value === tag;

      }).prop('checked', false);

    });

    $($self.options.tagsSelector).on('itemRemoved', function(event) {


      if ($self.tagsQty() > 0) {

        $($self.options.tagsWrapSelector).show();

      } else {

        $($self.options.tagsWrapSelector).hide();

      }
      
    });

    return this;

  };

  AmetysTags.prototype.tagsQty = function () {

    var $self = this,
      $items = document.querySelectorAll($self.options.tagsItemSelector);

    return $items.length;

  };

  $.fn.HSAmetysTags = function () {

    var _ = this,
      opt = arguments[0],
      args = Array.prototype.slice.call(arguments, 1),
      l = _.length,
      i,
      ret;

    for (i = 0; i < l; i++) {
      if (typeof opt == 'object' || typeof opt == 'undefined') {

        _[i].AmetysTags = new AmetysTags(_[i], opt);

      } else {

        ret = _[i].AmetysTags[opt].apply(_[i].AmetysTags, args);

      }

      if (typeof ret != 'undefined') {

        return ret;

      }
    }

    return _;

  };

})(jQuery);