<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:math="java.lang.Math"
        exclude-result-prefixes="ametys resolver">
    
    <xsl:import href="plugin:web://pages/services/search/search-default.xsl"/>         
    <xsl:import href="plugin:odf-web://pages/services/search-v2/hit-program.xsl"/>
    <xsl:import href="plugin:odf-web://pages/services/search-v2/hit-course.xsl"/>
    <xsl:import href="service:web://pages/services/search/search-default/criteria/criteria.xsl"/>
    <xsl:import href="service:web://pages/services/search/search-default/results/search-results.xsl"/>
    <xsl:import href="service:web://pages/services/search/search-default/results/search-map.xsl"/>
    
    <xsl:template name="common-service-head-css">
        <link type="text/css" rel="stylesheet" href="{ametys:skinURL('zones/search/scss/main.css')}"/>    
        <link type="text/css" rel="stylesheet" href="{ametys:skinURL('zones/search/scss/print.css')}"/>    
        <!-- Leaflet CSS -->
        <link rel="stylesheet" href="{ametys:pluginResourceURL('leaflet', 'css/leaflet.css')}" />
    </xsl:template>
    
    <xsl:template name="common-service-head-js">
    	<xsl:call-template name="search-service-head-js"/>
    	<script src="{ametys:skinURL('templates/common/js/search-autocomplete.js')}"></script>
        <script src="{ametys:skinURL('templates/common/plugins/bootstrap-tagsinput/dist/bootstrap-tagsinput.js')}"></script>
        <script src="{ametys:skinURL('zones/search/js/ametys-tags.js')}"></script>
        <script src="{ametys:skinURL('zones/search/js/ametys-invoker-change-text.js')}"></script>
        <!-- Leaflet JS -->
        <script src="{ametys:pluginResourceURL('leaflet', 'js/leaflet.js')}"></script>
        <script src="{ametys:skinURL('templates/common/js/ametys-marker.js')}"></script>
        <script src="{ametys:skinURL('templates/common/js/result-map.js')}"></script>
    </xsl:template>
    
    <xsl:variable name="common-service-css-class-name">search view-main</xsl:variable>
    
    <xsl:template name="common-service-body-nonempty-content-title"/>
    
    <xsl:template name="common-service-body-nonempty-content-content">
    
    	<xsl:call-template name="search-main-banner"/>
    	<xsl:call-template name="search-main-content"/>
    	
    </xsl:template>
    
    <xsl:template name="search-main-banner">
        <xsl:variable name="imgUrl"><xsl:call-template name="search-main-banner-illustration"/></xsl:variable>
    	<div class="ametys-main-banner" style="background-image: url({ametys:escapeURLforCSS($imgUrl)}); min-height: 374px;">
    
            <div class="ametys-main-banner-inner">
                <div class="container">
                
                    <xsl:call-template name="main-banner-breadcrumb"/>
                    
			    	<h1 class="ametys-main-banner__title"><xsl:value-of select="$header"/></h1>

			        <xsl:call-template name="form-criteria"/>
                    
                </div>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="search-main-banner-illustration">
        <xsl:value-of select="ametys:skinURL('templates/common/img/banners/banner-1.jpg')"/>
    </xsl:template>
    
    <xsl:template name="search-main-content">
        <div class="ametys-main-content search">
            <div class="container">
            
		        <xsl:call-template name="noscript"/>
                
                <xsl:call-template name="anchor" />
		    
		        <div class="ametys-search" data-ametys-search-role="search-results">
		        	<div class="ametys-search-inner">
		        		<xsl:call-template name="search-top-mobile"/>
		        		
		        		<xsl:call-template name="search-sidebar"/>
		        		<xsl:call-template name="search-results"/>
		        	</div>
                    
                    <xsl:call-template name="search-map-js"/>
		        </div>
		
		        <xsl:call-template name="link"/>
                
                <xsl:call-template name="search-map-dialog"/>
	        </div>
        </div>
        
        <script type="text/javascript">
            $j(document).ready(function() {
                var headerHeight = $j('header').height();
                $j('a[name=<xsl:value-of select="$anchor-id" />]').css('position', 'relative');
                $j('a[name=<xsl:value-of select="$anchor-id" />]').css('top', -headerHeight + 'px');
            });
        </script>
    </xsl:template>
    
    <xsl:template name="search-sidebar">
    	<aside class="ametys-search-sidebar">
   			<button class="ametys-search-sidebar__mobile-invoker" type="button" data-text="skin.{$skin}:SKIN_SERVICE_ODF_SEARCH_FILTER" i18n:attr="data-text"></button>
									
			<script>
				$j('.ametys-search-sidebar__mobile-invoker').on('click touchstart', function(e) {
					e.preventDefault();
					
					$j(this).toggleClass('active');
					$j('.ametys-search-sidebar__mobile-overlay').toggleClass('active');
					$j('.ametys-search-sidebar').toggleClass('opened');
				});
				
				$j('.ametys-search-sidebar__mobile-overlay').on('click touchstart', function() {
					$j(this).toggleClass('active');
					$j('.ametys-search-sidebar__mobile-invoker').toggleClass('active');
					$j('.ametys-search-sidebar').toggleClass('opened');
				});
			</script>
			
			<div class="ametys-search-sidebar-inner">
				<xsl:call-template name="search-map"/>
                <xsl:call-template name="skill-criteria"/>
				<xsl:call-template name="facet-filter"/>
			</div>
		</aside>
    </xsl:template>
    
    <xsl:template name="search-top-mobile">
    	<div class="ametys-search-content d-block d-md-none">
			<div class="ametys-heading">
        		<xsl:if test="/search/hits/hit">
	               <xsl:call-template name="results-count"/>
	               <xsl:call-template name="results-sort"/>
	            </xsl:if>
			</div>
            
            <xsl:call-template name="search-top-mobile-map"/>
		</div>
		<div class="ametys-search-sidebar__mobile-overlay"></div>
	</xsl:template>
    
    <xsl:template name="skill-criteria">
        <xsl:if test="/search/skill">
            <h4 class="g-mb-15"><i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_SKILLS" i18n:catalogue="skin.{$skin}"/></h4>
                                                        
            <div id="searchSkillTags_{$uniqueId}" class="g-mb-30">
                <div class="ametys-tags">
                    <div class="bootstrap-tagsinput">
                        <span class="tag label label-info">
                            <xsl:value-of select="/search/skill"/>
                            <xsl:variable name="onclick"><xsl:call-template name="remove-skill-js"/></xsl:variable>
                            <span data-role="remove" onclick="{$onclick}"></span>
                        </span>
                    </div>
                </div>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="remove-skill-js">
        <xsl:param name="callback-function" select="$callback-function"/>
        
        <!-- Reset skill input -->
        <xsl:variable name="code">
            var skillInput = $j("form[data-ametys-search-role='form-criteria-hidden'] input[name=skillId]");
            skillInput.val();
        </xsl:variable>
        <xsl:value-of select="normalize-space($code)"/>
        <!-- submit search -->
        <xsl:call-template name="search-js-submit-button"/>
    </xsl:template>
    
    <xsl:template name="facet-filter">
    	<xsl:if test="/search/hits/hit">
    		<xsl:if test="/search/form/facets/facet[@total > 0]">
		        <xsl:variable name="unique" select="concat('search-facet-', substring-after(math:random(), '.'))"/>
		        <xsl:call-template name="facet-filter-title"/>
		        
		        <div id="searchFilterTags_{$uniqueId}">
                    
		            <xsl:call-template name="facet-selected-facets"/>
                    
		        	<ul id="searchFilter_{$unique}" class="ametys-search-filter">
				        <xsl:for-each select="/search/form/facets/facet[@total > 0]">
				        	<li class="ametys-search-filter__item">
				                <xsl:variable name="searchFilterItemId" select="concat('searchFilterItem-', generate-id())"/>
				                
				                <xsl:call-template name="facet-filter-header">
				                	<xsl:with-param name="searchFilterItemId" select="$searchFilterItemId"/>
			                	</xsl:call-template>
				                
				                <div id="{$searchFilterItemId}" class="collapse" data-parent="#searchFilter_{$unique}" data-ametys-search-role="facet-filter" data-ametys-search-facet-name="{current()/@name}">
					                <div class="ametys-search-filter__item-content">
						                <xsl:call-template name="facet-filter-elements">
						                	<xsl:with-param name="searchFilterItemId" select="$searchFilterItemId"/>
						                	<xsl:with-param name="name" select="@name"/>
						                </xsl:call-template>
						            </div>
					            </div>
				            </li>
				        </xsl:for-each>
				    </ul>
	        	</div>
	        </xsl:if>
	    </xsl:if>
		
		<script>
            // $j('#searchFilterTags_<xsl:value-of select="$uniqueId"/>').HSAmetysTags();
            $j('#searchFilterTags_<xsl:value-of select="$uniqueId"/>').HSAmetysInvokerChangeText();
		</script>
    </xsl:template>
    
    <xsl:template name="facet-selected-facets">
        <xsl:if test="/search/form/facets/facet/item[@selected = 'true']">
            <div class="ametys-tags">
                <div class="bootstrap-tagsinput">
                    <xsl:for-each select="/search/form/facets/facet[item/@selected = 'true']">
                        <xsl:variable name="facetPrefixId">
                            <xsl:call-template name="facet-filter-element-prefix-id">
                                <xsl:with-param name="facetName" select="@name"/>
                            </xsl:call-template>
                        </xsl:variable>
                        <xsl:for-each select="item[@selected = 'true']">
                            <span class="tag label label-info">
                                <xsl:value-of select="."/>
                                <span data-role="remove">
                                    <xsl:attribute name="onclick">
                                        if ($('#<xsl:value-of select="concat($facetPrefixId, translate(@value, ':/', ''))"/>').prop("checked")) $('#<xsl:value-of select="concat($facetPrefixId, translate(@value, ':/', ''))"/>').click();
                                    </xsl:attribute>
                                </span>
                            </span>
                        </xsl:for-each>
                    </xsl:for-each>
                </div>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="facet-filter-title">
    	<h4 class="g-mb-30"><i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_DEFAULT_FILTERS_TITLE" i18n:catalogue="skin.{$skin}"/></h4>
    </xsl:template>
    
</xsl:stylesheet>