<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2019 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->

<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:math="java.lang.Math"
        xmlns:exsl="http://exslt.org/common"
        exclude-result-prefixes="ametys resolver"> 
        
    <xsl:import href="plugin:web://pages/services/search/search-default/criteria/criteria.xsl"/>
    
	<xsl:template name="form-criteria">
    	<xsl:call-template name="js-sumit-bo"/>
    	
    	<div class="ametys-search-form">
			<form method="post" class="search" data-ametys-search-role="form" name="{$search-form-id}" id="{$search-form-id}">
				<xsl:if test="$result-display-type = 'ON_PAGE'">
	                <xsl:attribute name="action"><xsl:value-of select="resolver:resolve('page', /search/result-page)"/>#<xsl:value-of select="$anchor-id" /></xsl:attribute>
	            </xsl:if>
				<div class="ametys-search-form-inner">
					<xsl:call-template name="top-search-input"/>
					<xsl:call-template name="top-search-submit"/>
				</div>
			</form>
		</div>
    </xsl:template>
    
    <xsl:template name="form-criteria-hidden">
        <form hidden="hidden" data-ametys-search-role="form-criteria-hidden">
            <xsl:for-each select="/search/form/fields/criterion">
                <input type="hidden" name="{@name}" value="{/search/form/values/criterion[@name = current()/@name]}"/>
            </xsl:for-each>
            <input type="hidden" name="skillId" value="{/search/skill/@id}"/>
        </form>
    </xsl:template>
    
    <xsl:template name="top-search-input">
        <xsl:apply-templates select="/search/form/fields/criterion[1]" mode="first-field">
            <xsl:with-param name="value" select="/search/form/values/criterion[@name = /search/form/fields/criterion[1]/@name]"/>
        </xsl:apply-templates>
        
        <div class="ametys-search-form-dropdown-wrap">
	        <xsl:for-each select="/search/form/fields/criterion[position() &gt; 1]">
	        	<xsl:apply-templates select="." mode="field">
	                <xsl:with-param name="value" select="/search/form/values/criterion[@name = current()/@name]"/>
	            </xsl:apply-templates>
	        </xsl:for-each>
	    </div>
    </xsl:template>
    
    <xsl:template match="criterion[enumeration]" mode="field">
        <xsl:param name="value"/>
        
        <!-- The selected criterion will be replaced by a facet choice -->
        <xsl:variable name="inputName"><xsl:value-of select="concat('user.input.facet.ContentReturnable$', @definition)"></xsl:value-of></xsl:variable>
        
        <xsl:variable name="dropdownSort" select="ametys:serviceViewParameter('dropdownSort')"/> 
        
        <xsl:variable name="options">
            <items>
                <xsl:choose>
                    <xsl:when test="$dropdownSort = 'order'">
                        <!-- Sort items by order, then alpha -->
                        <xsl:for-each select="enumeration/item">
                            <xsl:sort select="not(@order)" data-type="number"/><!-- items with no order at the end -->
                            <xsl:sort select="@order" data-type="number"/>
                            <xsl:sort select="label" />
                            
                            <xsl:variable name="itemValue" select="@value" />
                            <xsl:variable name="count" select="/search/enumerated-criteria/criterion[@name = $inputName]/item[@value = $itemValue]/@count" />
                            <xsl:if test="$compute-counts = 'false' or $count">
                                <item value="{$itemValue}" id="{generate-id()}">
                                    <xsl:if test="$count"><xsl:attribute name="count"><xsl:value-of select="$count" /></xsl:attribute></xsl:if>
                                    <xsl:copy-of select="label" />
                                </item>
                            </xsl:if>
                         </xsl:for-each>
                    </xsl:when>
                    <xsl:otherwise>
                        <!-- Alpha sort -->
                        <xsl:for-each select="enumeration/item">
                            <xsl:sort select="label" />
                            
                            <xsl:variable name="itemValue" select="@value" />
                            <xsl:variable name="count" select="/search/enumerated-criteria/criterion[@name = $inputName]/item[@value = $itemValue]/@count" />
                            <xsl:if test="$compute-counts = 'false' or $count">
                                <item value="{$itemValue}" id="{generate-id()}">
                                    <xsl:if test="$count"><xsl:attribute name="count"><xsl:value-of select="$count" /></xsl:attribute></xsl:if>
                                    <xsl:copy-of select="label" />
                                </item>
                            </xsl:if>
                         </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </items>
        </xsl:variable>
        
        <xsl:if test="exsl:node-set($options)/items/item">
	        <div class="ametys-search-form-dropdown">
	            <xsl:apply-templates select="." mode="field-label"/>
	                
	            <xsl:apply-templates select="." mode="field-input">
	                <xsl:with-param name="value" select="$value"/>
	                <xsl:with-param name="options" select="exsl:node-set($options)"/>
	            </xsl:apply-templates>
	        </div>
        </xsl:if>
        
    </xsl:template>
    
    <xsl:template match="criterion" mode="field">
        <xsl:param name="value"/>
        
        <div class="ametys-search-form-dropdown">
            <xsl:apply-templates select="." mode="field-label"/>
                
            <xsl:apply-templates select="." mode="field-input">
                <xsl:with-param name="value" select="$value"/>
            </xsl:apply-templates>
        </div>
    </xsl:template>
    
    <xsl:template match="criterion" mode="field-label">
        <xsl:variable name="id"><xsl:call-template name="criterion-id"/></xsl:variable>
        <xsl:variable name="labelFor"><xsl:value-of select="$id"/><xsl:if test="type = 'DATE' or type = 'DATETIME'">-clone</xsl:if></xsl:variable>
        <label for="{$labelFor}" class="sr-only">
        	<xsl:apply-templates select="." mode="field-label-text"/>
        </label>
    </xsl:template>
    
    <xsl:template match="criterion[contains(@name, '$domain')]" mode="field-label-text">
        <i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_DOMAIN" i18n:catalogue="skin.{$skin}"/>
    </xsl:template>
    
    <xsl:template match="criterion[contains(@name, '$degree')]" mode="field-label-text">
        <i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_DEGREE" i18n:catalogue="skin.{$skin}"/>
    </xsl:template>
    
    <xsl:template match="criterion[enumeration]" mode="field-input">
        <xsl:param name="value"/>
        <xsl:param name="options"/>
        
        <xsl:variable name="id"><xsl:call-template name="criterion-id"/></xsl:variable>
        <xsl:variable name="dropdownId" select="generate-id()"/>
        
        <!-- The selected criterion will be replaced by a facet choice -->
        <xsl:variable name="inputName"><xsl:value-of select="concat('user.input.facet.ContentReturnable$', @definition)"></xsl:value-of></xsl:variable>
	        
		<button id="{$dropdownId}Invoker" class="ametys-search-form-dropdown__invoker" type="button" aria-controls="{$dropdownId}" aria-haspopup="true" aria-expanded="false"
		        data-dropdown-event="click"
		        data-dropdown-target="#{$dropdownId}"
		        data-dropdown-type="css-animation"
		        data-dropdown-duration="200"
		        data-dropdown-hide-on-scroll="false"
		        data-dropdown-animation-in="fadeIn"
		        data-dropdown-animation-out="fadeOut">
			<xsl:apply-templates select="." mode="field-label-text"/>
			<span class="ametys-search-form-dropdown__invoker-icon ametys-icon-angle-down"></span>
		</button>
        
        <xsl:variable name="readingDirection" select="ametys:serviceViewParameter('dropdownReadingDirection')"/> 
		<div id="{$dropdownId}" class="ametys-search-form-dropdown-content ametys-search-form--limit-height u-dropdown--hidden" aria-labelledby="{$dropdownId}Invoker">
			<ul id="{generate-id($options)}" class="ametys-search-form-filter">
                <xsl:if test="$readingDirection = 'up-down'">
                    <xsl:attribute name="class">ametys-search-form-filter up-down</xsl:attribute>
                </xsl:if>
				<xsl:for-each select="$options/items/item">
				    <li class="ametys-search-form-filter__item">
                        <div class="ametys-checkbox">
                            <input id="{@id}" name="{$inputName}" value="{@value}" class="ametys-checkbox__control" type="checkbox">
                                <xsl:if test="@value = $value"><xsl:attribute name="checked">checked</xsl:attribute></xsl:if>
                            </input>
                            <label class="ametys-checkbox__label" for="{@id}">
                                <xsl:call-template name="criterion-item-label" >
                                     <xsl:with-param name="count" select="@count"/>
                                </xsl:call-template>
                            </label>
                        </div>
                    </li>
				</xsl:for-each>	
			</ul>
		</div>
		<script>
            $.HSCore.components.HSScrollBar.init($('#<xsl:value-of select="generate-id()"/>'));
		</script>
    </xsl:template>
    
    <xsl:template name="criterion-item-label">
        <xsl:param name="count" />
    
        <span class="ametys-checkbox__label_label"><xsl:value-of select="label"/></span>
        <xsl:if test="$count">
            <span class="ametys-checkbox__label_count">(<xsl:value-of select="$count" />)</span>
        </xsl:if>
    </xsl:template>
    
    
    <xsl:template match="criterion[type='BOOLEAN']" mode="field-input">
        <xsl:param name="value"/>
        
        <xsl:variable name="id"><xsl:call-template name="criterion-id"/></xsl:variable>
            <button id="{generate-id()}Invoker" class="ametys-search-form-dropdown__invoker" type="button" aria-controls="{generate-id()}" aria-haspopup="true" aria-expanded="false"
                    data-dropdown-event="click"
                    data-dropdown-target="#{generate-id()}"
                    data-dropdown-type="css-animation"
                    data-dropdown-duration="200"
                    data-dropdown-hide-on-scroll="false"
                    data-dropdown-animation-in="fadeIn"
                    data-dropdown-animation-out="fadeOut">
                <xsl:apply-templates select="." mode="field-label-text"/>
                <span class="ametys-search-form-dropdown__invoker-icon ametys-icon-angle-down"></span>
            </button>
            
            <!-- The selected criterion will be replaced by a facet choice -->
            <xsl:variable name="inputName"><xsl:value-of select="concat('user.input.facet.ContentReturnable$', @definition)"></xsl:value-of></xsl:variable>
            
            <div id="{generate-id()}" class="ametys-search-form-dropdown-content ametys-search-form--limit-height u-dropdown--hidden" aria-labelledby="{generate-id()}Invoker">
                <ul class="ametys-search-form-filter">
                
	                <xsl:variable name="countTrue" select="/search/enumerated-criteria/criterion[@name = $inputName]/item[@value = 'true']/@count" />
	                <xsl:if test="$compute-counts = 'false' or $countTrue">
                        <li class="ametys-search-form-filter__item">
	                        <div class="ametys-checkbox">
	                            <input id="t-{generate-id()}" name="{$inputName}" value="true" class="ametys-checkbox__control" type="checkbox">
	                                <xsl:if test="@value = $value"><xsl:attribute name="checked">checked</xsl:attribute></xsl:if>
	                            </input>
	                            <label class="ametys-checkbox__label" for="t-{generate-id()}">
	                               <xsl:call-template name="criterion-boolean-true-label" >
	                                   <xsl:with-param name="count" select="$countTrue"/>
	                               </xsl:call-template>
                               </label>
	                        </div>
	                    </li>
                    </xsl:if>
                    
                    <xsl:variable name="countFalse" select="/search/enumerated-criteria/criterion[@name = $inputName]/item[@value = 'false']/@count" />
                    <xsl:if test="$compute-counts = 'false' or $countFalse">
	                    <li class="ametys-search-form-filter__item">
	                        <div class="ametys-checkbox">
	                            <input id="f-{generate-id()}" name="{$inputName}" value="false" class="ametys-checkbox__control" type="checkbox">
	                                <xsl:if test="@value = $value"><xsl:attribute name="checked">checked</xsl:attribute></xsl:if>
	                            </input>
	                    
	                            <label class="ametys-checkbox__label" for="f-{generate-id()}">
	                               <xsl:call-template name="criterion-boolean-false-label" >
                                       <xsl:with-param name="count" select="$countFalse"/>
                                   </xsl:call-template>
                                </label>
	                        </div>
	                    </li>
                    </xsl:if>
                </ul>
            </div>
            <script>
                  $.HSCore.components.HSScrollBar.init($('#<xsl:value-of select="generate-id()"/>'));
            </script>
    </xsl:template>
    
    <xsl:template match="criterion[contains(@name, 'user.input.criterion.common$wording$textfield')]|criterion[contains(@name, 'user.input.criterion.common$titleorwording$textfield')]" mode="first-field" priority="100">
        <xsl:param name="value"/>
        
    	<div class="ametys-search-form__control-wrap" id="search-autocomplete-{$uniqueId}">
            <input id="search-autocomplete-{$uniqueId}" name="{@name}" value="{$value}" class="ametys-search-form__control" type="text" data-autocomplete-target="#autocomplete-{$uniqueId}">
                <xsl:apply-templates select="." mode="placeholder"/>
            </input>
            
            <xsl:call-template name="top-search-input-autocomplete"/>
		</div>
		<script>
			// Autocompletion
            $.HSCore.components.HSScrollBar.init($('#autocomplete-<xsl:value-of select="$uniqueId"/> .ametys-search-form-dropdown-content-body'));
            
            $j('#search-autocomplete-<xsl:value-of select="$uniqueId"/>').HSAmetysSearchAutocomplete({
                autocompleteServerUrl: "<xsl:call-template name="autocomplete-server-url"/>",
                autocompleteSiteName: "<xsl:value-of select="$site"/>",
                autocompleteLang: "<xsl:value-of select="$lang"/>",
                autocompleteZoneItemId: "<xsl:value-of select="/search/zone-item/@id"/>",
                searchUrl: "<xsl:value-of select="resolver:resolve('page', /search/result-page)"/>"
            });
		</script>
    </xsl:template>
    
    <xsl:template match="criterion[contains(@name, 'user.input.criterion.common$wording$textfield')]|criterion[contains(@name, 'user.input.criterion.common$titleorwording$textfield')]" mode="placeholder" priority="100">
        <xsl:attribute name="placeholder">skin.<xsl:value-of select="$skin"/>:SKIN_SERVICE_ODF_SEARCH_HEADER_FORM_PLACEHOLDER</xsl:attribute>
        <xsl:attribute name="i18n:attr">placeholder</xsl:attribute>
    </xsl:template>
    
    <xsl:template name="autocomplete-server-url"><xsl:value-of select="$uri-prefix"/>/plugins/odf-web/search/autocompletion</xsl:template>
    
    <xsl:template match="criterion" mode="first-field">
        <xsl:param name="value"/>
        
        <div class="ametys-search-form__control-wrap">
            <input name="{@name}" value="{$value}" class="ametys-search-form__control" type="text">
                <xsl:apply-templates select="." mode="placeholder"/>
            </input>
        </div>
    </xsl:template>
    
    <xsl:template match="criterion" mode="placeholder">
        <xsl:attribute name="placeholder"><xsl:value-of select="label"/></xsl:attribute>
    </xsl:template>
    
    <xsl:template name="top-search-input-autocomplete">
        <div id="autocomplete-{$uniqueId}" class="ametys-search-form-dropdown-content" style="display: none;">
            <header
                class="ametys-search-form-dropdown-content-header ametys-search-form-dropdown-content-header--two-columns"><!-- three-columns -->

                <xsl:call-template name="top-search-autocomplete-column-header-1"/>
                <xsl:call-template name="top-search-autocomplete-column-header-2"/>
                <xsl:call-template name="top-search-autocomplete-column-header-3"/>
            </header>
    
            <div class="ametys-search-form-dropdown-content-body ametys-search-form--limit-height">
                <div
                    class="ametys-search-form-dropdown-content-body-inner ametys-search-form-dropdown-content-body-inner--two-columns"><!-- three-columns -->
                    
                    <xsl:call-template name="top-search-autocomplete-column-body-1"/>
                    <xsl:call-template name="top-search-autocomplete-column-body-2"/>
                    <xsl:call-template name="top-search-autocomplete-column-body-3"/>
                </div>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="top-search-autocomplete-column-header-1">
        <!-- Formations -->
        <xsl:call-template name="top-search-autocomplete-column-header">
            <xsl:with-param name="label"><i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_AUTOCOMPLETE_PROGRAMS" i18n:catalogue="skin.{$skin}"/></xsl:with-param>
            <xsl:with-param name="iconCls">ametys-icon-graduation-cap-alt</xsl:with-param>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="top-search-autocomplete-column-header-2">
        <!-- Compétences -->                
        <xsl:call-template name="top-search-autocomplete-column-header">
            <xsl:with-param name="label"><i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_AUTOCOMPLETE_SKILLS" i18n:catalogue="skin.{$skin}"/></xsl:with-param>
            <xsl:with-param name="iconCls">ametys-icon-clock-alt</xsl:with-param>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="top-search-autocomplete-column-header-3">
        <!-- Etiquettes -->                
        <!-- <xsl:call-template name="top-search-autocomplete-column-header">
            <xsl:with-param name="label"><i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_AUTOCOMPLETE_TAGS" i18n:catalogue="skin.{$skin}"/></xsl:with-param>
            <xsl:with-param name="iconCls">fas fa-hashtag</xsl:with-param>
        </xsl:call-template> -->
    </xsl:template>
    
    <xsl:template name="top-search-autocomplete-column-body-1">
        <!-- Formations -->             
        <xsl:call-template name="top-search-autocomplete-column-body">
            <xsl:with-param name="label"><i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_AUTOCOMPLETE_PROGRAMS" i18n:catalogue="skin.{$skin}"/></xsl:with-param>
            <xsl:with-param name="iconCls">ametys-icon-graduation-cap-alt</xsl:with-param>
            <xsl:with-param name="data">pages</xsl:with-param>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="top-search-autocomplete-column-body-2">
        <!-- Compétences -->
        <xsl:call-template name="top-search-autocomplete-column-body">
            <xsl:with-param name="label"><i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_AUTOCOMPLETE_SKILLS" i18n:catalogue="skin.{$skin}"/></xsl:with-param>
            <xsl:with-param name="iconCls">ametys-icon-clock-alt</xsl:with-param>
            <xsl:with-param name="data">skills</xsl:with-param>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="top-search-autocomplete-column-body-3">
        <!-- Etiquettes -->
        <!-- <xsl:call-template name="top-search-autocomplete-column-body">
            <xsl:with-param name="label"><i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_AUTOCOMPLETE_TAGS" i18n:catalogue="skin.{$skin}"/></xsl:with-param>
            <xsl:with-param name="iconCls">fas fa-hashtag</xsl:with-param>
            <xsl:with-param name="data">tags</xsl:with-param>
        </xsl:call-template> -->
    </xsl:template>
    
    <xsl:template name="top-search-autocomplete-column-header">
        <xsl:param name="label"/>
        <xsl:param name="iconCls"/>
        
        <div class="ametys-search-form-dropdown-content-header__column">
            <h3 class="ametys-search-form-dropdown-content__title">
                <span class="ametys-search-form-dropdown-content__title-icon {$iconCls}"></span>
                <xsl:copy-of select="$label"/>
            </h3>
        </div>
    </xsl:template>
    
    <xsl:template name="top-search-autocomplete-column-body">
        <xsl:param name="label"/>
        <xsl:param name="iconCls"/>
        <xsl:param name="dropdownCls"/>
        <xsl:param name="data"/>
        
        <div class="ametys-search-form-dropdown-content-body__column">
            <h3 class="ametys-search-form-dropdown-content__title d-md-none mb-2">
                <span
                    class="ametys-search-form-dropdown-content__title-icon {$iconCls}"></span>
                <xsl:copy-of select="$label"/>
            </h3>

            <ul data-autocomplete-data="{$data}"
                class="ametys-search-form-dropdown-content-list {$dropdownCls}"></ul>
        </div>
    </xsl:template>
    
    <xsl:template name="top-search-submit">
		 <xsl:if test="/search/launch-search-at-startup = 'false' or count(/search/form/fields/criterion) > 0">
            <xsl:if test="/search/result-display-type = 'ON_PAGE'">
                <input type="hidden" name="submit-form">
                    <xsl:if test="/search/group-id and normalize-space(/search/group-id) != ''">
                        <xsl:attribute name="value"><xsl:value-of select="/search/group-id"/></xsl:attribute>
                    </xsl:if>
                </input>
            </xsl:if>
            
	       <button type="submit" class="ametys-search-form__btn">
	       		<xsl:attribute name="onclick" ><xsl:call-template name="search-js-submit-button"/></xsl:attribute>
	            <span class="ametys-search-form__btn-icon ametys-icon-magnifier"></span>
	            <i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_HEADER_FORM_SUBMIT" i18n:catalogue="skin.{$skin}"/>
	        </button>
        </xsl:if>
    </xsl:template>
    
</xsl:stylesheet>