<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2019 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        exclude-result-prefixes="ametys">
    
    <xsl:import href="plugin:web://pages/services/user-preferences/edit_3.3.xsl"/>          
    
    <!-- Used in common.xsl -->
    <xsl:template name="common-service-head-css">
        <link rel="stylesheet" href="{ametys:skinURL('zones/profile/scss/main.css')}"/>
        <link rel="stylesheet" href="{ametys:skinURL('zones/profile/scss/print.css')}"/>
    </xsl:template>
    
    <xsl:template name="common-service-head-js">
        <script src="{ametys:skinURL('templates/common/plugins/jquery-validation/dist/jquery.validate.js')}"></script>
        <script src="{ametys:skinURL('templates/common/plugins/chosen/chosen.jquery.js')}"></script>
        <script src="{ametys:skinURL('templates/common/js/components/hs.select.js')}"></script>
        <script src="{ametys:skinURL('templates/common/js/components/hs.validation.js')}"></script>
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-title"/>
    
    <xsl:template name="common-service-body-nonempty-content-content">
        <div class="ametys-profile-content pb-0">
            <h2 class="ametys-page-title"><i18n:text i18n:key="SKIN_SERVICE_USER_PREFERENCES_HEADER" i18n:catalogue="skin.{$skin}"/></h2>
            
            <xsl:call-template name="errors"/>
            <xsl:call-template name="success"/>
            <xsl:call-template name="form"/>
        </div>
    </xsl:template>
    
    <xsl:template name="errors">
        <xsl:if test="$status = 'error'">
	        <p class="error-hint">
	            <i18n:text i18n:key="PLUGINS_WEB_SERVICE_USER_PREFERENCES_SAVE_ERROR"/>
	        </p>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="success">
        <xsl:if test="$status = 'success'">
            <p class="success-hint">
                <i18n:text i18n:key="SKIN_SERVICE_USER_PREFERENCES_SAVE_SUCCESS"  i18n:catalogue="skin.{$skin}"/>
            </p>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="form">
        <form method="post" action="{$site-uri-prefix}/{UserPreferences/page/@path}.html">
            <input type="hidden" name="submit" value="true"/>
            <xsl:if test="UserPreferences/page">
                <input type="hidden" name="page" value="{UserPreferences/page/@path}"/>
            </xsl:if>
            <xsl:apply-templates select="UserPreferences/groups/group[preferences/preference[$prefs/value = @id]]">
                <xsl:sort select="preferences/preference/@order" data-type="number"/>
            </xsl:apply-templates>
            
            <div class="text-center">
                <!-- Template common for submit button -->
                <xsl:call-template name="common-utils-input-submit">
                    <xsl:with-param name="class-name">btn btn-primary btn-lg btn-wide-alt btn-shadow rounded-0</xsl:with-param>
                    <xsl:with-param name="i18nkey" select="concat('skin.', $skin, ':SKIN_SERVICE_USER_PREFERENCES_SUBMIT')" />                                
                </xsl:call-template>
            </div>
        </form>    
    </xsl:template>
    
    <xsl:template match="group">
        <xsl:apply-templates select="preferences/preference[$prefs/value = @id]">
            <xsl:sort select="@order" data-type="number"/>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template match="preference">
        <xsl:variable name="errorCls">
            <xsl:if test="/xml/errors/field[@id = current()/@id and error]">error</xsl:if>
        </xsl:variable>
        
        <div class="form-group mb-0 {$errorCls}">
            <xsl:if test="position() = last()"><xsl:attribute name="class">form-group mb-10 <xsl:value-of select="$errorCls"/></xsl:attribute></xsl:if>

            <div class="ametys-form-control-with-icon-wrap ametys-form-control-with-icon-wrap--lg">
                <xsl:apply-templates select="." mode="icon"/>
                <xsl:apply-templates select="." mode="input">
                    <xsl:with-param name="value"><xsl:call-template name="get-value"/></xsl:with-param>
                </xsl:apply-templates>
            </div>
            
            <xsl:if test="/xml/errors/field[@id = current()/@id and error]">
                <small class="error g-font-size-12 g-mt-5 g-px-2"><xsl:value-of select="/xml/errors/field[@id = current()/@id]/error"/></small>
            </xsl:if>
        </div>
    </xsl:template>
    
    <xsl:template match="preference[@type = 'string']" mode="input" priority="0">
        <xsl:param name="value"/>
        
        <input name="{@id}" class="ametys-form-control-with-icon ametys-form-control--line ametys-form-control--lg" type="text" placeholder="{label}" value="{$value}"/>
        
    </xsl:template>
    
    <xsl:template match="preference[@type = 'string' and enumeration]" mode="input" priority="10">
        <xsl:param name="value"/>

        <xsl:variable name="comma-value" select="concat(',', $value, ',')"/>
        
        <select id="{@id}-{$uniqueId}" name="{@id}"
                class="ametys-form-control-with-icon ametys-form-control--line ametys-form-control--lg"
                data-placeholder="{label}"
                data-field-icon="fas fa-folder-open"
                data-open-icon="fa fa-angle-down"
                data-close-icon="fa fa-angle-up">
            
            <!-- Empty option if not multiple nor mandatory. -->
            <xsl:if test="not(@multiple = 'true') and not(validation/mandatory = 'true')">
                <option value=""></option>
            </xsl:if>
            <xsl:for-each select="enumeration/option">
                <option value="{@value}">
                    <xsl:if test="@value = $value or contains($comma-value, concat(',', @value, ','))">
                        <xsl:attribute name="selected">selected</xsl:attribute>
                    </xsl:if>
                    <xsl:value-of select="."/>
                </option>
            </xsl:for-each>
        </select>
        <script type="text/javascript">
            $.HSCore.components.HSSelect.init('<xsl:value-of select="concat('#', @id, '-', $uniqueId)"/>');
        </script>
    </xsl:template>
    
    <xsl:template match="preference" mode="icon">
        <span class="field-icon fas fa-user-alt"></span>
    </xsl:template>
    
    <xsl:template match="preference[@id = 'email']" mode="icon">
        <span class="field-icon fas fa-envelope"></span>
    </xsl:template>
    
    <xsl:template match="preference[@id = 'phone']" mode="icon">
        <span class="field-icon fas fa-phone"></span>
    </xsl:template>
    
</xsl:stylesheet>   