<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2019 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                            xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
                            xmlns:escaper="org.apache.commons.lang.StringEscapeUtils"
                            xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                            xmlns:i18n="http://apache.org/cocoon/i18n/2.1">

    <xsl:import href="plugin:odf-web://stylesheets/helper/cart.xsl"/>  
    
    <xsl:template name="header-main-profile-menu-basket-item">
            <li class="ametys-header-profile-menu__item ametys-dropdown">
                <a id="basketInvoker" class="ametys-header-profile-menu__link ametys-dropdown-invoker" href="#" aria-controls="basket" aria-haspopup="true" aria-expanded="false"
                   data-dropdown-event="hover"
				   data-dropdown-target="#basket"
				   data-dropdown-type="css-animation"
				   data-dropdown-duration="200"
				   data-dropdown-delay="0"
				   data-dropdown-hide-on-scroll="false"
				   data-dropdown-animation-in="fadeIn"
				   data-dropdown-animation-out="fadeOut">
                    <span class="ametys-header-profile-menu__item-icon">
                        <span class="ametys-header-profile-menu__item-badge" style="display: none"></span>
                        <span class="ametys-icon-heart"></span>
                    </span>
                    <span class="d-none d-md-inline"><i18n:text i18n:key="SKIN_USER_WISHLIST" i18n:catalogue="skin.{$skin}"/></span>
                </a>
                
                <xsl:variable name="cartPagesIds" select="ametys:findPagesIdsByTag('ODF_CART')"/>
                <xsl:call-template name="cart-preview">
                    <xsl:with-param name="cartPageId" select="$cartPagesIds/@id"/>
                </xsl:call-template>    
                
                <script type="text/javascript">
                    $j(document).ready(function() {
                        function _updateCartCounter()
                        {
                            ODFCart.getItemsCount(function(count){
                                if (count &gt; 0)
                                {
                                    $j('#basketInvoker').find('.ametys-header-profile-menu__item-badge').show();
                                    $j('#basketInvoker').find('.ametys-header-profile-menu__item-badge').html(count);
                                }
                                else
                                {
                                    $j('#basketInvoker').find('.ametys-header-profile-menu__item-badge').hide();
                                    $j('#basketInvoker').find('.ametys-header-profile-menu__item-badge').html(count);
                                }
                            });
                        }
                        
                        ODFCart.registerListener(_updateCartCounter);
                        
                        _updateCartCounter();
                    });
                    
                </script>    
            </li>   
    </xsl:template>
    
    <xsl:template name="cart-preview">
        <xsl:param name="cartPageId"/>
        
        <div id="basket" class="ametys-dropdown-content u-dropdown--hidden" aria-labelledby="basketInvoker">
            <div class="ametys-basket">
                <div class="js-scrollbar ametys-basket-body">
                    <p class="ametys-basket-empty g-px-10 g-my-20"><i18n:text i18n:key="SKIN_USER_EMPTY_WISHLIST" i18n:catalogue="skin.{$skin}"/></p>
                    
                    <ul class="ametys-basket-products">
                        <li><!-- Empty --></li>
                    </ul>
                </div>
                
                <footer class="ametys-basket-footer">
                    <div class="ametys-basket-checkout-btn-wrap">
                        <a class="ametys-basket-checkout-btn" href="javascript:ODFCart.download('{ametys:site()}')"><i18n:text i18n:key="PLUGINS_ODFWEB_SERVICE_CART_DOWNLOAD" i18n:catalogue="plugin.odf-web"/></a>
                        <xsl:if test="$cartPageId != ''">
                            <a class="ametys-basket-checkout-btn" href="{resolver:resolve('page', $cartPageId)}"><i18n:text i18n:key="PLUGINS_ODFWEB_SERVICE_CART_SEE" i18n:catalogue="plugin.odf-web"/></a>
                        </xsl:if>
                    </div>
                </footer>
            </div>
        </div>
        
        <xsl:call-template name="cart-item-preview-template"/>
        
        <script type="text/javascript">
            $j(document).ready(function() {
            
                function _updateCartPreview()
                {
                    ODFCart.getItems('<xsl:value-of select="ametys:lang()"/>', 'cart', function(items) {
                        
                        var previewWrap = $j('.ametys-basket-body').find('.ametys-basket-products');
                        previewWrap.empty();
                            
                        if (items.length > 0)
                        {
                            $j('.ametys-basket-empty').hide();
                            $j('.ametys-basket-footer').show();
                            $j('.ametys-basket-body').addClass('non-empty');
                            
                            var template = $j("#cart-item-preview-template").html();
                            $j(items).each(function(index, item) {
                               var html = template.replace(/{{title}}/ig, item.title)
                                    .replace(/{{pageTitle}}/ig, item.pageTitle)
                                    .replace(/{{pagePath}}/ig, "<xsl:value-of select="ametys:siteUriPrefix()"/>/<xsl:value-of select="ametys:lang()"/>/" + item.pagePath + ".html")
                                    .replace(/{{id}}/ig, item.id)
                                    .replace(/{{contentTypeLabel}}/ig, item.contentTypeLabel)
                                    .replace(/{{parentProgramTitle}}/ig, item.parentProgramTitle ? item.parentProgramTitle : '')
                                    .replace(/{{typeIcon}}/ig, item.contentTypeId == 'org.ametys.plugins.odf.Content.course' ? 'ametys-icon-board' : 'ametys-icon-graduation-cap-alt')
                                    .replace(/{{view}}/ig, item.view ? item.view : '');
                                    
                               previewWrap.append(html);
                            });
                        }
                        else
                        {
                            $j('.ametys-basket-empty').show();
                            $j('.ametys-basket-footer').hide();
                            $j('.ametys-basket-body').removeClass('non-empty');
                        }
                    });
                }
                
                ODFCart.registerListener(_updateCartPreview);
                _updateCartPreview();
            });
        </script>  
    </xsl:template>
    
    <xsl:template name="cart-item-preview-template">
        <script id="cart-item-preview-template" type="text/template">
            <li class="ametys-basket-products__item">
                <span class="ametys-basket-products-categories__item-icon {{{{typeIcon}}}}"></span>
                <div class="ametys-basket-products__item-description">
                    <p data-parent-title="{{{{parentProgramTitle}}}}" class="ametys-basket-products__item-degree">{{parentProgramTitle}}</p>
                    <h4 class="ametys-basket-products__item-title">
                        <a href="{{{{pagePath}}}}">{{title}}</a>
                    </h4>
                </div>
                <button class="ametys-basket-products__item-remove" type="button" onclick="ODFCart.removeItem('{{{{id}}}}', ODFCart.emptyCallback)">&amp;times;</button>
            </li>
        </script>
    </xsl:template>
    
    <xsl:template name="add-to-cart-html">
        <xsl:param name="link-content"><i18n:text i18n:key="PLUGINS_ODFWEB_CART_ADD" i18n:catalogue="plugin.odf-web"/></xsl:param>
        <xsl:param name="link-content-remove"><i18n:text i18n:key="PLUGINS_ODFWEB_CART_DELETE" i18n:catalogue="plugin.odf-web"/></xsl:param>
        
        <xsl:variable name="itemId"><xsl:call-template name="compute-cartitem-id"/></xsl:variable>
        <div class="add-to-cart" id="add-to-cart-{$uniqueId}" style="display:none">
            <a href="javascript:ODFCart.addItem('{$itemId}', '{escaper:escapeJavaScript(@title)}');" class="list-inline-item theme-link-hover g-color-white d-inline-flex align-items-center g-mr-25--lg g-mr-15 g-text-underline--none--hover">
                <svg class="g-mr-10" width="20px" height="20px" viewBox="0 0 12 16" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                    <g id="Octicons" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                        <g id="heart" fill="#fff">
                            <path d="M11.2,3 C10.68,2.37 9.95,2.05 9,2 C8.03,2 7.31,2.42 6.8,3 C6.29,3.58 6.02,3.92 6,4 C5.98,3.92 5.72,3.58 5.2,3 C4.68,2.42 4.03,2 3,2 C2.05,2.05 1.31,2.38 0.8,3 C0.28,3.61 0.02,4.28 0,5 C0,5.52 0.09,6.52 0.67,7.67 C1.25,8.82 3.01,10.61 6,13 C8.98,10.61 10.77,8.83 11.34,7.67 C11.91,6.51 12,5.5 12,5 C11.98,4.28 11.72,3.61 11.2,2.98 L11.2,3 Z" id="Shape"></path>
                        </g>
                    </g>
                </svg>
                <span><xsl:copy-of select="$link-content"/></span>
            </a>
        </div>
        <div class="remove-from-cart" id="remove-from-cart-{$uniqueId}" style="display:none">
            <a href="javascript:ODFCart.removeItem('{$itemId}')" class="list-inline-item theme-link-hover g-color-white d-inline-flex align-items-center g-mr-25--lg g-mr-15 g-text-underline--none--hover">
                <svg class="g-mr-10" width="20px" height="20px" viewBox="0 0 12 16" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                    <g id="Octicons" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                        <g id="heart" fill="#fff">
                            <path d="M11.2,3 C10.68,2.37 9.95,2.05 9,2 C8.03,2 7.31,2.42 6.8,3 C6.29,3.58 6.02,3.92 6,4 C5.98,3.92 5.72,3.58 5.2,3 C4.68,2.42 4.03,2 3,2 C2.05,2.05 1.31,2.38 0.8,3 C0.28,3.61 0.02,4.28 0,5 C0,5.52 0.09,6.52 0.67,7.67 C1.25,8.82 3.01,10.61 6,13 C8.98,10.61 10.77,8.83 11.34,7.67 C11.91,6.51 12,5.5 12,5 C11.98,4.28 11.72,3.61 11.2,2.98 L11.2,3 Z" id="Shape"></path>
                        </g>
                    </g>
                </svg>
                <span><xsl:copy-of select="$link-content-remove"/></span>
            </a>
        </div>
    </xsl:template>
    
</xsl:stylesheet>