<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2019 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
        xmlns:xalan="http://xml.apache.org/xalan"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:odf="org.ametys.odf.OdfXSLTHelper"
        xmlns:cms="http://ametys.org/cms/3.0"
        xmlns:docbook="http://docbook.org/ns/docbook" 
        xmlns:filename="org.ametys.core.util.FilenameUtils"
        xmlns:url="org.ametys.core.util.URIUtils"
        xmlns:escaper="org.apache.commons.lang.StringEscapeUtils"
        exclude-result-prefixes="sitemap ametys resolver odf docbook cms url">
    
    <xsl:template match="course" mode="course-popup">
        <div id="popup-{@code}-{generate-id()}" class="ametys-popup ametys-popup--small-close-btn" style="display: none; min-width: 470px; max-width: 95%; min-height: 160px;">
            <div class="ametys-popup-content g-py-25 g-px-20">
                                                                
                <h2 class="ametys-section-sub-title"><xsl:value-of select="@title"/></h2>
                                                    
                <xsl:apply-templates select="." mode="course-popup-actions"/>                                                
                
                <xsl:apply-templates select="/view/contentType[@id = 'org.ametys.plugins.odf.Content.course' and @view='structure']/fieldset[@name='benefits']" mode="course-popup-display">
                    <xsl:with-param name="content" select="."/>
                </xsl:apply-templates>
                
                <xsl:apply-templates select="." mode="course-popup-link"/>
                
            </div>
        </div>
        <script type="text/javascript">
            $j(document).ready(function() {
                // Compute popup width
                var itemCount= $j('#popup-<xsl:value-of select="@code"/>-<xsl:value-of select="generate-id()"/>').find('.ametys-benefits-alt__item').length;
                var width = itemCount > 0 ? 227*itemCount + 20*(itemCount+1) : 470;
                $j('#popup-<xsl:value-of select="@code"/>-<xsl:value-of select="generate-id()"/>').width(width);
            });
        </script>    
    </xsl:template>
    
    <xsl:template match="course" mode="course-popup-actions">
        <ul class="ametys-list-with-icon ametys-list-with-icon--inline ametys-list-with-icon--dark g-mb-25">
            <xsl:call-template name="course-popup-action-addtocart"/>
            <xsl:call-template name="course-popup-action-download"/>
        </ul>
    </xsl:template>
    
    <xsl:template name="course-popup-action-addtocart">
        <xsl:param name="addTextKey" select="concat('skin.', $skin, ':SKIN_SERVICE_ODF_SEARCH_CART_ADD')"/>
        <xsl:param name="removeTextKey" select="concat('skin.', $skin, ':SKIN_SERVICE_ODF_SEARCH_CART_DELETE')"/>
        
        <li class="ametys-list-with-icon__item">
            <a id="course-{@code}-add-to-wishlist-{generate-id()}" class="ametys-list-with-icon__link" href="#"
               data-tf-is-in-wishlist="out"
               data-tf-default-text="{$addTextKey}"
               data-tf-active-text="{$removeTextKey}"
               data-tf-default-icon="ametys-icon-heart-alt-2"
               data-tf-active-icon="ametys-icon-heart"
               i18n:attr="data-tf-default-text data-tf-active-text">
                <span class="ametys-list-with-icon__item-icon ametys-list-with-icon__item-icon--md ametys-icon-heart-alt-2" data-tf-icon="data-tf-icon"></span>
                <span data-tf-text="data-tf-text"><i18n:text i18n:key="SKIN_SERVICE_ODF_SEARCH_CART_ADD" i18n:catalogue="skin.{$skin}"/></span>
            </a>
        </li>
    </xsl:template>
    
    <xsl:template name="course-popup-action-download">
        <li class="ametys-list-with-icon__item">
            <xsl:variable name="downloadUrl" select="concat($uri-prefix, '/plugins/odf-web/', $site, '/_content/', @name, '/', filename:filterName(@title), '.pdf')"/>
            <a class="ametys-list-with-icon__link" href="{url:encodePath($downloadUrl)}" target="_blank">
                <span class="ametys-list-with-icon__item-icon ametys-list-with-icon__item-icon--md ametys-icon-download"></span>
                <i18n:text i18n:key="COURSE_POPUP_DOWNLOAD" i18n:catalogue="skin.{$skin}"/>
            </a>
        </li>
    </xsl:template>
    
    <xsl:template match="fieldset[@name = 'benefits']" mode="course-popup-display">
        <xsl:param name="content"/>
        
        <xsl:variable name="self" select="."/>
        
        <xsl:variable name="prefix">/view/structure//course[@id='<xsl:value-of select="$content/@id"/>']/attributes/</xsl:variable>
        
        <xsl:if test="cms:isNotFieldsetEmpty($self, $prefix)">
	        <ul class="ametys-benefits-alt ametys-benefits-alt--auto-width g-mb-30">
	            <xsl:for-each select="metadata">
	                <xsl:apply-templates select="." mode="benefits">
		                <xsl:with-param name="value" select="$content/attributes/*[local-name() = current()/@name]"/>
                        <xsl:with-param name="content" select="$content"/>
		            </xsl:apply-templates>
	            </xsl:for-each>
	        </ul>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="course" mode="course-popup-link">
        <div class="row">
            <div class="col-lg-8">
                <div class="ametys-richtext">
                    <xsl:if test="cms:isNotRichTextEmpty(attributes/description)">
                        <xsl:apply-templates select="attributes/description/docbook:article">
		                    <xsl:with-param name="level" select="2"/>
		                </xsl:apply-templates>
                    </xsl:if>
                    <p>
                        <xsl:variable name="uri">
	                        <xsl:call-template name="compute-course-uri">
					            <xsl:with-param name="node" select="."/>
					            <xsl:with-param name="path" select="@id"/>
					        </xsl:call-template>
                        </xsl:variable>
                        <a class="know-more" href="{resolver:resolve('odf', $uri)}">
                            <i18n:text i18n:key="COURSE_POPUP_SEE_FULL_PAGE" i18n:catalogue="skin.{$skin}"/>
                        </a>
                    </p>
                </div>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="compute-course-uri">
        <xsl:param name="node"/>
        <xsl:param name="path"/>
        
        <xsl:choose>
            <xsl:when test="local-name($node/..) = 'program'">
                <xsl:value-of select="concat($path, ';', $node/../@id)"/>
            </xsl:when>
            <xsl:when test="local-name($node/..) = 'subprogram' or local-name($node/..) = 'course'">
                <xsl:call-template name="compute-course-uri">
                    <xsl:with-param name="node" select="$node/.."/>
                    <xsl:with-param name="path" select="concat($path, ';', $node/../@id)"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="local-name($node/..) = 'structure'">
                <xsl:value-of select="$path"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="compute-course-uri">
                    <xsl:with-param name="node" select="$node/.."/>
                    <xsl:with-param name="path" select="$path"/>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
</xsl:stylesheet>