<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2019 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
        xmlns:xalan="http://xml.apache.org/xalan"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:odf="org.ametys.plugins.odfweb.xslt.OdfXSLTHelper"
        xmlns:cms="http://ametys.org/cms/3.0"
        exclude-result-prefixes="sitemap ametys resolver odf cms">
    
    <xsl:template name="benefits">
        <xsl:apply-templates select="/view/contentType[@view='main']/fieldset[@name='benefits']" mode="display"/>
    </xsl:template>
    
    <xsl:template match="fieldset[@name = 'benefits']" mode="display">
       <xsl:variable name="self" select="."/>
       
       <xsl:if test="cms:isNotFieldsetEmpty($self)">
            <section class="g-py-40">
                <div class="container">
            
                    <ul class="ametys-benefits-alt">
                        <xsl:apply-templates select="metadata" mode="benefits" />
                    </ul>
            
                </div>
            </section>
       </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata" mode="benefits">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        <xsl:param name="content" select="/view/content"/><!-- Use for benefits displayed in popup -->
        
        <xsl:if test="($value and @type != 'content') or ($value/@id and @type = 'content')">
            <li class="ametys-benefits-alt__item">
                <div class="ametys-benefits-alt__item-icon">
                    <xsl:apply-templates select="." mode="benefits-icon"/>
                </div>
                
                <xsl:variable name="definition" select="."/>
                <div class="ametys-benefits-alt__item-description">
                    <h2 class="ametys-benefits-alt__item-title"><xsl:value-of select="label"/></h2>
                    <p class="ametys-benefits-alt__item-text">
                        <xsl:for-each select="$value">
                            <xsl:if test="position() != 1">, </xsl:if>
                            <xsl:apply-templates select="$definition" mode="benefits-value">
                                <xsl:with-param name="value" select="."/>
                                <xsl:with-param name="content" select="$content"/>
                            </xsl:apply-templates>
                        </xsl:for-each>
                    </p>
                </div>
            </li>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata[@type='content']" mode="benefits-value">
        <xsl:param name="value"/>
        
        <xsl:value-of select="$value/@title"/>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'nbHours']" mode="benefits-value">
        <xsl:param name="value"/>
        
        <xsl:value-of select='format-number($value, "#,##")' />h
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'ects' and @type = 'content']" mode="benefits-value">
        <xsl:param name="value"/>
        
        <xsl:value-of select="$value/@title"/> <i18n:text i18n:key="PROGRAM_ECTS_UNITS" i18n:catalogue="skin.{$skin}"/>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'ects' and @type  = 'double']" mode="benefits-value">
        <xsl:param name="value"/>
        <xsl:param name="content"/>
        
        <xsl:variable name="currentEcts">
            <xsl:choose>
                <xsl:when test="$content/@path">
                    <!-- ECTS display outside content's page -->
                    <xsl:value-of select="odf:getEcts($content/@id, $content/@path)"/>
                </xsl:when>
                <xsl:otherwise>
                    <!-- ECTS display on content's page -->
                    <xsl:value-of select="odf:getCurrentEcts()"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:variable name="ects"><xsl:call-template name="transform-double"><xsl:with-param name="value" select="$currentEcts"/></xsl:call-template></xsl:variable>
        <xsl:value-of select="$ects"/> <i18n:text i18n:key="PROGRAM_ECTS_UNITS" i18n:catalogue="skin.{$skin}"/>
    </xsl:template>
    
    <xsl:template match="metadata" mode="benefits-value">
        <xsl:param name="value"/>
        
        <xsl:value-of select="$value"/>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'orgUnit']" mode="benefits-icon">
        <span class="ametys-icon-building"></span>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'educationLanguage']" mode="benefits-icon">
        <span class="ametys-icon-globe"></span>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'educationLevel']" mode="benefits-icon">
        <span class="ametys-icon-sign-in"></span>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'ects']" mode="benefits-icon">
        <span class="ametys-icon-medal"></span>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'duration']" mode="benefits-icon">
        <span class="ametys-icon-clock"></span>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'teachingTerm']" mode="benefits-icon">
        <span class="far fa-calendar-alt"></span>
    </xsl:template>
    
    <!-- Default icon for benefits -->
    <xsl:template match="metadata" mode="benefits-icon">
        <span class="ametys-icon-clock"></span>
    </xsl:template>

</xsl:stylesheet>