<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2019 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
        xmlns:xalan="http://xml.apache.org/xalan"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:odf="org.ametys.odf.OdfXSLTHelper"
        xmlns:escaper="org.apache.commons.lang.StringEscapeUtils"
        xmlns:url="org.ametys.core.util.URIUtils"
        xmlns:filename="org.ametys.core.util.FilenameUtils"
        exclude-result-prefixes="sitemap ametys resolver odf escaper url filename">

    <xsl:import href="skin://stylesheets/utils.xsl"/>     
    
    <xsl:template name="main-banner">
        <xsl:variable name="imgUrl"><xsl:call-template name="main-banner-illustration-url"/></xsl:variable>
        <div class="ametys-main-banner-alt" style="background-image: url({ametys:escapeURLforCSS($imgUrl)}); min-height: 360px;">

            <div class="container position-relative g-z-index-3">
                <xsl:call-template name="main-banner-breadcrumb"/>
            </div>
            
            <div class="container position-relative g-z-index-4">
                <xsl:call-template name="main-banner-category"/>
                <xsl:call-template name="main-banner-title"/>
                <xsl:call-template name="main-banner-subtitle"/>
            </div>
            
            <xsl:call-template name="main-banner-footer"/>
        </div>
    </xsl:template>
    
    <xsl:template name="main-banner-illustration-url">
        <xsl:variable name="image" select="metadata/illustration/image"/>
        <xsl:choose>
            <xsl:when test="$image">
                <xsl:call-template name="get-image-uri">
                    <xsl:with-param name="img" select="$image"/>
                    <xsl:with-param name="height" select="360"/>
                    <xsl:with-param name="width" select="1903"/>
                    <xsl:with-param name="isCropped" select="true()"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="main-banner-illustration-default-url"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="main-banner-illustration-default-url">
        <xsl:value-of select="ametys:skinURL('templates/common/img/banners/banner-6.jpg')"/>
    </xsl:template>
    
    <xsl:template name="main-banner-category"/>
    
    <xsl:template name="main-banner-title">
        <h1 class="ametys-main-banner-alt__title"><xsl:value-of select="metadata/title"/></h1>
    </xsl:template>
    
    <xsl:template name="main-banner-subtitle"/>
    
    <xsl:template name="main-banner-footer">
        <footer class="ametys-main-banner-alt-footer g-z-index-3">
            <div class="container">
                <div class="ametys-main-banner-alt-footer-inner">
                    <!-- Actions -->
                    <xsl:call-template name="main-banner-footer-items"/>
                    <!--  Mots -clés -->
                    <xsl:call-template name="main-banner-footer-keywords"/>
                </div>
            </div>
        </footer>
    </xsl:template>
    
    <xsl:template name="main-banner-footer-items">
        <div class="ametys-main-banner-alt-footer-section">
            <ul class="ametys-main-banner-alt-action-list">
                <!-- Add to cart -->
                <xsl:call-template name="main-banner-add-to-wishlist-item"/>
                
                <!-- PDF download -->
                <xsl:call-template name="main-banner-download-item"/>
            </ul>
        </div>
    </xsl:template>
    
    <xsl:template name="main-banner-download-item">
        <xsl:param name="downloadText"><i18n:text i18n:key="PROGRAM_HEADER_DOWNLOAD" i18n:catalogue="skin.{$skin}"/></xsl:param>
        <xsl:param name="downloadUrl" select="concat($uri-prefix, '/plugins/odf-web/', $site, '/_content/', /view/content/@name, '/', filename:filterName(/view/content/@title), '.pdf')"/>
        
        <li class="ametys-main-banner-alt-action-list__item">
            <a class="ametys-main-banner-alt-action-list__link" href="{url:encodePath($downloadUrl)}" target="_blank">
                <span class="ametys-main-banner-alt-action-list__item-icon ametys-icon-download"></span>
                <span class="ametys-main-banner-alt-action-list__item-text"><xsl:copy-of select="$downloadText"/></span>
            </a>
        </li>
    </xsl:template>
    
    <xsl:template name="main-banner-add-to-wishlist-item">
        <xsl:param name="addTextKey" select="concat('skin.', $skin, ':PROGRAM_HEADER_CART_ADD')"/>
        <xsl:param name="removeTextKey" select="concat('skin.', $skin, ':PROGRAM_HEADER_CART_DELETE')"/>
        
        <li class="ametys-main-banner-alt-action-list__item">
            <a id="header-add-to-wishlist" class="ametys-main-banner-alt-action-list__link" href="#"
               data-tf-is-in-wishlist="out"
               data-tf-default-text="{$addTextKey}"
               data-tf-active-text="{$removeTextKey}"
               data-tf-default-icon="ametys-icon-heart-alt-2"
               data-tf-active-icon="ametys-icon-heart"
               i18n:attr="data-tf-default-text data-tf-active-text">
                <span class="ametys-main-banner-alt-action-list__item-icon ametys-icon-heart-alt-2" style="width: 20px;"
                      data-tf-icon="data-tf-icon"></span>
                <span class="ametys-main-banner-alt-action-list__item-text"
                      data-tf-text="data-tf-text"><i18n:text i18n:key="{substring-after($addTextKey, ':')}" i18n:catalogue="{substring-before($addTextKey, ':')}"/></span>
            </a>
            
            <script>
                $j(document).ready(function() {
            
                    <xsl:variable name="itemId"><xsl:call-template name="compute-cartitem-id"/></xsl:variable>
                    
                    function _updateLink(answer)
                    {
                        $j.HSCore.components.HSToggleFavorite.init('#header-add-to-wishlist', {
                            isInWishList: answer,
                            itemId: "<xsl:value-of select="$itemId"/>",
                            itemTitle: "<xsl:value-of select="escaper:escapeJavaScript(@title)"/>",
                            callback: ODFCart.emptyCallback
                        });
                    }
                    
                    ODFCart.hasItem('<xsl:value-of select="$itemId"/>', _updateLink);
                });
            </script>
        </li>
    </xsl:template>
    
    <xsl:template name="main-banner-footer-keywords">
        <xsl:param name="maxLength">4</xsl:param>
        
        <xsl:if test="metadata/keywords">
            <div class="ametys-main-banner-alt-footer-section ametys-main-banner-alt-footer-section--right">
                <ul class="ametys-main-banner-alt-tags-list">
                
                    <xsl:for-each select="metadata/keywords[position() &lt;= $maxLength]">
                        <li class="ametys-main-banner-alt-tags-list__item">
                            <span class="ametys-tag"><xsl:value-of select="."/></span>
                        </li>        
                    </xsl:for-each>
                    
                    <xsl:if test="count(metadata/keywords) &gt; $maxLength">
                        <li class="ametys-main-banner-alt-tags-list__item ametys-dropdown">
                            <a id="hiddenTagsInvoker" class="ametys-tag ametys-tag--bold" href="#" aria-haspopup="true" aria-expanded="false"
                               data-dropdown-event="hover"
                               data-dropdown-target="#hiddenTags"
                               data-dropdown-type="css-animation"
                               data-dropdown-duration="200"
                               data-dropdown-delay="0"
                               data-dropdown-hide-on-scroll="false"
                               data-dropdown-animation-in="fadeIn"
                               data-dropdown-animation-out="fadeOut">+ <xsl:value-of select="count(metadata/keywords[position() &gt; $maxLength])"/></a>
                            
                            <div id="hiddenTags" class="ametys-dropdown-content-alt ametys-dropdown-content-alt--right u-dropdown--hidden w-300px w-lg-395px" aria-labelledby="hiddenTagsInvoker">
                                <ul class="ametys-main-banner-alt-tags-list">
                                    <xsl:for-each select="metadata/keywords[position() &gt;= $maxLength + 1]">
                                        <li class="ametys-main-banner-alt-tags-list__item">
                                            <span class="ametys-tag"><xsl:value-of select="."/></span>
                                        </li>   
                                    </xsl:for-each>
                                </ul>
                            </div>
                         </li>
                     </xsl:if>
                </ul>
            </div>
        </xsl:if>
    </xsl:template>

</xsl:stylesheet>