<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2019 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
        xmlns:xalan="http://xml.apache.org/xalan"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:odf="org.ametys.odf.OdfXSLTHelper"
        xmlns:cms="http://ametys.org/cms/3.0"
        xmlns:docbook="http://docbook.org/ns/docbook" 
        exclude-result-prefixes="sitemap ametys resolver odf docbook cms">

    <xsl:import href="skin://stylesheets/content/common/zone/aside.xsl"/>     
    
    <xsl:template match="fieldset[@name='aside']" mode="display">
        <aside class="ametys-courses-single-two-columns-content__sidebar">
            
            <xsl:variable name="self" select="."/>
       
            <xsl:if test="cms:isNotFieldsetEmpty($self)">
                <xsl:apply-templates select="fieldset|metadata" mode="display"/>
            </xsl:if>
            
            <xsl:call-template name="ref-programs"/>
        </aside>
    </xsl:template>
    
    <xsl:template name="ref-programs">
        <xsl:if test="/view/content/refProgram">
            <xsl:variable name="courseTypeId" select="ametys:contentAttribute(/view/content/@id, 'courseType')/@id"/>
            <xsl:variable name="courseTypeCode">
                <xsl:choose>
                    <xsl:when test="$courseTypeId"><xsl:value-of select="ametys:contentAttribute($courseTypeId, 'code')"/></xsl:when>
                    <xsl:otherwise></xsl:otherwise>
                </xsl:choose>
            </xsl:variable>
            
            <h2 class="ametys-section-title">
                <i18n:text i18n:key="COURSE_REF_PROGRAMS_DEFAULT" i18n:catalogue="skin.{$skin}"/>
            </h2>
            <ul class="ametys-external-links-list">
                <xsl:for-each select="/view/content/refProgram">
                    <li class="ametys-external-links-list__item">
                        <a class="ametys-external-links-list__link" href="{resolver:resolve('odf', @id)}">
                            <span class="ametys-external-links-list__link-text"><xsl:value-of select="."/></span>
                        </a>
                    </li>
                </xsl:for-each>
            </ul>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'teachingLanguage']" mode="key-info-icon">
        <span class="ametys-icon-globe"></span>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'openToExchangeStudents']" mode="key-info-icon">
        <span class="ametys-icon-globe"></span>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'formofteachingMethod']" mode="key-info-icon">
        <span class="fas fa-star"></span>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'startDate']" mode="key-info-icon">
        <span class="far fa-calendar-alt"></span>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'teachingTerm']" mode="key-info-value">
        <xsl:param name="value"/>
        
        <xsl:variable name="code" select="ametys:contentAttribute($value/@id, 'code')"/>
        <xsl:if test="$code = 'printemps' or $code='automne'">
            <xsl:call-template name="period-calendar">
                <xsl:with-param name="period" select="$code"/>
                <xsl:with-param name="withCaption" select="false()"/>
            </xsl:call-template>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'webLinkUrl']" mode="display">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
         
        <xsl:if test="$value">
            <section class="g-mb-55">
                <h2 class="ametys-section-title"><i18n:text i18n:key="PROGRAM_WEB_SITES" i18n:catalogue="skin.{$skin}"/></h2>
                
                <ul class="ametys-list-with-icon ametys-list-with-icon--blue">
                    <xsl:apply-templates select="." mode="value">
                        <xsl:with-param name="value" select="$value"/>
                    </xsl:apply-templates>
                </ul>
            </section>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'webLinkLabel']" mode="display"/>
    
    <xsl:template match="metadata[@name = 'webLinkUrl']" mode="value">
        <xsl:param name="value"/>
        <xsl:param name="labelValue" select="/view/content/metadata/*[local-name() = 'webLinkLabel']"/>
        
        <li class="ametys-list-with-icon__item">
            <a class="ametys-list-with-icon__link" href="{$value}">
                <xsl:apply-templates select="." mode="website-icon">
                    <xsl:with-param name="value" select="$value"/>
                </xsl:apply-templates>
                
                <xsl:choose>
                   <xsl:when test="normalize-space($labelValue) != ''"><xsl:value-of select="$labelValue"/></xsl:when>
                   <xsl:otherwise><xsl:value-of select="$value"/></xsl:otherwise>
                </xsl:choose>
            </a>
        </li>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'webLinkUrl']" mode="website-icon">
        <span class="ametys-list-with-icon__item-icon fas fa-external-link-alt"></span>
    </xsl:template>
</xsl:stylesheet>