<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
        xmlns:fo="http://www.w3.org/1999/XSL/Format"
        xmlns:xalan="http://xml.apache.org/xalan"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:odf="org.ametys.odf.OdfXSLTHelper"
        xmlns:cms="http://ametys.org/cms/3.0"
        xmlns:docbook="http://docbook.org/ns/docbook" 
        exclude-result-prefixes="sitemap ametys resolver odf docbook cms">
    
    <!-- Modalité de controle des connaissances-->
    
    <xsl:template match="fieldset[@name = 'mcc']" mode="display">
        <xsl:variable name="self" select="."/>
        
        <xsl:if test="cms:isNotFieldsetEmpty($self)">
             <fo:block>
                <fo:block xsl:use-attribute-sets="section-title">
                    <xsl:value-of select="label"/>
                </fo:block>
                
                <xsl:apply-templates select="metadata" mode="display"/> 
            </fo:block>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'mccSession1' or @name = 'mccSession2']" mode="display">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
         
        <xsl:if test="$value/@entryCount != '0'">
            
            <fo:block page-break-inside="avoid">
                <fo:block> 
                    <xsl:call-template name="title-style">
                        <xsl:with-param name="level" select="'2'"/>
                    </xsl:call-template>
                    <xsl:value-of select="label"/>
                </fo:block>
                
                <xsl:variable name="definition" select="."/>
                <fo:table table-layout="fixed" margin-top="5mm" padding="0pt" >
                    <xsl:call-template name="mcc-table-style"/>
                
                    <fo:table-body>
                        <fo:table-row>
                            <xsl:apply-templates select="metadata" mode="mcc-header"/>
                        </fo:table-row>
                        
                        <xsl:for-each select="$value">
                            <xsl:if test="position() != 1"><br/></xsl:if>
                            <xsl:apply-templates select="$definition" mode="value">
                                <xsl:with-param name="value" select="."/>
                            </xsl:apply-templates>
                        </xsl:for-each>
                    </fo:table-body>
                </fo:table>
            </fo:block>    
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="metadata" mode="mcc-header">
        <fo:table-cell>
            <xsl:call-template name="mcc-th-style"/>
            <fo:block><xsl:value-of select="label"/></fo:block>
        </fo:table-cell>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'mccSession1' or @name = 'mccSession2']" mode="value">
        <xsl:param name="value"/>
        
        <xsl:variable name="repeaterDef" select="."/>
                    
        <xsl:for-each select="$value/entry">
            <fo:table-row>
                <xsl:apply-templates select="$repeaterDef/metadata" mode="mcc-value">
                    <xsl:with-param name="entry" select="."/>
                </xsl:apply-templates>
            </fo:table-row>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template match="metadata" mode="mcc-value">
        <xsl:param name="entry"/>
        
        <fo:table-cell>
            <xsl:call-template name="mcc-td-style"/>
            <fo:block>
                <xsl:variable name="name" select="@name"/>
                <xsl:apply-templates select="." mode="value">
                    <xsl:with-param name="value" select="$entry/*[local-name()=$name]"/>
                </xsl:apply-templates>
            </fo:block>
        </fo:table-cell>
        
    </xsl:template>
    
</xsl:stylesheet>