<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2019 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
        xmlns:xalan="http://xml.apache.org/xalan"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:date="http://exslt.org/dates-and-times" extension-element-prefixes="date"
        exclude-result-prefixes="sitemap ametys">
    
    <xsl:template name="how-to-apply">
        <section class="ametys-section-with-bg-image g-py-65" style="background-image: url({ametys:skinURL('templates/common/img/banners/banner-4.jpg')});">
            <div class="container">
                
                <div class="ametys-cta-simple">
                    
                    <section class="g-mb-40">
                        
                        <h2 class="ametys-section-sub-title ametys-section-sub-title--has-line g-mb-50">How to apply</h2>
                        
                        <form action="/">
                            
                            <div class="form-group">
                                <label class="ametys-form-label-simple">Apply direct to Deakin</label>
                                <select class="ametys-form-control-simple"
                                        data-placeholder="Applications can be made directly to the University"
                                        data-open-icon="fa fa-angle-down"
                                        data-close-icon="fa fa-angle-up">
                                    <option></option>
                                    <option value="option 1">Option 1</option>
                                    <option value="option 2">Option 2</option>
                                    <option value="option 3">Option 3</option>
                                </select>
                            </div>
                            
                            <div class="form-group">
                                <label class="ametys-form-label-simple">Register your interest to study at Deakin</label>
                                <select class="ametys-form-control-simple"
                                        data-placeholder="Complete the register your interest form to receive information"
                                        data-open-icon="fa fa-angle-down"
                                        data-close-icon="fa fa-angle-up">
                                    <option></option>
                                    <option value="option 1">Option 1</option>
                                    <option value="option 2">Option 2</option>
                                    <option value="option 3">Option 3</option>
                                </select>
                            </div>
                            
                            <div class="form-group">
                                <label class="ametys-form-label-simple">Register your interest to study at Deakin</label>
                                <select class="ametys-form-control-simple"
                                        data-placeholder="Complete the register your interest form to receive information"
                                        data-open-icon="fa fa-angle-down"
                                        data-close-icon="fa fa-angle-up">
                                    <option></option>
                                    <option value="option 1">Option 1</option>
                                    <option value="option 2">Option 2</option>
                                    <option value="option 3">Option 3</option>
                                </select>
                            </div>
                        
                        </form>
                    
                    </section>
                    
                    <section>
                        <div class="ametys-richtext">
                            
                            <h3 class="ametys-richtext-title-4">Additional details</h3>
                            <p>Through a DLC: Some courses are only available for first year and students must transfer to online or campus based study. Through Deakin College.</p>
                            <p>
                                <a class="know-more" href="#">Start application process</a>
                            </p>
                        
                        </div>
                    </section>
                </div>
                
                <script>
                    $j.HSCore.components.HSSelect.init('select.ametys-form-control-simple');
                </script>
            </div>
        </section>
        
    </xsl:template>
    
</xsl:stylesheet>