<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                            xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
                            xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                            xmlns:i18n="http://apache.org/cocoon/i18n/2.1">

    <xsl:template name="footer">
        <footer class="ametys-footer">
            <div class="container">
                <div class="ametys-footer-inner">
                    <xsl:call-template name="footer-left"/>
                    <xsl:call-template name="footer-middle"/>
                </div>
            </div>
        </footer>
    </xsl:template>
    
    <xsl:template name="footer-left">
        <div class="ametys-footer-left">
            <xsl:call-template name="footer-logo"/>
            <xsl:call-template name="footer-address"/>
            <xsl:call-template name="footer-social-links"/>
        </div>
    </xsl:template>
    
    <xsl:template name="footer-logo">
        <div class="ametys-footer-logo">
            <a href="#">
                <img src="{ametys:skinURL('templates/common/img/logo-footer.svg')}" alt="Ametys Campus"/>
            </a>
        </div>
    </xsl:template>
    
    <xsl:template name="footer-address">
        <div class="ametys-footer-address">
                            <p>Ametys Campus <br/> 40 rue du village d’entreprises <br/> 31670 Labege</p>
       	</div>
    </xsl:template>
    
    <xsl:template name="footer-social-links">
        <ul class="ametys-footer-social">
            <xsl:call-template name="footer-social-link-facebook"/>
            <xsl:call-template name="footer-social-link-twitter"/>
            <xsl:call-template name="footer-social-link-linkedin"/>
            <xsl:call-template name="footer-social-link-youtube"/>
            <xsl:call-template name="footer-social-link-instagram"/>
        </ul>
    </xsl:template>
    
    <xsl:template name="footer-social-link-facebook">
        <li class="ametys-footer-social__item">
            <a class="ametys-footer-social__link" href="#" target="_blank">
                <span class="ametys-footer-social__item-icon fab fa-facebook-f"></span>
            </a>
        </li>
    </xsl:template>
    
    <xsl:template name="footer-social-link-twitter">
        <li class="ametys-footer-social__item">
            <a class="ametys-footer-social__link" href="#" target="_blank">
                <span class="ametys-footer-social__item-icon fab fa-x-twitter"></span>
            </a>
        </li>
    </xsl:template>
    
    <xsl:template name="footer-social-link-linkedin">
        <li class="ametys-footer-social__item">
            <a class="ametys-footer-social__link" href="#" target="_blank">
                <span class="ametys-footer-social__item-icon fab fa-linkedin-in"></span>
            </a>
        </li>
    </xsl:template>
    
    <xsl:template name="footer-social-link-youtube">
        <li class="ametys-footer-social__item">
            <a class="ametys-footer-social__link" href="#" target="_blank">
                <span class="ametys-footer-social__item-icon fab fa-youtube"></span>
            </a>
        </li>
    </xsl:template>
    
    <xsl:template name="footer-social-link-instagram">
        <li class="ametys-footer-social__item">
            <a class="ametys-footer-social__link" href="#" target="_blank">
                <span class="ametys-footer-social__item-icon fab fa-instagram"></span>
            </a>
        </li>
    </xsl:template>
    
    <xsl:template name="footer-middle">
        <div class="ametys-footer-middle">
            <div class="ametys-footer-middle-inner">
                <xsl:call-template name="footer-middle-catalog"/>
                <xsl:call-template name="footer-middle-direct-access"/>   
                <xsl:call-template name="footer-middle-other-links"/>
            </div>
        </div>
    </xsl:template> 
    
    <xsl:template name="footer-middle-catalog">
        <xsl:if test="/cms/inputData/sitemap//page[@PLUGIN_TAGS_CATALOG]">
            <div class="ametys-footer-middle-section">
                <h4 class="ametys-footer-title"><i18n:text i18n:key="SKIN_FOOTER_LINKS_CATALOG" i18n:catalogue="skin.{$skin}"/></h4>
                <ul class="ametys-footer-menu">
                    <xsl:apply-templates select="/cms/inputData/sitemap//page[@PLUGIN_TAGS_CATALOG]" mode="footer-link-item"/>
                </ul>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="footer-middle-direct-access">
        <xsl:if test="/cms/inputData/sitemap//page[@PLUGIN_TAGS_DIRECTACCESS]">
            <div class="ametys-footer-middle-section">
                <h4 class="ametys-footer-title"><i18n:text i18n:key="SKIN_FOOTER_LINKS_DIRECTACCESS" i18n:catalogue="skin.{$skin}"/></h4>
                <ul class="ametys-footer-menu">
                    <xsl:apply-templates select="/cms/inputData/sitemap//page[@PLUGIN_TAGS_DIRECTACCESS]" mode="footer-link-item"/>
                </ul>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="footer-middle-other-links">
        <xsl:if test="/cms/inputData/sitemap//page[@PLUGIN_TAGS_FOOTER_LINKS]">
            <div class="ametys-footer-middle-section">
                <h4 class="ametys-footer-title"><i18n:text i18n:key="SKIN_FOOTER_LINKS_OTHERS" i18n:catalogue="skin.{$skin}"/></h4>
                <ul class="ametys-footer-menu">
                    <xsl:apply-templates select="/cms/inputData/sitemap//page[@PLUGIN_TAGS_FOOTER_LINKS]" mode="footer-link-item"/>
                </ul>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="page" mode="footer-link-item">
        <li class="ametys-footer-menu__item">
            <a class="ametys-footer-menu__link" href="{resolver:resolve('page', @sitemap:id)}"><xsl:value-of select="@sitemap:title"/></a>
        </li>
    </xsl:template>
    
</xsl:stylesheet>