<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                            xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
                            xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                            xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                            exclude-result-prefixes="sitemap resolver ametys i18n">

    <xsl:import href="skin://stylesheets/cart.xsl"/>
    
    <xsl:template name="header">
        <header class="ametys-header" id="js-header" data-header-fix-moment="600" data-header-fix-effect="slide">
            <xsl:call-template name="header-top"/>
            <xsl:call-template name="header-main"/>
        </header>
    </xsl:template>
    
    <xsl:template name="header-top">
        <div class="ametys-header-top">
            <div class="container">
                <div class="ametys-header-top-inner">
                    <xsl:call-template name="header-top-left"/>
                    
                    <xsl:call-template name="header-top-right"/>
                </div><!-- END ametys-header-top-inner -->
            </div><!-- END container -->
        </div>
    </xsl:template>
    
    <xsl:template name="header-top-left">
        <div id="partitionMenu" class="ametys-header-top-left">
            <xsl:call-template name="header-top-external-links"/>
        </div>
        
        <script>
          $('#partitionMenu').HSAmetysToggle();

          $(window).on('resize', function() {
            if(window.innerWidth >= 768) {
              $('#partitionMenu').HSAmetysToggle('reset');
            }
          });
        </script>
    </xsl:template>
    
    <xsl:template name="header-top-external-links">
        <button class="ametys-header-partition-menu-invoker" type="button" data-toggle-invoker="">
            <i18n:text i18n:catalogue="skin.{$skin}" i18n:key="SKIN_JUMP_TO"/>
            <span class="ametys-header-partition-menu-invoker__icon ametys-icon-angle-down"></span>
        </button>
    
        <ul class="ametys-header-partition-menu" data-toggle-target="">
            <li class="ametys-header-partition-menu__item">
                <a class="ametys-header-partition-menu__link" href="#">
                    <span class="ametys-header-partition-menu__item-icon ametys-icon-globe"></span>
                    International Students
                </a>
            </li>
            <li class="ametys-header-partition-menu__item">
                <a class="ametys-header-partition-menu__link" href="#">
                    <span class="ametys-header-partition-menu__item-icon ametys-icon-graduation-cap"></span>
                    Career practitioners
                </a>
            </li>
            <li class="ametys-header-partition-menu__item">
                <a class="ametys-header-partition-menu__link" href="#">
                    <span class="ametys-header-partition-menu__item-icon ametys-icon-book"></span>
                    Library
                </a>
            </li>
            <li class="ametys-header-partition-menu__item">
                <a class="ametys-header-partition-menu__link" href="#">
                    <span class="ametys-header-partition-menu__item-icon ametys-icon-user"></span>
                    Staff
                </a>
            </li>
        </ul>
    </xsl:template>
    
    <xsl:template name="header-top-right">
        <div class="ametys-header-top-right">
            <xsl:call-template name="header-top-search"/>
        </div>
    </xsl:template>
    
    <xsl:template name="header-top-search">
        <xsl:if test="$odfSearchPage">
            <form action="{$odfSearchPageUri}">
                <div class="ametys-header-search">
                    <input type="hidden" name="submit-form"/>
                    <input class="ametys-header-search__control" name="user.input.criterion.common$titleorwording$textfield$1" type="search" placeholder="skin.{$skin}:SKIN_SEARCH" i18n:attr="placeholder"/>
                    <button class="ametys-header-search__btn" type="submit">
                        <span class="ametys-icon-magnifier"></span>
                    </button>
                </div>
            </form>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="header-main">
        <div class="ametys-header-main">
            <div class="container">
                <div class="ametys-header-main-inner">
                    
                    <!-- Logo -->
                    <xsl:call-template name="header-main-logo"/>
                    
                    <!-- Main section menu -->
                    <xsl:call-template name="header-main-menu"/>
                    
                    <!-- User menu -->
                    <xsl:call-template name="header-main-profile-menu"/>
                </div>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="header-main-logo">
        <div class="ametys-header-logo">
            <a href="{$site-uri-prefix}/{$lang}/index.html">
                <img class="ametys-header-logo__img-desktop" src="{ametys:skinURL('templates/common/img/logo-header.svg')}" alt="skin.{$skin}:SKIN_TITLE" i18n:attr="alt"/>
                <img class="ametys-header-logo__img-mobile" src="{ametys:skinURL('templates/common/img/logo-header-mobile.svg')}" alt="skin.{$skin}:SKIN_TITLE" i18n:attr="alt"/>
            </a>
        </div>
    </xsl:template>
    
    <xsl:template name="header-main-menu">
        <div class="ametys-header-menu-wrap">

            <button class="ametys-hamburger" type="button" aria-expanded="false" aria-controls="navBar"
                data-toggle="collapse" data-target="#mainMenu">
                <span class="ametys-hamburger__box">
                    <span class="ametys-hamburger__inner"></span>
                </span>
            </button>
            
            <xsl:call-template name="header-main-menu-items"/>
        </div>
        
        <script>

              $.HSCore.helpers.HSHamburgers.init('.ametys-hamburger');

              $('.ametys-header-menu').HSMegaMenu({
                  
                event: 'hover',
                pageContainer: $('.container'),
                breakpoint: 767
                  
              });
                        
        </script>
    </xsl:template>
    
    <xsl:template name="header-main-menu-items">
        <ul id="mainMenu" class="ametys-header-menu collapse">
            <xsl:for-each select="$sitemap/page[@PLUGIN_TAGS_SECTION and (not(@sitemap:invisible) or @sitemap:invisible = 'false')]">
                <li class="ametys-header-menu__item"
                    data-animation-in="fadeIn"
                    data-animation-out="fadeOut"
                    data-max-width="60%">
                    <xsl:if test="page">
                        <xsl:attribute name="class">ametys-header-menu__item hs-has-sub-menu</xsl:attribute>
                    </xsl:if>
                    <a class="ametys-header-menu__link" href="{resolver:resolve('page', @sitemap:id)}" aria-haspopup="true" aria-expanded="false">
                        <xsl:value-of select="@sitemap:title" />
                    </a>
                    
                    <xsl:call-template name="header-main-menu-subitems">
                        <xsl:with-param name="pages" select="page[(not(@sitemap:invisible) or @sitemap:invisible = 'false')]"/>
                    </xsl:call-template>
                </li>
            </xsl:for-each>
        </ul>
    </xsl:template>
    
    <xsl:template name="header-main-menu-subitems">
        <xsl:param name="level">1</xsl:param>
        <xsl:param name="maxLevel">2</xsl:param>
        <xsl:param name="pages"/>
        
        <xsl:if test="$pages">
            <ul class="ametys-header-sub-menu hs-sub-menu">
                <xsl:for-each select="$pages">
                    <li class="ametys-header-sub-menu__item">
                        <xsl:if test="page[(not(@sitemap:invisible) or @sitemap:invisible = 'false')] and $level &lt; $maxLevel">
                            <xsl:attribute name="class">ametys-header-menu__item hs-has-sub-menu</xsl:attribute>
                        </xsl:if>
                    
                        <a class="ametys-header-sub-menu__link" href="{resolver:resolve('page', @sitemap:id)}" aria-haspopup="true" aria-expanded="false">
                            <xsl:if test="$level &lt; $maxLevel">
                                <xsl:attribute name="aria-haspopup">true</xsl:attribute>
                                <xsl:attribute name="aria-expanded">false</xsl:attribute>
                            </xsl:if>
                            <xsl:value-of select="@sitemap:title" />
                        </a>
                        
                        <xsl:if test="$level &lt; $maxLevel">
                            <xsl:call-template name="header-main-menu-subitems">
                                <xsl:with-param name="level" select="$level + 1"/>
                                <xsl:with-param name="maxLevel" select="$maxLevel"/>
                                <xsl:with-param name="pages" select="page[(not(@sitemap:invisible) or @sitemap:invisible = 'false')]"/>
                            </xsl:call-template>
                        </xsl:if>
                    </li>
                </xsl:for-each>
            </ul>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="header-main-profile-menu">
        <ul class="ametys-header-profile-menu">
            <xsl:call-template name="header-main-profile-menu-basket-item"/>
            <xsl:call-template name="header-main-profile-menu-user-item"/>    
            <xsl:call-template name="header-main-profile-menu-log-in"/>    
        </ul>
        
        <script type="text/javascript">
            $j(document).ready(function() {
                var _getAmetysUserCb = function(user)
                {
                    if (user)
                    {
                        $j('#userMenuItem').find('.ametys-header-profile-menu__item-text').html(user.fullname);
                        $j('#userMenuItem').show();
                        $j('#userConnectItem').hide();
                    }
                    else
                    {
                        $j('#userMenuItem').hide();
                        $j('#userConnectItem').show();
                    }
                }
                
                getAmetysUser(_getAmetysUserCb);
            });
        </script>
    </xsl:template>
    
    <xsl:template name="header-main-profile-menu-log-in">
        <xsl:if test="ametys:pageId() != ''">
            <li id="userConnectItem" class="ametys-header-profile-menu__item ametys-dropdown" style="display: none !important;">
                <a class="ametys-header-connect-btn" href="{ametys:siteUriPrefix()}/_authenticate?requestedURL={ametys:siteUriPrefix()}/{$lang}/{$sitemap//page[@sitemap:current = 'true']/@sitemap:path}.html">
                    <span class="ametys-header-connect-btn__icon ametys-icon-user"></span>
                    <i18n:text i18n:key="SKIN_LOGIN" i18n:catalogue="skin.{$skin}" />
                </a>
            </li>         
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="header-main-profile-menu-user-item">
        <!-- User menu -->
        <li id="userMenuItem" class="ametys-header-profile-menu__item ametys-dropdown" style="display: none !important;">
            <a id="profileMenuInvoker" class="ametys-header-profile-menu__link ametys-dropdown-invoker" href="#" aria-controls="account-dropdown" aria-haspopup="true" aria-expanded="false"
               data-dropdown-event="hover"
               data-dropdown-target="#profileMenu"
               data-dropdown-type="css-animation"
               data-dropdown-duration="200"
               data-dropdown-delay="0"
               data-dropdown-hide-on-scroll="false"
               data-dropdown-animation-in="fadeIn"
               data-dropdown-animation-out="fadeOut">
                <span class="ametys-header-profile-menu__item-icon ametys-icon-user"></span>
                <span class="ametys-header-profile-menu__item-text"></span>
                <span class="ametys-dropdown-invoker__icon ametys-icon-angle-down"></span>
            </a>
            
            <div id="profileMenu" class="ametys-dropdown-content u-dropdown--hidden" aria-labelledby="profileMenuInvoker" style="width: 200px;">
                <ul class="ametys-dropdown-menu">
                    <!-- <xsl:call-template name="header-main-profile-menu-user-item-settings"/> -->
                    <xsl:call-template name="header-main-profile-menu-user-item-profile"/>
                    <xsl:call-template name="header-main-profile-menu-user-item-logout"/>
                </ul>
            </div>
        </li>
    </xsl:template>
    
    <xsl:template name="header-main-profile-menu-user-item-logout">
        <li class="ametys-dropdown-menu__item">
            <a
                class="ametys-dropdown-menu__link"
                href="{ametys:siteUriPrefix()}/logout.html?requestedURL={ametys:siteUriPrefix()}/{$lang}/index.html">
                <i18n:text i18n:key="SKIN_LOGOUT" i18n:catalogue="skin.{$skin}"/>
            </a>
        </li>
    </xsl:template>
    
    <xsl:template name="header-main-profile-menu-user-item-settings">
        <li class="ametys-dropdown-menu__item">
            <a class="ametys-dropdown-menu__link" href="#"><i18n:text i18n:key="SKIN_USER_SETTINGS" i18n:catalogue="skin.{$skin}"/></a>
        </li>
    </xsl:template>
    
    <xsl:template name="header-main-profile-menu-user-item-profile">
        <xsl:variable name="userProfilePage" select="ametys:findPagesIdsByTag('USER_PROFILE')"/>
            
        <xsl:if test="$userProfilePage/@id">
            <li class="ametys-dropdow$n-menu__item">
                <a class="ametys-dropdown-menu__link" href="{resolver:resolve('page', $userProfilePage/@id)}"><i18n:text i18n:key="SKIN_USER_PROFILE" i18n:catalogue="skin.{$skin}"/></a>
            </li>
        </xsl:if>
    </xsl:template>
</xsl:stylesheet>