<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
-->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:docbook="http://docbook.org/ns/docbook"
                xmlns:xalan="http://xml.apache.org/xalan"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:fo="http://www.w3.org/1999/XSL/Format"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:cms="http://ametys.org/cms/3.0"
                xmlns:date="http://exslt.org/dates-and-times"
                xmlns:exsl="http://exslt.org/common"
                exclude-result-prefixes="docbook"
                extension-element-prefixes="resolver">
                
    <xsl:import href="plugin:odf://stylesheets/pdf/booklet/educationalBookletPdf.xsl"/>
    <xsl:import href="skin://stylesheets/fo-styling.xsl" />
    
    <xsl:variable name="skin" select="ametys:skin()"/>
    
    <xsl:template match="/view">
        <fo:root>
            <fo:layout-master-set>
                <!-- Master 2 columns -->
                <fo:simple-page-master master-name="page-2-columns" page-width="210mm" page-height="297mm" margin-left="0cm" 
                    margin-right="0cm" margin-top="2cm" margin-bottom="1.5cm">
                    <fo:region-body margin-top="2.5cm" margin-bottom="2cm" column-count="2" column-gap="30" margin-left="1.5cm" margin-right="1.5cm">
                        <xsl:call-template name="region-body-definition"/>
                    </fo:region-body>
                    <fo:region-before>
                        <xsl:call-template name="region-before-definition"/>
                    </fo:region-before>
                    <fo:region-after>
                        <xsl:call-template name="region-after-definition"/>
                    </fo:region-after>
                </fo:simple-page-master>
                
                <fo:simple-page-master master-name="page" page-width="210mm" page-height="297mm" margin-left="0cm" 
                    margin-right="0cm" margin-top="1.5cm" margin-bottom="1.5cm">
                    <fo:region-body margin-top="2.5cm" margin-bottom="2cm" column-count="1" margin-left="1.5cm" margin-right="1.5cm">
                        <xsl:call-template name="region-body-definition"/>
                    </fo:region-body>
                    <fo:region-before>
                        <xsl:call-template name="region-before-definition"/>
                    </fo:region-before>
                    <fo:region-after>
                        <xsl:call-template name="region-after-definition"/>
                    </fo:region-after>
                </fo:simple-page-master>
            </fo:layout-master-set>
            
            <!--  The bookmark tree -->
            <xsl:call-template name="bookmark-tree" />
            
            <!-- Contents -->
            <xsl:call-template name="contents"/>
        </fo:root>
    </xsl:template>
    
    <xsl:template name="xsl-region-before">
        <fo:static-content flow-name="xsl-region-before" space-after="1cm">
            <xsl:call-template name="xsl-region-before-content"/>
       </fo:static-content>
    </xsl:template>
    
    <xsl:template name="xsl-region-before-content">
        <fo:block margin-top="0cm" margin-right="1.5cm" margin-left="1.5cm">
            <fo:external-graphic src="url('skin:{$skin}://resources/templates/common/img/logo-header.svg')" content-width="scale-to-fit" content-height="1.5cm" vertical-align="top"/>
            <fo:external-graphic src="url('skin:{$skin}://resources/templates/common/img/header.png')" width="12.9cm" height="2cm" content-width="scale-to-fit" />
        </fo:block>
    </xsl:template>
    
    <xsl:template name="footer-logo">
        <fo:table-cell vertical-align="middle" text-align="right" padding-right="1.5cm">
            <fo:block><fo:external-graphic src="url('skin:{$skin}://resources/templates/common/img/logo-header-mobile.svg')" width="1cm" height="2cm" content-width="scale-to-fit" text-align="right"/></fo:block>
        </fo:table-cell>
    </xsl:template>
    
</xsl:stylesheet>