<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:date="http://exslt.org/dates-and-times" extension-element-prefixes="date"
        exclude-result-prefixes="ametys resolver">

    <xsl:template name="benefits">
        <div class="ametys-benefits">
            <div class="ametys-benefits-inner">
                
                <xsl:call-template name="benefits-item-1"/>
                <xsl:call-template name="benefits-item-2"/>
                <xsl:call-template name="benefits-item-3"/>
                <xsl:call-template name="benefits-item-4"/>
                
            </div>
        </div>
    </xsl:template>
    
    <!-- Explore -->
    <xsl:template name="benefits-item-1">
        <div class="ametys-benefits__item">
            <div class="ametys-benefits__item-icon ametys-icon-compas-alt"></div>
            
            <h3 class="ametys-benefits__item-title">Explorer</h3>
            <p class="ametys-benefits__item-description">Parcourir plus de 200 formations</p>
        </div>
    </xsl:template>
    
    <!-- Save -->
    <xsl:template name="benefits-item-2">
        <div class="ametys-benefits__item">
            <div class="ametys-benefits__item-icon ametys-icon-heart-alt"></div>
            
            <h3 class="ametys-benefits__item-title">Sauvegarder</h3>
            <p class="ametys-benefits__item-description">Créer une liste de favoris de vos formations préférés</p>
        </div>
    </xsl:template>
    
    <!-- Choose -->
    <xsl:template name="benefits-item-3">
        <div class="ametys-benefits__item">
            <div class="ametys-benefits__item-icon">
                <img src="{ametys:skinURL('templates/common/fonts/ametys-icons/svg/target-primary.svg')}" alt="Image Description"/>
            </div>
            
            <h3 class="ametys-benefits__item-title">Choisir</h3>
            <p class="ametys-benefits__item-description">Opter pour les formations les plus adpatées à votre profil</p>
        </div>
    </xsl:template>
    
    <!-- Apply -->
    <xsl:template name="benefits-item-4">
        <div class="ametys-benefits__item">
            <div class="ametys-benefits__item-icon">
                <img src="{ametys:skinURL('templates/common/fonts/ametys-icons/svg/paper-plane-primary.svg')}" alt="Image Description"/>
            </div>
            
            <h3 class="ametys-benefits__item-title">S’inscrire</h3>
            <p class="ametys-benefits__item-description">Postuler directement sur le portal de formation</p>
        </div>
    </xsl:template>
    
</xsl:stylesheet>