<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        exclude-result-prefixes="ametys resolver">

    <xsl:variable name="orgunits" select="/cms/inputData/Model/orgunits/content[@name != 'orgunit-root-orgunit']"/>
    
    <xsl:template name="orgunits-carousel">
        <xsl:if test="$orgunits">
            <div class="orgunits-carousel-home">
                <div class="container">
                    <xsl:call-template name="orgunits-carousel-header"/>
                </div>
                
                <div id="educationCarousel" class="js-carousel ametys-images-with-description"
                     data-speed="4000"
                     data-autoplay="true"
                     data-infinite="true"
                     data-slides-show="5"
                     data-center-mode="true"
                     data-center-padding="140px"
                     data-arrows-classes="ametys-arrow ametys-arrow--dark"
                     data-arrow-left-classes="ametys-arrow--right fa fa-angle-left"
                     data-arrow-right-classes="ametys-arrow--left fa fa-angle-right">
                   <xsl:attribute name="data-responsive">
                   [{
                     "breakpoint": 1600,
                     "settings": {
                       "slidesToShow": 3,
                       "centerPadding": "240px"
                     }
                   }, {
                     "breakpoint": 1025,
                     "settings": {
                       "slidesToShow": 3,
                       "centerPadding": "100px"
                     }
                   }, {
                     "breakpoint": 768,
                     "settings": {
                       "slidesToShow": 2,
                       "centerPadding": false
                     }
                   }, {
                     "breakpoint": 576,
                     "settings": {
                       "slidesToShow": 1,
                       "centerPadding": false
                     }
                   }]
                   </xsl:attribute>
                   
                   <xsl:apply-templates select="$orgunits" mode="orgunits-carousel-item"/>
                </div>
            </div>
            
             <script>
                $.HSCore.components.HSCarousel.init('#educationCarousel');
            </script>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="orgunits-carousel-header">
        <div class="text-center mb-5">
            <h2>
                <i18n:translate>
                    <i18n:text i18n:key="SKIN_ORGUNITS_CAROUSEL_HEADER" i18n:catalogue="skin.{$skin}"/>
                    <i18n:param><xsl:value-of select="count($orgunits)"/></i18n:param>
                </i18n:translate>
            </h2>
            <h6 class="ametys-richtext-title-6"><i18n:text i18n:key="SKIN_ORGUNITS_CAROUSEL_TEXT" i18n:catalogue="skin.{$skin}"/></h6>
        </div>
    </xsl:template>
    
    <xsl:template match="content" mode="orgunits-carousel-item">
        <div class="js-slide">
            <form action="{$odfSearchPageUri}" method="POST">
                <input type="hidden" name="user.input.facet.ContentReturnable$ProgramSearchable$indexingField$org.ametys.plugins.odf.Content.abstractProgram$orgUnit" value="{@id}"/>
                <input type="hidden" name="submit-form" value="true"/>
                <a class="ametys-images-with-description__item" href="#" onclick="$j(this).parent('form').submit()">
                    <xsl:call-template name="orgunits-carousel-item-image"/>
                    <h6 class="ametys-images-with-description__item-title"><xsl:value-of select="@title"/></h6>
                </a>
            </form>
        </div>
    </xsl:template>
    
    <xsl:template name="orgunits-carousel-item-image">
        <xsl:param name="imgWidth">400</xsl:param>
        <xsl:param name="imgHeight">270</xsl:param>
        
        <xsl:variable name="illustrationPath" select="html/head/meta[@name = 'illustration/image;uri']/@content"/>
        <xsl:variable name="logoPath" select="html/head/meta[@name = 'logo/image;uri']/@content"/>
        
        <xsl:variable name="imgSrc">
            <xsl:choose>
                <xsl:when test="$illustrationPath != ''">
                    <xsl:call-template name="get-image-uri-from-attribute">
                        <xsl:with-param name="id" select="@id"/>
                        <xsl:with-param name="height" select="$imgHeight"/>
                        <xsl:with-param name="width" select="$imgWidth"/>
                        <xsl:with-param name="cropped" select="true()"/>
                    </xsl:call-template>
                </xsl:when>
                <xsl:when test="$logoPath != ''">
                    <xsl:call-template name="get-image-uri-from-attribute">
                        <xsl:with-param name="id" select="@id"/>
                        <xsl:with-param name="attributePath" select="'logo/image'"/>
                        <xsl:with-param name="height" select="$imgHeight"/>
                        <xsl:with-param name="width" select="$imgWidth"/>
                        <xsl:with-param name="cropped" select="true()"/>
                    </xsl:call-template>
                </xsl:when>
                <xsl:otherwise><xsl:call-template name="orgunits-carousel-item-default-image-url"/></xsl:otherwise><!-- default image -->
            </xsl:choose>
        </xsl:variable>
        
        <span class="ametys-images-with-description__item-img-wrap">
            <img class="ametys-images-with-description__item-img" src="{$imgSrc}" alt="{@title}"/>
        </span>
    </xsl:template>
    
    <xsl:template name="orgunits-carousel-item-default-image-url">
        <xsl:value-of select="ametys:skinURL('templates/common/img/400x270/default.png')"/>
    </xsl:template>
    
</xsl:stylesheet>