<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
		xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
		xmlns:xalan="http://xml.apache.org/xalan"
		xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
		xmlns:date="http://exslt.org/dates-and-times" extension-element-prefixes="date"
		exclude-result-prefixes="sitemap ametys resolver">

	<xsl:import href="skin://stylesheets/main.xsl" />
	
	<xsl:template name="additionnal-css" >
		<link rel="stylesheet" href="{ametys:skinURL('zones/authorization/scss/main.css')}"/>
		<link rel="stylesheet" href="{ametys:skinURL('zones/authorization/scss/print.css')}"/>
	</xsl:template>
	
	<xsl:template name="additionnal-script" >
		<script src="{ametys:skinURL('templates/common/plugins/jquery-validation/dist/jquery.validate.js')}"></script>
		<script src="{ametys:skinURL('templates/common/plugins/chosen/chosen.jquery.js')}"></script>
		<script src="{ametys:skinURL('templates/common/js/components/hs.select.js')}"></script>
		<script src="{ametys:skinURL('templates/common/js/components/hs.validation.js')}"></script>
	</xsl:template>
	
     <xsl:template name="main-content">
     	<xsl:variable name="bgImg"><xsl:call-template name="main-banner-background-url"/></xsl:variable>
     	
     	<div class="ametys-main-content authorization" style="background-image: url({ametys:escapeURLforCSS($bgImg)});">
			<div class="container">
				<div class="ametys-authorization-wrapper">
					<xsl:call-template name="left-section"/>
					<xsl:call-template name="right-section"/>
				</div>
			</div>
		</div>
    </xsl:template>
    
    <xsl:template name="main-banner-background-url">
        <xsl:value-of select="ametys:skinURL('zones/authorization/img/bg-1.jpg')"/>
    </xsl:template>
    
    <xsl:template name="left-section">
		<div class="ametys-authorization-left-section">
			<div class="ametys-authorization-call-to-action">
				<p class="ametys-authorization-call-to-action__text">
					<i18n:text i18n:key="SKIN_FO_LOGIN_TEXT" i18n:catalogue="skin.{$skin}"/>
				</p>
			</div>
		</div>
	</xsl:template>
	
	<xsl:template name="right-section">
		<div class="ametys-authorization-right-section">
			<zone name="default" level="1"/>
		</div>
	</xsl:template>
    
</xsl:stylesheet>