<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2020 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                extension-element-prefixes="ametys">
    
    <xsl:import href="plugin:workspaces://pages/services/search/module/common.xsl"/>
    
    <xsl:variable name="site-uri-prefix" select="ametys:siteUriPrefix()"/>
    <xsl:variable name="lang" select="ametys:lang()"/>
    <xsl:variable name="skin" select="ametys:skin()"/>
    
    <xsl:template name="format-date">
        <xsl:param name="date"/>
        
        <i18n:text i18n:key="SKIN_SERVICE_SEARCH_VIEW_LAST_MODIFIED_DATE" i18n:catalogue="skin.{$skin}"/><i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="long" value="{$date}"/>
    </xsl:template>
    
    <xsl:template name="project">
        <xsl:if test="project">
            <h3 class="ametys-schedule-title">
                <xsl:attribute name="style">color: <xsl:value-of select="project/category/color/main"/></xsl:attribute>
                <i class="ametys-schedule-title__icon fas fa-dice-d6"></i>
                <xsl:value-of select="project/title"/>
            </h3>
        </xsl:if>
    </xsl:template>
</xsl:stylesheet>