<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2020 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                extension-element-prefixes="ametys">
    
    <xsl:import href="plugin:workspaces://pages/services/search/module/documents.xsl"/>
    <xsl:import href="skin://services/workspaces/pages/services/search/module/common.xsl"/>
    
    <xsl:template match="hit">
        <li data-module-hit="true" class="ametys-search-list__item">
			<div class="ametys-search-item">
				<a class="ametys-search-item__full-link" href="{uri}" title="{title}"></a>
				
                <div class="ametys-search-item-header">
					<div class="ametys-document">
						<xsl:call-template name="file-icon"/>
						<div class="ametys-document-info">
							<xsl:call-template name="file-title"/>
							<xsl:call-template name="file-size"/>
						</div>
					</div>
				</div>
				
				<div class="ametys-search-item-info">
					<div class="ametys-search-item-info__item">
						<div class="ametys-schedule">
							<xsl:call-template name="project"/>
							<ul class="ametys-schedule-list">
								<li class="ametys-schedule-list__item">
									<xsl:call-template name="publication-date"/>
								</li>
							</ul>
						</div>
					</div>
				</div>
			</div>
		</li>
    </xsl:template> 
    
    <xsl:template name="file-icon">
        <i class="ametys-document-icon">
            <xsl:variable name="icon" select="concat('img/document/type/', fileType, '.svg')"/>
            <img src="{ametys:pluginResourceURL('workspaces', $icon)}" height="40" width="40"/>
        </i>
    </xsl:template>
    
    <xsl:template name="file-title">
    	<h3 class="ametys-document-info__name ametys-truncate-1">
			<xsl:value-of select="title"/>
		</h3>
    </xsl:template>
    
    <xsl:template name="file-size">
        <div class="ametys-document-info__size">
            <xsl:call-template name="format-size">
                <xsl:with-param name="size" select="length"/>
            </xsl:call-template>
        </div>
    </xsl:template>
    
    <xsl:template name="publication-date">
    	<i class="ametys-schedule-list__item-icon far fa-clock"></i>
    	
    	<xsl:choose>
    		<xsl:when test="lastModified">
    			<xsl:call-template name="format-date">
                    <xsl:with-param name="date" select="lastModified"/>
                </xsl:call-template>
    		</xsl:when>
    		<xsl:otherwise>
                <xsl:call-template name="format-date">
                    <xsl:with-param name="date" select="creationDate"/>
                </xsl:call-template>
    		</xsl:otherwise>
    	</xsl:choose>
    </xsl:template>
    
    <xsl:template name="format-size">
        <xsl:param name="size"/>
        
        <xsl:choose>
            <xsl:when test="$size &lt; 1024">
                <i18n:translate>
                    <i18n:text i18n:key="ATTACHMENTS_FILE_SIZE_BYTES" i18n:catalogue="plugin.web"/>
                    <i18n:param><xsl:value-of select="$size"/></i18n:param>
                </i18n:translate>
            </xsl:when>
            <xsl:when test="$size &lt; (1024 * 1024)">
                <i18n:translate>
                    <i18n:text i18n:key="ATTACHMENTS_FILE_SIZE_KB" i18n:catalogue="plugin.web"/>
                    <i18n:param><xsl:value-of select="round($size div 1024)"/></i18n:param>
                </i18n:translate>
            </xsl:when>
            <xsl:otherwise>
                <i18n:translate>
                    <i18n:text i18n:key="ATTACHMENTS_FILE_SIZE_MB" i18n:catalogue="plugin.web"/>
                    <i18n:param><xsl:value-of select="round($size div (1024 * 1024))"/></i18n:param>
                </i18n:translate>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
</xsl:stylesheet>