<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2020 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:datetime="http://ametys.org/datetime/4.2"
                extension-element-prefixes="datetime">
    
    <xsl:import href="plugin:workspaces://pages/services/search/module/events.xsl"/>
    <xsl:import href="skin://services/workspaces/pages/services/search/module/common.xsl"/>

    <xsl:import href="skin://stylesheets/utils.xsl"/>
    <xsl:import href="plugin:core://stylesheets/helper/datetime.xsl"/>
    
    <xsl:variable name="date-format" select="ametys:translate(concat('skin.', $skin, ':SKIN_SERVICE_SEARCH_EVENTS_DATE_FORMAT'))"/>
    <xsl:variable name="datetime-format" select="ametys:translate(concat('skin.', $skin, ':SKIN_SERVICE_SEARCH_EVENTS_DATETIME_FORMAT'))"/>
    <xsl:variable name="time-format" select="ametys:translate(concat('skin.', $skin, ':SKIN_SERVICE_SEARCH_EVENTS_TIME_FORMAT'))"/>
    
    <xsl:template match="hit">
    	<li class="ametys-search-list__item" data-module-hit="true">
			<div class="ametys-search-item">
				<a class="ametys-search-item__full-link" href="{uri}"></a>
				
				<div class="ametys-search-item-header">
					<div class="ametys-event">
						
                        <xsl:call-template name="event-timeslot"/>
                        
						<div class="ametys-event-section align-items-center">
							<xsl:call-template name="event-start-day"/>
                            
							<xsl:call-template name="event-title"/>
						</div>
                        
                        <xsl:call-template name="event-location"/>
					</div>
				</div>
				
				<div class="ametys-search-item-info">
					<div class="ametys-search-item-info__item">
						<div class="ametys-schedule">
							
                            <xsl:call-template name="project"/>
                            <xsl:call-template name="calendar"/>
						</div>
					</div>
				</div>
			</div>
		</li>
    </xsl:template> 
    
    <xsl:template name="event-timeslot">
        <xsl:if test="fullDay != 'true' or not(datetime:sameDate(startDate, endDate))">
            <div class="ametys-event-section">
                <div class="ametys-event-section-side"></div>
                <div class="ametys-event-section-content">
                    <div class="ametys-event__time">
                        <i class="fas fa-clock"></i>
                        <xsl:text> </xsl:text>
                        
                        <xsl:choose>
                            <xsl:when test="fullDay = 'true' and startDate and endDate and not(datetime:sameDate(startDate, endDate))">
                                <!-- 26 octobre au 28 octobre -->
                                <xsl:call-template name="date-range"/>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:call-template name="time-range"/>
                            </xsl:otherwise>
                        </xsl:choose>
                    </div>
                </div>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="event-start-day">
        <div class="ametys-event-section-side ametys-event-date">
			<div class="ametys-event__day"><i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="dd"><xsl:value-of select="startDate"/></i18n:date></div>
			<div class="ametys-event__month"><i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="MMM"><xsl:value-of select="startDate"/></i18n:date></div>
		</div>
    </xsl:template>
    
    <xsl:template name="event-title">
        <div class="ametys-event-section-content">
            <div class="ametys-event__title"><xsl:value-of select="title"/></div>
        </div>
    </xsl:template>
    
    <xsl:template name="event-location">
        <xsl:if test="location">
            <div class="ametys-event-section">
                <div class="ametys-event-section-side"></div>
                <div class="ametys-event-section-content">
                    <div class="ametys-event__location">
                        <i class="fas fa-map-marker-alt"></i>
                        <xsl:text> </xsl:text><xsl:value-of select="location"/>
                    </div>
                </div>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="calendar">
        <ul class="ametys-schedule-list">
            <xsl:for-each select="calendar">
                <li class="ametys-schedule-list__item ametys-schedule-list__item--event">
                    <span class="ametys-schedule-list__item-marker">
                        <xsl:if test="color != ''">
                            <xsl:attribute name="style">background-color: <xsl:value-of select="color"/></xsl:attribute>
                        </xsl:if>
                    </span>
                    <xsl:value-of select="title"/>
                </li>
            </xsl:for-each>
        </ul>
    </xsl:template>
    
    <xsl:template name="date-range">
        <xsl:param name="startDate" select="startDate"/>
        <xsl:param name="endDate" select="endDate"/>
        
        <!-- 26 octobre au 28 octobre -->
        <xsl:call-template name="format-date">
            <xsl:with-param name="date" select="$startDate"/>
        </xsl:call-template>
        <i18n:text i18n:key="SKIN_SERVICE_SEARCH_EVENTS_DATE_TO" i18n:catalogue="skin.{$skin}"/>
        <xsl:call-template name="format-date">
            <xsl:with-param name="date" select="$endDate"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="time-range">
		<xsl:param name="startDate" select="startDate"/>
		<xsl:param name="endDate" select="endDate"/>
      
        <xsl:choose>
            <xsl:when test="$startDate and not($endDate)">
                <!-- 9h30 -->
                <xsl:call-template name="format-time">
                    <xsl:with-param name="date" select="$startDate"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="$startDate and $endDate and datetime:sameDate($startDate, $endDate)">
                <!-- 9h30 à 12h00 -->
                <xsl:call-template name="format-time">
                    <xsl:with-param name="date" select="$startDate"/>
                </xsl:call-template>
                <i18n:text i18n:key="SKIN_SERVICE_SEARCH_EVENTS_DATETIME_TO" i18n:catalogue="skin.{$skin}"/>
                <xsl:call-template name="format-time">
                    <xsl:with-param name="date" select="$endDate"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="$startDate and $endDate">
                <!-- 9h30 le 26 cotobre à 12h00 le 28 octobre -->
                <xsl:call-template name="format-datetime">
                    <xsl:with-param name="date" select="$startDate"/>
                </xsl:call-template>
                <i18n:text i18n:key="SKIN_SERVICE_SEARCH_EVENTS_DATETIME_TO" i18n:catalogue="skin.{$skin}"/>
                <xsl:call-template name="format-datetime">
                    <xsl:with-param name="date" select="$endDate"/>
                </xsl:call-template>
            </xsl:when>
        </xsl:choose>
	</xsl:template>
    
    <xsl:template name="format-date">
        <xsl:param name="date"/>
        
        <i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="{$date-format}"><xsl:value-of select="$date"/></i18n:date>
    </xsl:template>
    
    <xsl:template name="format-datetime">
        <xsl:param name="date"/>
        
        <i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="{$datetime-format}"><xsl:value-of select="$date"/></i18n:date>
    </xsl:template>
    
    <xsl:template name="format-time">
        <xsl:param name="date"/>
        
        <i18n:time src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="{$time-format}"><xsl:value-of select="$date"/></i18n:time>
    </xsl:template>
    
</xsl:stylesheet>