<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2020 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:exslt="http://exslt.org/common"
                              xmlns:docbook="http://docbook.org/ns/docbook" 
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                              xmlns:user="org.ametys.plugins.userdirectory.transformation.xslt.UserXSLTHelper"
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              xmlns:xalan="http://xml.apache.org/xalan"
                              xmlns:uriutils="org.ametys.core.util.URIUtils"
                              exclude-result-prefixes="resolver ametys user xalan">

    <xsl:import href="plugin:workspaces://stylesheets/content/member/member-main.xsl"/> 

    <xsl:template name="common-content-head-css">
        <!-- Richtext Styles -->
        <link rel="stylesheet" href="{ametys:skinURL('richtext/scss/richtext.css')}" />
        <!-- End Richtext Styles -->
        
        <!-- profile styles -->
        <link rel="stylesheet" href="{ametys:skinURL('pages/profile/scss/main.css')}" />
        <link rel="stylesheet" href="{ametys:skinURL('pages/profile/scss/print.css')}" />
        <!-- END::profile styles -->
        
        <!-- Profile Page Styles -->
        <link rel="stylesheet" href="{ametys:skinURL('zones/profile/scss/main.css')}" />
        <link rel="stylesheet" href="{ametys:skinURL('zones/profile/scss/print.css')}" />
        <!-- END::Profile Page Styles -->
        
        <!-- timeline styles -->
        <link rel="stylesheet" href="{ametys:skinURL('zones/timeline/scss/main.css')}" />
        <link rel="stylesheet" href="{ametys:skinURL('zones/timeline/scss/print.css')}" />
        <!-- END::timeline styles -->
        
        <!-- sidebar styles -->
        <link rel="stylesheet" href="{ametys:skinURL('zones/sidebar/scss/main.css')}" />
        <link rel="stylesheet" href="{ametys:skinURL('zones/sidebar/scss/print.css')}" />
        <!-- End sidebar styles -->
        
        <!-- portlets styles -->
        <link rel="stylesheet" href="{ametys:skinURL('zones/portlets/scss/main.css')}" />
        <link rel="stylesheet" href="{ametys:skinURL('zones/portlets/scss/print.css')}" />
        <!-- END::portlets styles -->
        
        <!-- Projects -->
        <link rel="stylesheet" href="{ametys:skinURL('zones/side-suggestions/scss/main.css')}" />
        <link rel="stylesheet" href="{ametys:skinURL('zones/side-suggestions/scss/print.css')}" />
        <!-- END::Projects -->
        
        <link rel="stylesheet" href="{ametys:skinURL('templates/common/fonts/reso-icon-font/reso-icon-font.css')}" />
    </xsl:template>
    
    <xsl:template name="common-content-head-js">
        <script src="{ametys:skinURL('templates/common/js/popper.min.js')}"></script>
        <script src="{ametys:skinURL('main/bootstrap/dist/js/bootstrap.js')}"></script>
        <script src="{ametys:skinURL('templates/common/plugins/browser-polyfill.min.js')}"></script>
    </xsl:template>
    
    <xsl:template name="common-content-body-title"/>
    
    <xsl:template name="common-content-body-content">
        <!-- Profile's header -->
        <xsl:call-template name="profile-header"/>
        <!-- Profile's main content -->
        <xsl:call-template name="profile-content"/>
    </xsl:template>    
    
    <xsl:template name="profile-header">
        <xsl:variable name="bgImg"><xsl:call-template name="profile-header-bg-img"/></xsl:variable>
        <div class="rs-top-section pb-5 ametys-violet-banner" style="background-image: url({$bgImg});">
            <section class="rs-content-section">
                <div class="container">
                    <div class="row">
                        <xsl:call-template name="profile-info"/>
                        <xsl:call-template name="profile-contact"/>
                    </div>
                </div>
            </section>
        </div>
    </xsl:template> 
    
    <xsl:template name="profile-header-bg-img">
        <xsl:value-of select="ametys:skinURL('templates/common/img/bg-purple.jpg')"/>
    </xsl:template>
    
    <xsl:template name="profile-content">
        <section class="ametys-profile_gr pt-5 pb-8">
            <div class="container">
                <div class="row">
                    <div class="col-md ametys-profile_order1">
                        <div class="rs-body-section">
	                       <xsl:apply-templates select="/view/contentType/fieldset[@name='main']" mode="display"/>
                           
                           <xsl:call-template name="profile-projects"/> 
                        </div>
                    </div>
                    
                    <aside class="col-md-auto ametys-profile_order2">
                        <xsl:call-template name="related-members"/> 
                    </aside>
                </div>
            </div>
        </section>
    </xsl:template>
    
    <!-- Member's projects -->
    <xsl:template name="profile-projects">
        <xsl:if test="/view/projects/project">
            <h2 class="rs-profile-section-title">
                <span class="rs-editable__pseudo-text"><i18n:text i18n:key="SKIN_PROFILE_PROJECTS" i18n:catalogue="skin.{$skin}"/></span>
            </h2>
            
            <ul class="ametys-side-suggestions__list ametys-side-suggestions__profile">
                <xsl:apply-templates select="/view/projects/project"/>
            </ul>
        </xsl:if>
        
        <script type="text/javascript">
            let profileLogin = "<xsl:value-of select="/view/content/metadata/user/@login"/>";
            let profilePopulation = "<xsl:value-of select="/view/content/metadata/user/@populationId"/>";
            if (profileLogin != ametysUser.login || profilePopulation != ametysUser.populationId)
            {
                // disabled links
                $j('ul.ametys-side-suggestions__profile > li > a').css('pointer-events', 'none');
            }
        </script>
    </xsl:template>
    
    <xsl:template match="project">
        <li>
            <a href="{url}" class="ametys-side-suggestions__list_img d-block">
                <xsl:apply-templates select="." mode="illustration"/>
                <span class="ametys-tag ametys-tag--sm" style="color: #FFF; background-color: {category/@color}"><xsl:value-of select="category"/></span>
            </a>
            <a href="{url}" class="ametys-side-suggestions__list_title"><xsl:value-of select="title"/></a>
        </li>
    </xsl:template>
    
    <xsl:template match="project" mode="illustration">
        <xsl:variable name="imgUrl" select="resolver:resolveCroppedImage('site-parameter', concat(site/@name, ';illustration'), 103, 250, false(), true())"/>
        <xsl:choose>
            <xsl:when test="$imgUrl != ''"><img src="{$imgUrl}" alt="" /></xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="project-default-illustration"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="project-default-illustration">
        <img src="{ametys:skinURL('templates/common/img/bg2-small.png')}" alt="" />
    </xsl:template>
    
    <!-- Related members -->
    <xsl:template name="related-members">
        <xsl:if test="/view/related-members/content">
            <div class="ametys-sidebar-section d-none d-md-block">
                <h2 class="ametys-sidebar-section__title"><i18n:text i18n:key="SKIN_PROFILE_RELATED_MEMBERS" i18n:catalogue="skin.{$skin}"/></h2>
                
                <ul class="ametys-side-portlet__users">
                    <xsl:apply-templates select="/view/related-members/content" mode="related-member"/>
                </ul>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="content" mode="related-member">
        <li>
            <xsl:variable name="userPageId" select="user:getUserPage(@id, ametys:config('workspaces.member.userdirectory.site.name'))"/>
            
            <a class="ametys-portlet__top" href="{resolver:resolve('page', $userPageId)}">
                <div class="ametys-portlet__top_img">
                    <xsl:variable name="imgUrl" select="concat($site-uri-prefix, '/_plugins/user-directory/user/', attributes/user/@populationId, '/', uriutils:encodePath(attributes/user/@login), '/image_', 200, '?lang=', $lang)"/>
                    <img src="{$imgUrl}" alt="" class="mCS_img_loaded"/>
                </div>
                <div class="ametys-portlet__top_user">
                    <h3><xsl:value-of select="attributes/title"/></h3>
                    <xsl:if test="attributes/function">
                        <p><xsl:value-of select="attributes/function"/></p>
                    </xsl:if>
                    <xsl:if test="attributes/organisation-accronym">
                        <span class="ametys-tag ametys-tag--xs ametys-tag--gray"
                              data-toggle="tooltip"
                              data-placement="top"
                              title="{attributes/organisation}"><xsl:value-of select="attributes/organisation-accronym"/></span>
                    </xsl:if>
                </div>
            </a>
        </li>
    </xsl:template>
    
    <!-- Profile's info  -->
    <xsl:template name="profile-info">
        <div class="col-lg-7 mb-2 mb-lg-0">
            <div class="rs-main-profile">
                <!-- Illustration -->
            	<xsl:apply-templates select="/view/contentType//fieldset[@name='info']/metadata[@name='illustration']" mode="display"/>
                
                <div class="rs-main-profile-info">
                    <xsl:apply-templates select="/view/contentType//fieldset[@name='info']/metadata[@name!='illustration']" mode="display-info"/>
                </div>                    
            </div>
        </div>
    </xsl:template>
    
    <!-- Profile's info  -->
    <xsl:template name="profile-contact">
        <div class="col-lg-5 ml-xl-auto">
        	<ul class="rs-contacts-list list-unstyled mb-0">
            	<xsl:apply-templates select="/view/contentType//fieldset[@name='contact']" mode="display-contact"/>
            </ul>
        </div>
    </xsl:template>
    
    <xsl:template match="fieldset[@role='fieldset']" mode="display">
        <xsl:apply-templates select="fieldset|metadata" mode="display"/>
    </xsl:template>
    
    <xsl:template match="fieldset[@role='fieldset']" mode="display-info">
        <xsl:apply-templates select="fieldset|metadata" mode="display-info"/>
    </xsl:template>
    
    <xsl:template match="fieldset[@role='fieldset']" mode="display-contact">
        <xsl:apply-templates select="fieldset|metadata" mode="display-contact"/>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'illustration']" mode="display">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
        <div class="rs-main-profile__userpic">
	    	<xsl:choose>
	    		<xsl:when test="$value/image">
		    		<xsl:call-template name="common-content-body-image">
			            <xsl:with-param name="image" select="$value/image"/>
			            <xsl:with-param name="alternative" select="$value/alt-text"/>
			            <xsl:with-param name="maxWidth" select="'118'"/>
			            <xsl:with-param name="maxHeight" select="'118'"/>
			            <xsl:with-param name="class" select="'user-image'"/>
			            <xsl:with-param name="type" select="'cropped'"/>
			        </xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<div class="content-illustration frontedition-placeholder" data-ametys-metadata="{/view/content/@id};illustration/image" data-ametys-widget-params="{{ &quot;shape&quot;: &quot;circle&quot; }}">
	    				<img class="user-image">
	    					<xsl:attribute name="src">
								<xsl:call-template name="user-image-default-url"/>
							</xsl:attribute>
						</img>
					</div>
				</xsl:otherwise>
			</xsl:choose>
		</div>
    </xsl:template>
    
    <xsl:template name="user-image-default-url">
        <xsl:variable name="user" select="/view/content/metadata/user"/>
        <xsl:value-of select="concat($site-uri-prefix, '/_plugins/user-directory/user/', $user/@populationId, '/', uriutils:encodePath($user/@login), '/image_118?lang=', $lang)"/>
    </xsl:template>
    
    <xsl:template name="common-content-body-image">
        <xsl:param name="image"/>
        <xsl:param name="alternative"/>
        <xsl:param name="maxWidth"/>
        <xsl:param name="maxHeight"/>
        <xsl:param name="class"/>
        <xsl:param name="type"/>
        
        <xsl:if test="$image">
            <div class="content-illustration" data-ametys-metadata="{/view/content/@id};illustration/image" data-ametys-widget-params="{{ &quot;shape&quot;: &quot;circle&quot; }}">
                <img alt="{$alternative}" class="{$class}">
                    <xsl:attribute name="src">
	                    <xsl:choose>
	                        <xsl:when test="$type = 'cropped'"><xsl:value-of select="resolver:resolveCroppedImage($image/@type, $image/@uri, $maxHeight, $maxWidth)"/></xsl:when>
	                        <xsl:otherwise><xsl:value-of select="resolver:resolveBoundedImage($image/@type, $image/@uri, $maxHeight, $maxWidth)"/></xsl:otherwise>
	                    </xsl:choose>
                    </xsl:attribute>
                </img>
            </div>
        </xsl:if>        
    </xsl:template>
    
    <!-- Do not display linked orgunits -->
    <xsl:template match="metadata[@type = 'content' and @name = 'orgunits']" mode="display-info" priority="100"/>
    
    <xsl:template match="metadata[@type = 'content']" mode="display-info">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
        <xsl:variable name="definition" select="."/>
        
        <div><xsl:value-of select="@name"></xsl:value-of>
            <xsl:attribute name="class">
                <xsl:apply-templates select="$definition" mode="display-info-class">
                     <xsl:with-param name="value" select="$value"/>
                </xsl:apply-templates>
            </xsl:attribute>
                
            <xsl:choose>
                <xsl:when test="$value">
                    <span class="rs-editable__pseudo-text" data-ametys-metadata="{concat(/view/content/@id, ';', $name)}">
                        <xsl:apply-templates select="$definition" mode="display-info-value">
                             <xsl:with-param name="value" select="$value"/>
                        </xsl:apply-templates>
                    </span>
                </xsl:when> 
                <xsl:otherwise>
                    <div style="display: none" class="rs-editable__pseudo-text front-edition-placeholder" data-ametys-metadata="{concat(/view/content/@id, ';', $name)}">
                        <xsl:apply-templates select="$definition" mode="placeholder"/>
                    </div>
                </xsl:otherwise>
            </xsl:choose>
        </div>
    </xsl:template>
    
    <xsl:template match="metadata[@type = 'string']" mode="display-info">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
        <xsl:variable name="definition" select="."/>
        
        <div>
        	<xsl:attribute name="class">
	    		<xsl:apply-templates select="$definition" mode="display-info-class">
	                 <xsl:with-param name="value" select="$value"/>
	            </xsl:apply-templates>
	        </xsl:attribute>
                
	        <xsl:choose>
		        <xsl:when test="$value">
		        	<span class="rs-editable__pseudo-text" data-ametys-metadata="{concat(/view/content/@id, ';', $name)}">
		        		<xsl:apply-templates select="$definition" mode="value">
		                     <xsl:with-param name="value" select="$value"/>
		                </xsl:apply-templates>
					</span>
				</xsl:when>	
				<xsl:otherwise>
					<div style="display: none" class="rs-editable__pseudo-text front-edition-placeholder" data-ametys-metadata="{concat(/view/content/@id, ';', $name)}">
						<xsl:apply-templates select="$definition" mode="placeholder"/>
					</div>
				</xsl:otherwise>
			</xsl:choose>
		</div>
    </xsl:template>
    
    <xsl:template match="metadata[@name='title']" mode="display-info">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
        <h2 class="rs-main-profile__title"><xsl:value-of select="$value"/></h2>
    </xsl:template>
    
    <xsl:template match="metadata[@name='firstname']" mode="display-info"/>
    <xsl:template match="metadata[@name='lastname']" mode="display-info"/>
    <xsl:template match="metadata[@name='user']" mode="display-info"/>
    <xsl:template match="metadata[@name='uniqueId']" mode="display-info" /> 
    
    <xsl:template match="metadata[@name = 'email']" mode="display-contact" priority="100">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
        <li class="rs-contacts-list__item rs-editable">
            <xsl:variable name="definition" select="."/>
            
            <span class="rs-editable__pseudo-text">            
                <xsl:apply-templates select="$definition" mode="contact-icon">
                    <xsl:with-param name="value" select="$value"/>
                </xsl:apply-templates>
                <a>
                    <xsl:apply-templates select="$definition" mode="href-attribute">
                        <xsl:with-param name="value" select="$value"/>
                    </xsl:apply-templates>
                
                    <xsl:apply-templates select="$definition" mode="value">
                         <xsl:with-param name="value" select="$value"/>
                    </xsl:apply-templates>
                </a>
            </span>
        </li>
    </xsl:template>
    
    <xsl:template match="metadata[@type = 'content']" mode="display-contact">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
        <li class="rs-contacts-list__item rs-editable">
            <xsl:variable name="definition" select="."/>
    
            <xsl:choose>
                <xsl:when test="$value">
                    <span class="rs-editable__pseudo-text" data-ametys-metadata="{concat(/view/content/@id, ';', $name)}">
                        <xsl:apply-templates select="$definition" mode="contact-icon">
                            <xsl:with-param name="value" select="$value"/>
                        </xsl:apply-templates>
                        
                        <xsl:apply-templates select="$definition" mode="display-info-value">
                             <xsl:with-param name="value" select="$value"/>
                        </xsl:apply-templates>
                    </span>
                </xsl:when> 
                <xsl:otherwise>
                    <div style="display: none" data-ametys-metadata="{concat(/view/content/@id, ';', $name)}" data-front-edition-button-text="Ajouter un lien twitter, facebook ou autre">
                        <xsl:apply-templates select="$definition" mode="contact-cls">
                            <xsl:with-param name="commonCls" select="'rs-editable__pseudo-text front-edition-placeholder'"/>
                        </xsl:apply-templates>
                        <xsl:apply-templates select="$definition" mode="placeholder"/>
                    </div>
                </xsl:otherwise>
            </xsl:choose>
        </li>
    </xsl:template>
    
    <xsl:template match="metadata[@type = 'string']" mode="display-contact">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
        <li class="rs-contacts-list__item rs-editable">
            <xsl:variable name="definition" select="."/>
    
            <xsl:choose>
                <xsl:when test="$value">
                    <span class="rs-editable__pseudo-text" data-ametys-metadata="{concat(/view/content/@id, ';', $name)}">
                        
                        <xsl:apply-templates select="$definition" mode="contact-icon">
                            <xsl:with-param name="value" select="$value"/>
                        </xsl:apply-templates>
                        <a>
                            <xsl:apply-templates select="$definition" mode="href-attribute">
                                <xsl:with-param name="value" select="$value"/>
                            </xsl:apply-templates>
                        
                            <xsl:apply-templates select="$definition" mode="value">
                                 <xsl:with-param name="value" select="$value"/>
                            </xsl:apply-templates>
                        </a>
                    </span>
                </xsl:when> 
                <xsl:otherwise>
                    <div style="display: none" data-ametys-metadata="{concat(/view/content/@id, ';', $name)}" data-front-edition-button-text="Ajouter un lien twitter, facebook ou autre">
                        <xsl:apply-templates select="$definition" mode="contact-cls">
                            <xsl:with-param name="commonCls" select="'rs-editable__pseudo-text front-edition-placeholder'"/>
                        </xsl:apply-templates>
                        <xsl:apply-templates select="$definition" mode="placeholder"/>
                    </div>
                </xsl:otherwise>
            </xsl:choose>
        </li>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'mission']" mode="display-info-class">
    	<xsl:text>rs-main-profile-data and-description rs-editable</xsl:text>
    </xsl:template>
    
    <xsl:template match="metadata[@type = 'content']" mode="display-info-class">
        <xsl:text>rs-main-profile-data and-description rs-editable</xsl:text>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'organisation-accronym']" mode="display-info-class">
        <xsl:param name="value"/>
        <xsl:choose>
            <xsl:when test="$value">
                <xsl:text>rs-main-profile-data and-tag rs-editable</xsl:text>
            </xsl:when>
            <xsl:otherwise>
                <xsl:text>rs-main-profile-data rs-editable</xsl:text>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="metadata" mode="display-info-class">
    	<xsl:text>rs-main-profile-data and-position rs-editable</xsl:text>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'phone']" mode="contact-icon">
    	<i class="reso-icon-phone rs-icon-smd rs-contacts-list__item-icon"/>
    </xsl:template>
    
     <xsl:template match="metadata[@name = 'mobile']" mode="contact-icon">
    	<i class="reso-icon-phone rs-icon-smd rs-contacts-list__item-icon"/>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'email']" mode="contact-icon">
    	<i class="reso-icon-envelope rs-icon-smd rs-contacts-list__item-icon"/>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'social-link']|metadata[@name = 'other-link']" mode="contact-icon">
    	<xsl:param name="value"/>
    	
    	<i>
   			<xsl:attribute name="class">
		   		<xsl:choose>
		   			<xsl:when test="contains($value, 'linkedin')">reso-icon-linkedin</xsl:when>
		   			<xsl:when test="contains($value, 'facebook')">reso-icon-facebook</xsl:when>
		   			<xsl:when test="contains($value, 'twitter')">reso-icon-twitter</xsl:when>
		   			<xsl:when test="contains($value, 'youtube')">reso-icon-youtube</xsl:when>
		   			<xsl:otherwise>reso-icon-link</xsl:otherwise>
		   		</xsl:choose>
		   		<xsl:text> rs-contacts-list__item-icon</xsl:text>
		   	</xsl:attribute>
   		</i>
  	</xsl:template>
    
    <xsl:template match="metadata" mode="contact-icon"/>
    
   	<xsl:template match="metadata[@name = 'phone']|metadata[@name = 'mobile']" mode="href-attribute">
   		<xsl:param name="value"/>
   		
    	<xsl:attribute name="href">
    		<xsl:text>tel:</xsl:text><xsl:value-of select="$value"/>
    	</xsl:attribute>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'email']" mode="href-attribute">
    	<xsl:param name="value"/>
   		
    	<xsl:attribute name="href">
    		<xsl:text>mailto:</xsl:text><xsl:value-of select="$value"/>
    	</xsl:attribute>
    </xsl:template>
    
    <xsl:template match="metadata[@name = 'social-link']|metadata[@name = 'other-link']" mode="href-attribute">
    	<xsl:param name="value"/>
    	
    	<xsl:attribute name="href"><xsl:value-of select="$value"/></xsl:attribute>
    </xsl:template>
    
    <xsl:template match="metadata" mode="href-attribute"/>
    
    <xsl:template match="metadata[@type='rich-text']" mode="display">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
		<xsl:variable name="definition" select="."/>

        <div class="ametys-content-section rs-editable rs-editable--dark rs-editable--negative-top front-edition-placeholder-wrapper" data-ametys-attribute="{$name}">
            <xsl:if test="not($value/docbook:article)">
                <xsl:attribute name="style">display:none</xsl:attribute>
                <xsl:attribute name="class">ametys-content-section rs-editable rs-editable--dark rs-editable--negative-top ametys-content-section-empty</xsl:attribute>
            </xsl:if>
            
            <xsl:apply-templates select="$definition" mode="label"/>
            		
            <xsl:choose>
    	        <xsl:when test="$value/docbook:article">
                    <div class="ametys-richtext" data-ametys-metadata="{concat(/view/content/@id, ';', $name)}">
                        <xsl:apply-templates select="$definition" mode="value">
                            <xsl:with-param name="value" select="$value"/>
                        </xsl:apply-templates>
                    </div>
    	        </xsl:when>
    	        <xsl:otherwise>
                    <div class="ametys-richtext front-edition-placeholder" data-ametys-metadata="{concat(/view/content/@id, ';', $name)}" style="display: none; height: 100px; text-align: center">
                        <xsl:apply-templates select="$definition" mode="placeholder"/>
                    </div>
    	        </xsl:otherwise>
            </xsl:choose>
        </div>
    </xsl:template>
    
    <xsl:template match="metadata[@type = 'content']" mode="display">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
		<xsl:variable name="definition" select="."/>

        <div class="ametys-content-section rs-editable rs-editable--dark rs-editable--negative-top">
            <xsl:if test="not($value)">
                <xsl:attribute name="style">display:none</xsl:attribute>
                <xsl:attribute name="class">ametys-content-section rs-editable rs-editable--dark rs-editable--negative-top ametys-content-section-empty</xsl:attribute>
            </xsl:if>
            
            <xsl:apply-templates select="$definition" mode="label"/>
    		
            <xsl:choose>
    	        <xsl:when test="$value">
    	        	<div class="ametys__linkas" data-ametys-metadata="{concat(/view/content/@id, ';', $name)}">
    	        		<xsl:apply-templates select="$definition" mode="value">
    	                     <xsl:with-param name="value" select="$value"/>
    	                </xsl:apply-templates>
    				</div>
    			</xsl:when>	
    			<xsl:otherwise>
                    <div style="display: none" class="rs-editable__pseudo-text front-edition-placeholder" data-ametys-metadata="{concat(/view/content/@id, ';', $name)}" >
    					<xsl:apply-templates select="$definition" mode="placeholder"/>
    				</div>
    			</xsl:otherwise>
    		</xsl:choose>
        </div>
    </xsl:template>
    
    <xsl:template match="metadata[@type='string']" mode="display">
        <xsl:param name="name" select="@name"/>
        <xsl:param name="value" select="/view/content/metadata/*[local-name() = $name]"/>
        
        <xsl:variable name="definition" select="."/>

        <div class="ametys-content-section rs-editable rs-editable--dark rs-editable--negative-top">
            <xsl:if test="not($value)">
                <xsl:attribute name="style">display:none</xsl:attribute>
                <xsl:attribute name="class">ametys-content-section rs-editable rs-editable--dark rs-editable--negative-top ametys-content-section-empty</xsl:attribute>
            </xsl:if>
            
            <xsl:apply-templates select="$definition" mode="label"/>
                    
            <xsl:choose>
                <xsl:when test="$value">
                    <div class="ametys-richtext" data-ametys-metadata="{concat(/view/content/@id, ';', $name)}">
                        <xsl:apply-templates select="$definition" mode="value">
                            <xsl:with-param name="value" select="$value"/>
                        </xsl:apply-templates>
                    </div>
                </xsl:when>
                <xsl:otherwise>
                    <div class="rs-editable__pseudo-text front-edition-placeholder" data-ametys-metadata="{concat(/view/content/@id, ';', $name)}" style="display: none; height: 100px; text-align: center">
                        <xsl:apply-templates select="$definition" mode="placeholder"/>
                    </div>
                </xsl:otherwise>
            </xsl:choose>
        </div>
    </xsl:template>
    
    <xsl:template match="metadata" mode="label">
        <div class="rs-profile-section-title rs-editable">
            <span class="rs-editable__pseudo-text">
                <xsl:value-of select="label"/>
            </span>
        </div>
    </xsl:template>
    
    <xsl:template match="metadata[@type='content']" mode="display-info-value">
        <xsl:param name="value"/>
        <xsl:param name="definition" select="."/>
        
        <xsl:for-each select="$value">
            <xsl:value-of select="@title"/>
            <xsl:if test="position() != last()">, </xsl:if>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template match="metadata[@type='content']" mode="value">
    	<xsl:param name="value"/>
    	<xsl:param name="definition" select="."/>
    	
    	<xsl:for-each select="$value">
    		<a href="#">
	            <xsl:value-of select="@title"/>
	        </a>
        </xsl:for-each>
    </xsl:template>
    
    <xsl:template match="metadata[@name='phone']|metadata[@name='mobile']" mode="contact-cls">
        <xsl:param name="commonCls"/>
        <xsl:attribute name="class"><xsl:value-of select="$commonCls"/> rs-editable__pseudo-text--phone</xsl:attribute>
    </xsl:template>
    
    <xsl:template match="metadata[@name='social-link']|metadata[@name='other-link']" mode="contact-cls">
        <xsl:param name="commonCls"/>
        <xsl:attribute name="class"><xsl:value-of select="$commonCls"/> rs-editable__pseudo-text--link</xsl:attribute>
    </xsl:template>
    
    <xsl:template match="metadata[@name='email']" mode="contact-cls">
        <xsl:param name="commonCls"/>
        <xsl:attribute name="class"><xsl:value-of select="$commonCls"/> rs-editable__pseudo-text--email</xsl:attribute>
    </xsl:template>
    
    <xsl:template match="metadata" mode="contact-cls">
        <xsl:param name="commonCls"/>
        <xsl:attribute name="class"><xsl:value-of select="$commonCls"/> rs-editable__pseudo-text--othercontact</xsl:attribute>
    </xsl:template>
    
    <!-- Placeholders -->
    <xsl:template match="metadata[@type='rich-text']" mode="placeholder">
        <xsl:attribute name="data-front-edition-button-text"><xsl:value-of select="concat('skin.', $skin, ':SKIN_PROFILE_FO_DEFAULT_RICHTEXT_PLACEHOLDER')"/></xsl:attribute>
        <xsl:attribute name="i18n:attr">data-front-edition-button-text</xsl:attribute>
    </xsl:template>
    
    <xsl:template match="metadata[@name='professional-history']" mode="placeholder">
        <xsl:attribute name="data-front-edition-button-text"><xsl:value-of select="concat('skin.', $skin, ':SKIN_PROFILE_FO_ADD_PROFESSIONAL_HISTORY')"/></xsl:attribute>
        <xsl:attribute name="i18n:attr">data-front-edition-button-text</xsl:attribute>
    </xsl:template>
    
    <xsl:template match="metadata[@name='hobbies']" mode="placeholder">
        <xsl:attribute name="data-front-edition-button-text"><xsl:value-of select="concat('skin.', $skin, ':SKIN_PROFILE_FO_ADD_HOBBIES')"/></xsl:attribute>
        <xsl:attribute name="i18n:attr">data-front-edition-button-text</xsl:attribute>
    </xsl:template>
    
    <xsl:template match="metadata[@name='keywords']" mode="placeholder">
        <xsl:attribute name="data-front-edition-button-text"><xsl:value-of select="concat('skin.', $skin, ':SKIN_PROFILE_FO_ADD_KEYWORDS')"/></xsl:attribute>
        <xsl:attribute name="i18n:attr">data-front-edition-button-text</xsl:attribute>
    </xsl:template>
    
    <xsl:template match="metadata[@name='skills']" mode="placeholder">
        <xsl:attribute name="data-front-edition-button-text"><xsl:value-of select="concat('skin.', $skin, ':SKIN_PROFILE_FO_ADD_SKILLS')"/></xsl:attribute>
        <xsl:attribute name="i18n:attr">data-front-edition-button-text</xsl:attribute>
    </xsl:template>
    
    <xsl:template match="metadata[@name='function']" mode="placeholder">
        <xsl:attribute name="data-front-edition-button-text"><xsl:value-of select="concat('skin.', $skin, ':SKIN_PROFILE_FO_ADD_FUNCTION')"/></xsl:attribute>
        <xsl:attribute name="i18n:attr">data-front-edition-button-text</xsl:attribute>
    </xsl:template>
    
    <xsl:template match="metadata[@name='organisation']" mode="placeholder">
        <xsl:attribute name="data-front-edition-button-text"><xsl:value-of select="concat('skin.', $skin, ':SKIN_PROFILE_FO_ADD_ORGANISATION')"/></xsl:attribute>
        <xsl:attribute name="i18n:attr">data-front-edition-button-text</xsl:attribute>
    </xsl:template>
    
    <xsl:template match="metadata[@name='organisation-accronym']" mode="placeholder">
        <xsl:attribute name="data-front-edition-button-text"><xsl:value-of select="concat('skin.', $skin, ':SKIN_PROFILE_FO_ADD_ORGANISATION_ACCRONYM')"/></xsl:attribute>
        <xsl:attribute name="i18n:attr">data-front-edition-button-text</xsl:attribute>
    </xsl:template>
    
    <xsl:template match="metadata[@name='mission']" mode="placeholder">
        <xsl:attribute name="data-front-edition-button-text"><xsl:value-of select="concat('skin.', $skin, ':SKIN_PROFILE_FO_ADD_MISSION')"/></xsl:attribute>
        <xsl:attribute name="i18n:attr">data-front-edition-button-text</xsl:attribute>
    </xsl:template>
    
    <xsl:template match="metadata[@name='phone']|metadata[@name='mobile']" mode="placeholder">
        <xsl:attribute name="data-front-edition-button-text"><xsl:value-of select="concat('skin.', $skin, ':SKIN_PROFILE_FO_ADD_PHONE')"/></xsl:attribute>
        <xsl:attribute name="i18n:attr">data-front-edition-button-text</xsl:attribute>
    </xsl:template>
    
    <xsl:template match="metadata[@name='social-link']|metadata[@name='other-link']" mode="placeholder">
        <xsl:attribute name="data-front-edition-button-text"><xsl:value-of select="concat('skin.', $skin, ':SKIN_PROFILE_FO_ADD_LINK')"/></xsl:attribute>
        <xsl:attribute name="i18n:attr">data-front-edition-button-text</xsl:attribute>
    </xsl:template>
    
    <xsl:template match="metadata" mode="placeholder">
        <xsl:attribute name="data-front-edition-button-text"><xsl:value-of select="concat('skin.', $skin, ':SKIN_PROFILE_FO_DEFAULT_PLACEHOLDER')"/></xsl:attribute>
        <xsl:attribute name="i18n:attr">data-front-edition-button-text</xsl:attribute>
    </xsl:template>
    <!-- End Placeholders -->
</xsl:stylesheet>