<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2020 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
		xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
		xmlns:xalan="http://xml.apache.org/xalan"
		xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
		xmlns:date="http://exslt.org/dates-and-times" extension-element-prefixes="date"
		exclude-result-prefixes="sitemap ametys resolver">

	<xsl:import href="skin://stylesheets/main.xsl" />
    <xsl:import href="plugin:front-edition://stylesheets/front-edition.xsl"/>

    <xsl:template name="additionnal-css">
        <!-- Profile Page Styles -->
        <link rel="stylesheet" href="{ametys:skinURL('pages/profile/scss/main.css')}" />
        <link rel="stylesheet" href="{ametys:skinURL('pages/profile/scss/print.css')}" />
        <!-- END::Profile Page Styles -->
    </xsl:template>
    
    <xsl:template name="additionnal-script">
        <!-- FO edition -->
        <xsl:call-template name="ametys-front-edition-head">
            <xsl:with-param name="start">load</xsl:with-param>
            <xsl:with-param name="editActionId">42</xsl:with-param>
            <xsl:with-param name="insertAttachmentActionId">42</xsl:with-param>
            <xsl:with-param name="edition-mode-only" select="false()"/>
            <xsl:with-param name="start-callback">function() { $j('.front-edition-placeholder .ametys-front-edition-button').closest('.front-edition-placeholder').show(); $j('.ametys-content-section-empty .ametys-front-edition-button').closest('.ametys-content-section-empty').show();}</xsl:with-param>
            <xsl:with-param name="theme" select="$extjs-theme"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="body">
        <body class="bg-light-grey">
            <xsl:call-template name="mobile-media-js"/>
            
            <xsl:call-template name="header"/>
            
            <main>
                <zone name="default" level="1" />
            </main>
            
            <xsl:call-template name="footer"/>
            
            <xsl:call-template name="scroll-top"/>
            
            <!-- Recent activities -->
            <xsl:call-template name="recent-activities"/>
            
            <xsl:call-template name="mobile-header"/>
        </body>
    </xsl:template>
    
</xsl:stylesheet>