/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

AmetysFront.Event.listen("copyPrettyPrint", function(data) { copyPrettyPrint(e.detail.codeId); }, false);

AmetysFront.Event.listen("firePrettyPrint", PR.prettyPrint, false);

function copyPrettyPrint(codeId)
{
    var content = $j('#' + codeId + '-for-copy').text();
    content = content.replace(/\u00a0/g, " ");
    $j(document.body).append('<textarea id="textarea-' + codeId + '" style="position:absolute; top: -10000px;"/>');
    $j('#textarea-' + codeId ).text(content).select();
    document.execCommand("copy");
    $j('#textarea-' + codeId).remove();
}

function copyPrettyPrintButton(codeId)
{
    try
    {
        console.log(codeId)
        copyPrettyPrint(codeId);
        
        var copyButton = $j('#copy-' + codeId);
        copyButton.addClass("copy-success");
        copyButton.children("i").addClass("fa-check").removeClass("fa-clone");
        
        setTimeout(function () { copyButton.removeClass("copy-success"); copyButton.children("i").addClass("fa-clone").removeClass("fa-check") }, 1000);
    } 
    catch(e) 
    {
        if($("#alert-" + codeId).length == 0) 
        {
            var divHTML = '<div role="alert" class="code-alert alert alert-danger alert-dismissible show" id="alert-' + codeId + '">'
                        +     '<h4 class="h5">'
                        +         '<i class="fa fa-minus-circle"><span style="display: none">&nbsp;</span></i>' + "{{i18n skin.workspace-project:SKIN_CONTENT_COPY_CODE_ERROR_TITLE}}" + '</h4>'
                        +     "{{i18n skin.workspace-project:SKIN_CONTENT_COPY_CODE_ERROR}}"
                        + '</div>';
            $(divHTML).insertBefore($j("#" + codeId).parent())
            setTimeout(function () { 
                $j('#alert-' + codeId).removeClass("show").addClass("hide"); 
                
                // There is a CSS transition on class change, so we have to add a 500 ms delay before removing the element
                setTimeout(function () { $j('#alert-' + codeId).remove() }, 500);
            }, 3000);
        }
    }
}

function openPrettyPrintDialog(codeId) 
{
    AmetysFront.Event.fire("openPrettyPrintDialog", { id: codeId}); 
}
