<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2020 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:exslt="http://exslt.org/common"
        xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
        xmlns:user="org.ametys.plugins.userdirectory.transformation.xslt.UserXSLTHelper"
        xmlns:project="org.ametys.plugins.workspaces.project.helper.ProjectXsltHelper"
        exclude-result-prefixes="ametys resolver exslt sitemap project">
    
    <xsl:import href="plugin:web://pages/services/search/search-default.xsl"/>  
    <xsl:import href="plugin:front-edition://stylesheets/front-edition.xsl"/>
    
    <xsl:import href="skin://stylesheets/variables.xsl"/>
    
    <xsl:template name="common-service-head-css">
        <link rel="stylesheet" type="text/css" href="{ametys:skinURL('zones/news/scss/main.css')}"/>  
        <link rel="stylesheet" type="text/css" href="{ametys:skinURL('zones/news/scss/print.css')}"/> 
        
    	<link rel="stylesheet" type="text/css" href="{ametys:skinURL('zones/edit-tools/scss/main.css')}" />
		<link rel="stylesheet" type="text/css" href="{ametys:skinURL('zones/edit-tools/scss/print.css')}" />
        
        <link rel="stylesheet" href="{ametys:skinURL('templates/common/plugins/OwlCarousel2-2.3.4/dist/assets/owl.carousel.css')}" />
    </xsl:template> 
    
    <xsl:template name="common-service-head-js">
        <script src="{ametys:skinURL('templates/common/plugins/OwlCarousel2-2.3.4/dist/owl.carousel.js')}"></script>
		<script type="text/javascript">
			$j(document).ready(function(){
				$j(".ametys-owl-slider").owlCarousel({
					loop: true,
					dots: true,
					nav: true,
					items: 1,
					autoplay: true
				});
                
                // Truncate text
                function truncate(el, limitLength) 
                {
                    var ellipse = ' ...';
                    var textInner = el.text();

                    if (textInner.length > limitLength) {
                        el.text(textInner.slice(0, limitLength) + ellipse);
                        return;
                    }
                };
                
                $j('.ametys-slider-full-news .ametys-single-full-news-content__title').each(function() {
                    truncate($j(this), 50);
                });
                
                $j('.ametys-slider-full-news .ametys-single-full-news-content__text').each(function() {
                    truncate($j(this), 80);
                });
                
			});
		</script>		
        
        <!-- FO edition -->
        <xsl:call-template name="ametys-front-edition-head">
            <xsl:with-param name="start">load</xsl:with-param>
            <xsl:with-param name="editActionId">201</xsl:with-param>
            <xsl:with-param name="insertAttachmentActionId">201</xsl:with-param>
            <xsl:with-param name="enableSimpleMode">true</xsl:with-param>
            <xsl:with-param name="edition-mode-only" select="false()"/>
            <xsl:with-param name="theme" select="$extjs-theme"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-title"/>
    
    <xsl:template name="common-service-body-nonempty-content-content">
        <xsl:choose>
            <xsl:when test="count(/search/hits/hit) != 0">
                <div class="ametys-slider-full-news ametys-mb-25">
                    <xsl:call-template name="hits"/>
                </div>
            </xsl:when>
            <xsl:otherwise>
                <xsl:variable name="rootPageId" select="project:getNewsRootPageId()"/>
                
                <xsl:if test="$rootPageId">
                    <xsl:call-template name="ametys-front-edition-insert-create-page-button">
                        <xsl:with-param name="page-id" select="$rootPageId"/>
                        <xsl:with-param name="button-text"><span><i18n:text i18n:key="SKIN_FO_ADD_NEWS_BTN_TEXT" i18n:catalogue="skin.{$skin}"/></span></xsl:with-param>
                        <xsl:with-param name="title-i18n">skin.<xsl:value-of select="$skin"/>:SKIN_FO_ADD_NEWS_BTN_TEXT</xsl:with-param>
                        <xsl:with-param name="edition-mode-only" select="false()"/>
                        <xsl:with-param name="class">ametys-slider-full-news__edit</xsl:with-param>
                        <xsl:with-param name="callback">function(page)
                            {
                                var path = AmetysFrontEdition.CONTEXT_PATH + "/" + AmetysFrontEdition.LANG + "/" + page.getPath() + ".html";
                                window.location.href = path;
                            }
                        </xsl:with-param>
                        <xsl:with-param name="config">{
                            "title": "<xsl:value-of select="ametys:escapeJS(ametys:translate(concat('skin.', $skin, ':SKIN_FO_ADD_NEWS_DIALOG_TITLE'), $lang))"/>",
                            "force": true,
                            "workflowInitActionId": "14", 
                            "show-card-content" : false, 
                            "show-card-type" : false,  
                            "show-card-tags" : true,
                            "show-card-content-properties" : false,
                            "pagecontent-card-tags-categories-filter": ["provider_org.ametys.plugins.workspaces.tags.ProjectCMSTagProvider"],
                            "pagecontent-card-tags-categories-filter-only-subcategories": false,
                           "default-pagetype" : "template",
                            "default-template" : "page",
                            "default-zone" : "default",
                            "default-pagecontent-type" : "contenttype",
                            "default-contenttype" :  "org.ametys.plugins.workspaces.Content.projectNews",
                            "right-contenttype": "Plugin_Workspaces_Right_ProjectNews_Create",
                            "default-page-title" : "<xsl:value-of select="ametys:escapeJS(ametys:translate(concat('skin.', $skin, ':SKIN_FO_ADD_NEWS_DEFAULT_TITLE'), $lang))"/>",
                            "default-contenttype-label" : "<xsl:value-of select="ametys:escapeJS(ametys:translate(concat('skin.', $skin, ':SKIN_FO_ADD_NEWS_CONTENT_TYPE_LABEL'), $lang))"/>",
                            "pagecontent-service" : false}
                        </xsl:with-param>
                    </xsl:call-template>
                </xsl:if>
            </xsl:otherwise>
        </xsl:choose>
	</xsl:template>
	
	<xsl:template name="hits">
        <div class="ametys-slider-full-news-owl">
                
            <xsl:call-template name="carousel-title"/>

            <div class="ametys-single-full-news-content">
                <div data-ametys-search-role="hits">
                    <xsl:apply-templates select="/search/hits/hit"/>
                </div>
            </div>
        </div>
	</xsl:template>
    
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.ContentSaxer']" mode="class-attribute">
        <xsl:text/>owl-carousel ametys-owl-slider<xsl:text> </xsl:text>
    </xsl:template>
    
	<xsl:template name="carousel-title">
		<h2 class="ametys-single-full-news-content__title ametys-slider-full-news-owl__title-abs text-white">
			<xsl:value-of select="$header"/>
		</h2>
	</xsl:template>
	
    
</xsl:stylesheet>