<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2020 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:exslt="http://exslt.org/common"
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent" 
                              xmlns:project="org.ametys.plugins.workspaces.project.helper.ProjectXsltHelper"
                              xmlns:docbook="http://docbook.org/ns/docbook" 
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper">

    <xsl:import href="plugin:workspaces://stylesheets/content/alert/alert-abstract.xsl"/>
	<xsl:import href="skin://stylesheets/content/common-edit-tools.xsl"/>
    
    <xsl:template name="common-content-body">
		<xsl:variable name="page-id"><xsl:call-template name="get-page-id"/></xsl:variable>

        <div class="ametys-single-full-news" style="background-image: url({ametys:skinURL('templates/common/img/bell-semi-gray.png')}); background-size: 143px 145px;">
        
            <!-- FO actions -->
            <xsl:call-template name="fo-actions"/>
            
            <xsl:choose>
                <xsl:when test="metadata/content/docbook:article">
                    <a href="{resolver:resolve('page', $page-id, false)}" class="ametys-single-full-news-content">
                        <!-- Title -->
                        <xsl:call-template name="alert-title"/>
                        
                        <!-- Text -->
                        <xsl:call-template name="alert-text"/>
                    </a>
                </xsl:when>
                <xsl:otherwise>
                    <div class="ametys-single-full-news-content">
                        <!-- Title -->
                        <xsl:call-template name="alert-title"/>
                        
                        <!-- Text -->
                        <xsl:call-template name="alert-text"/>
                    </div>
                </xsl:otherwise>
            </xsl:choose>
        </div>
    </xsl:template>
    
    <xsl:template name="alert-title">
        <h2 class="ametys-single-full-news-content__title">
            <xsl:value-of select="metadata/title"/>
        </h2>
    </xsl:template>
    
    <xsl:template name="alert-text">
        <xsl:call-template name="common-content-body-simpletext">
            <xsl:with-param name="css-class-name">ametys-single-full-news-content__text</xsl:with-param>
            <xsl:with-param name="text" select="metadata/text" />
            <xsl:with-param name="maxDefaultTextSize" select="'200'" />
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="fo-actions">
        <xsl:variable name="page-id"><xsl:call-template name="get-page-id"/></xsl:variable>
        
        <!-- FO actions -->
        <xsl:call-template name="edit-tools">
            <xsl:with-param name="rootPageId" select="project:getAlertsRootPageId()"/>
            <xsl:with-param name="contentPageId" select="$page-id"/>
            <xsl:with-param name="addBtnI18nKey" select="concat('skin.', $skin, ':SKIN_FO_ADD_ALERT_BTN_TEXT')"/>
            <xsl:with-param name="addDialogI18nKey" select="concat('skin.', $skin, ':SKIN_FO_ADD_ALERT_DIALOG_TITLE')"/>
            <xsl:with-param name="contentTypeI18nKey" select="concat('skin.', $skin, ':SKIN_FO_ADD_ALERT_CONTENT_TYPE_LABEL')"/>
            <xsl:with-param name="defaultTitleI18nKey" select="concat('skin.', $skin, ':SKIN_FO_ADD_ALERT_DEFAULT_TITLE')"/>
            <xsl:with-param name="workflowInitActionId">15</xsl:with-param>
            <xsl:with-param name="contentTypeId">org.ametys.plugins.workspaces.Content.alert</xsl:with-param>
            <xsl:with-param name="editBtnI18nKey" select="concat('skin.', $skin, ':SKIN_FO_EDIT_ALERT_BTN_TEXT')"/>
            <xsl:with-param name="deleteBtnI18nKey" select="concat('skin.', $skin, ':SKIN_FO_DELETE_ALERT_BTN_TEXT')"/>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="add-content-button">
        <!--  Empty template to disable the creation of a new alert when a alert exists -->
    </xsl:template>
    
</xsl:stylesheet>