<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2020 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:docbook="http://docbook.org/ns/docbook" 
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper">

	<xsl:import href="plugin:workspaces://stylesheets/content/alert/alert-main.xsl"/>	
	
    <xsl:template name="common-content-head-css">
        <!-- Richtext Styles -->
        <link rel="stylesheet" href="{ametys:skinURL('richtext/scss/richtext.css')}" />
        <!-- End Richtext Styles -->
    </xsl:template>
    
    <xsl:template name="common-content-body-content">
    	<article class="ametys-main__inner--padding ametys-mb-30">
          <div class="ametys-main__inner__md--inside">
                <div class="container">
                    <div class="ametys-cms-content-side-spaces">
                        <xsl:call-template name="common-content-body-content-content"/>
                    </div>
                </div>                        
          </div>
        </article>
    </xsl:template>
    
    <xsl:template name="common-content-body-content-title">
        <h1 data-ametys-metadata="{@id};title"><xsl:value-of select="metadata/title"/></h1>
    </xsl:template>
    
    <xsl:template name="common-content-body-title"/>
    
    <xsl:template name="common-content-body-content-content">
    	<!-- Title -->
        <xsl:call-template name="common-content-body-content-title"/>
        
        <!-- Texte -->
        <xsl:call-template name="alert-text"/>
        
        <xsl:call-template name="alert-content"/>
        
    </xsl:template>
    
    <xsl:template name="alert-text">
        <xsl:choose>
            <xsl:when test="metadata/text">
                <div class="mb-5" data-ametys-metadata="{@id};text">
                    <xsl:call-template name="common-content-body-simpletext">
                        <xsl:with-param name="css-class-name">ametys-single-full-news-content__text</xsl:with-param>
                        <xsl:with-param name="text" select="metadata/text" />
                        <xsl:with-param name="maxDefaultTextSize" select="'200'" />
                    </xsl:call-template>
                </div>      
            </xsl:when>
            <xsl:otherwise>
                <div style="display: none" class="ametys-richtext front-edition-placeholder" data-ametys-metadata="{@id};text" i18n:attr="data-front-edition-button-text" data-front-edition-button-text="skin.{$skin}:SKIN_FO_ALERT_TEXT_PLACEHOLDER">
                </div>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="alert-content">
        <xsl:choose>
            <xsl:when test="metadata/content/docbook:article">
                <div class="ametys-richtext" data-ametys-metadata="{@id};content">
                    <xsl:call-template name="common-content-body-content-rich" />
                </div>
            </xsl:when>
            <xsl:otherwise>
                <div class="rs-editable">
                    <div class="ametys-richtext front-edition-placeholder"
                        data-ametys-metadata="{@id};content"
                        style="display: none; height: 500px; text-align: center"
                        i18n:attr="data-front-edition-button-text"
                        data-front-edition-button-text="skin.{$skin}:SKIN_FO_ALERT_CONTENT_PLACEHOLDER">
                    </div>
                </div>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
	
</xsl:stylesheet>