<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:docbook="http://docbook.org/ns/docbook" 
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper">

	<xsl:import href="skin:workspace://stylesheets/content/article/article-main.xsl"/>	
	
     
    <xsl:template name="common-content-body-content-title">
        <h1 data-ametys-metadata="{@id};title"><xsl:value-of select="metadata/title"/></h1>
    </xsl:template>
    
    <xsl:template name="common-content-body-title"/>
    
    <xsl:template name="common-content-body-content-content">
    	<!-- Title -->
        <xsl:call-template name="common-content-body-content-title"/>
        
        <!-- Main illustration -->
        <xsl:call-template name="common-content-body-image-bigsize">
            <xsl:with-param name="maxWidth" select="'435'"/>
            <xsl:with-param name="maxHeight" select="'260'"/>
        </xsl:call-template>  
        
        <div class="ametys-richtext" data-ametys-metadata="{@id};content">
            <xsl:call-template name="common-content-body-content-rich"/>
        </div>
    </xsl:template>
    
    <xsl:template name="common-content-body-image">
        <xsl:param name="image"/>
        <xsl:param name="alternative"/>
        <xsl:param name="maxWidth"/>
        <xsl:param name="maxHeight"/>
        <xsl:param name="class"/>
        <xsl:param name="type"/>
        
        <xsl:choose>
            <xsl:when test="$image">
                <div class="content-illustration {$class}" data-ametys-metadata="{@id};illustration/image">
                    <img alt="{$alternative}">
                        <xsl:attribute name="src">
                            <xsl:choose>
                                <xsl:when test="$type = 'cropped'"><xsl:value-of select="resolver:resolveCroppedImage($image/@type, $image/@uri, $maxHeight, $maxWidth)"/></xsl:when>
                                <xsl:otherwise><xsl:value-of select="resolver:resolveBoundedImage($image/@type, $image/@uri, $maxHeight, $maxWidth)"/></xsl:otherwise>
                            </xsl:choose>
                        </xsl:attribute>
                    </img>
                </div>
            </xsl:when>  
            <xsl:otherwise>
                <div class="front-edition-placeholder content-illustration {$class}" data-ametys-metadata="{@id};illustration/image" style="display: none;">
                    <img src="{ametys:skinURL('img/add_image.png')}" alt="" width="435"/>
                </div>
            </xsl:otherwise>
        </xsl:choose>   
    </xsl:template>  
	
</xsl:stylesheet>