<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2020 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:exslt="http://exslt.org/common"
                              xmlns:docbook="http://docbook.org/ns/docbook"
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent" 
                              xmlns:project="org.ametys.plugins.workspaces.project.helper.ProjectXsltHelper"
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper">

	<xsl:import href="plugin:workspaces://stylesheets/content/projectNews/projectNews-carousel.xsl"/>
	<xsl:import href="skin://stylesheets/content/common-edit-tools.xsl"/>
        	
	<xsl:template name="common-content-body">
		<xsl:variable name="page-id"><xsl:call-template name="get-page-id"/></xsl:variable>
		<xsl:variable name="imgUrl">
			<xsl:choose>
	            <xsl:when test="metadata/illustration/image">
	                <xsl:value-of select="resolver:resolveCroppedImage(metadata/illustration/image/@type,metadata/illustration/image/@path, 438, 296)"/>
	            </xsl:when>
	            <xsl:otherwise><xsl:call-template name="news-illustration-default-url"/></xsl:otherwise><!-- default image -->
	        </xsl:choose>	
	    </xsl:variable>

        <div class="ametys-single-full-news ametys-single-full-news--has-layer" style="background-image: url({ametys:escapeURLforCSS($imgUrl)});  background-size: cover;">
            <!-- FO actions -->
            <xsl:call-template name="fo-actions"/>
            
            <div class="ametys-single-full-news-content-inner">
                <a class="ametys-single-full-news-content__link" href="{resolver:resolve('page', $page-id, false)}"></a>
                
                <!--  Date -->
			    <xsl:call-template name="news-date"/>
                
                <!-- Title -->
                <xsl:call-template name="news-title"/>
            
                <!-- Abstract -->
	           <xsl:call-template name="common-content-body-simpletext">
	               <xsl:with-param name="css-class-name">ametys-single-full-news-content__text</xsl:with-param>
	                <xsl:with-param name="text" select="metadata/abstract" />
	               <xsl:with-param name="defaultText" select="metadata/content/docbook:article" />
	               <xsl:with-param name="maxDefaultTextSize" select="200" />
	           </xsl:call-template>	
            </div>
		</div>
    </xsl:template>
    
     <xsl:template name="fo-actions">
        <xsl:variable name="page-id"><xsl:call-template name="get-page-id"/></xsl:variable>
        
        <!-- FO actions -->
        <xsl:call-template name="edit-tools">
            <xsl:with-param name="rootPageId" select="project:getNewsRootPageId()"/>
            <xsl:with-param name="contentPageId" select="$page-id"/>
            <xsl:with-param name="addBtnI18nKey" select="concat('skin.', $skin, ':SKIN_FO_ADD_NEWS_BTN_TEXT')"/>
            <xsl:with-param name="addDialogI18nKey" select="concat('skin.', $skin, ':SKIN_FO_ADD_NEWS_DIALOG_TITLE')"/>
            <xsl:with-param name="contentTypeI18nKey" select="concat('skin.', $skin, ':SKIN_FO_ADD_NEWS_CONTENT_TYPE_LABEL')"/>
            <xsl:with-param name="defaultTitleI18nKey" select="concat('skin.', $skin, ':SKIN_FO_ADD_NEWS_DEFAULT_TITLE')"/>
            <xsl:with-param name="contentTypeId">org.ametys.plugins.workspaces.Content.projectNews</xsl:with-param>
            <xsl:with-param name="editBtnI18nKey" select="concat('skin.', $skin, ':SKIN_FO_EDIT_NEWS_BTN_TEXT')"/>
            <xsl:with-param name="deleteBtnI18nKey" select="concat('skin.', $skin, ':SKIN_FO_DELETE_NEWS_BTN_TEXT')"/>
            <xsl:with-param name="allowedTagProviders">["provider_org.ametys.plugins.workspaces.tags.ProjectCMSTagProvider"]</xsl:with-param>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="news-illustration-default-url">
    	<xsl:value-of select="ametys:skinURL('templates/common/img/pattern.png')"/>
    </xsl:template>
    
    <xsl:template name="news-title">
	    <h1 class="ametys-single-full-news-content__title">
			<xsl:value-of select="metadata/title"/>
		</h1>
    </xsl:template>
    
    <xsl:template name="news-date">
        <xsl:if test="metadata/start-date">
    		<p class="ametys-single-full-news-content__text">
    			<i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="long"> 
    				<xsl:value-of select="metadata/start-date"/>
    			</i18n:date>
    		</p>
        </xsl:if>
    </xsl:template>
    
</xsl:stylesheet>