<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2020 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:docbook="http://docbook.org/ns/docbook" 
                xmlns:html="http://www.w3.org/1999/xhtml"
                xmlns:xlink="http://www.w3.org/1999/xlink"
                exclude-result-prefixes="docbook xlink html">
                
    <xsl:import href="plugin:cms://stylesheets/io/docbook2htmleditor.xsl" />
    
    <!-- NOTE: 
         A previous namespace error in docbook2htmleditor.xsl forces here to write the templates like docbook:name|name,
         because the docbook of some contents is now malformed 
    -->
    
    <xsl:template match="docbook:para[contains(@class, 'prettyprint') or contains(@class, 'linenums') or contains(@class, 'prettyprintLinenums')]|para[contains(@class, 'prettyprint') or contains(@class, 'linenums') or contains(@class, 'prettyprintLinenums')]">
        <p>
            <xsl:choose>
                <xsl:when test="@class='prettyprintLinenums' or contains(@class,'linenums')">
                    <xsl:attribute name="class"><xsl:text>prettyprintLinenums</xsl:text></xsl:attribute>
                    <xsl:apply-templates mode="code"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:attribute name="class">prettyprint</xsl:attribute>
                    <xsl:apply-templates mode="code"/>
                </xsl:otherwise>   
            </xsl:choose>
        </p>
    </xsl:template>
    
    <xsl:template match="item">
        <xsl:value-of select="."/>
    </xsl:template>
    
    <xsl:template match="docbook:phrase|phrase" mode="code2">
        <xsl:text>&#xa;&#xd;</xsl:text>
    </xsl:template>
    
    <xsl:template match="docbook:phrase|phrase" mode="code">
        <br/>
    </xsl:template>
    
    <xsl:template match="docbook:emphasis|emphasis" mode="code">
        <xsl:choose>
            <xsl:when test="@role='strong'">
                <strong><xsl:apply-templates mode="code"/></strong>
            </xsl:when>
            <xsl:otherwise>
                <em><xsl:apply-templates mode="code"/></em>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="@*|text()" mode="code">
        <xsl:copy-of select="."/>
    </xsl:template>
    
</xsl:stylesheet>
