<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2024 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
							xmlns:xalan="http://xml.apache.org/xalan"
                            xmlns:project="org.ametys.plugins.workspaces.project.helper.ProjectXsltHelper"
		                    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
							exclude-result-prefixes="project ametys">
    
    <xsl:import href="skin:workspace://stylesheets/variables.xsl" />
    
    <!-- Override catalog home url to let the browser choose the language redirection regardless of project's current language -->
    <xsl:variable name="catalogHomeUrl">
        <xsl:choose>
            <xsl:when test="$catalogSiteName != ''">
                <xsl:value-of select="ametys:absoluteSiteUriPrefix($catalogSiteName)"/>
            </xsl:when>
            <xsl:otherwise>
                <!-- Catalog home page not found  -->
                <xsl:value-of select="concat($site-uri-prefix, '/', $lang, '/index.html')"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    
</xsl:stylesheet>
