<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
		xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
		xmlns:xalan="http://xml.apache.org/xalan"
		xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:project="org.ametys.plugins.workspaces.project.helper.ProjectXsltHelper"
		xmlns:date="http://exslt.org/dates-and-times" extension-element-prefixes="date"
		exclude-result-prefixes="sitemap ametys resolver project">

	<xsl:import href="skin://templates/page/stylesheets/template.xsl" />
    
    <xsl:template name="additionnal-css">
        <!-- edit tools styles -->
        <link rel="stylesheet" href="{ametys:skinURL('zones/edit-tools/scss/main.css')}" />
        <link rel="stylesheet" href="{ametys:skinURL('zones/edit-tools/scss/print.css')}" />
        <!-- End edit tools styles -->
        
        
        <!-- sidebar styles -->
        <link rel="stylesheet" href="{ametys:skinURL('zones/sidebar/scss/main.css')}" />
        <link rel="stylesheet" href="{ametys:skinURL('zones/sidebar/scss/print.css')}" />
        <!-- End sidebar styles -->
        
        <!-- submenu styles -->
        <link rel="stylesheet" href="{ametys:skinURL('zones/submenu/scss/main.css')}" />
        <link rel="stylesheet" href="{ametys:skinURL('zones/submenu/scss/print.css')}" />
        <!-- End submenu styles -->
    </xsl:template>
        
    <xsl:template name="main-content">
        <div class="container">
            <div class="ametys-main-content-wrap">
                <div class="ametys-main-content">
                    <div class="ametys-main__inner">
                        <zone name="default" level="1" />
                    </div>
                </div>
                
                <xsl:call-template name="aside"/>
            </div>
        </div>
        <xsl:call-template name="fo-toolbar-page"/>
    </xsl:template>

    <xsl:template name="aside">
        <xsl:if test="$sitemap//page[@PLUGIN_TAGS_SECTION and @sitemap:in-path='true']/page[not(@sitemap:invisible)]">
            <aside class="ametys-main-sidebar">
                <div id="ametys-cms-zone-sidebar-right-top">
                    <xsl:call-template name="submenu-navigation"/>             
                </div>
            </aside>
        </xsl:if>
    </xsl:template>    
    
    <xsl:template name="submenu-navigation">
        <div class="ametys-sidebar-section">
            <h2 class="ametys-sidebar-section__title"><xsl:value-of select="$sitemap//page[@PLUGIN_TAGS_SECTION and @sitemap:in-path='true']/@sitemap:title"/></h2>
            
            <xsl:if test="$sitemap//page[@PLUGIN_TAGS_SECTION and @sitemap:in-path='true']/page[not(@sitemap:invisible)]">
                <ul class="ametys-submenu">
                    <xsl:apply-templates select="$sitemap//page[@PLUGIN_TAGS_SECTION and @sitemap:in-path='true']/page[not(@sitemap:invisible)]" mode="submenu"/>
                </ul>
            </xsl:if>
        </div>
    </xsl:template>
    
    <xsl:template match="page" mode="submenu">
        <li class="ametys-submenu__item">
            <xsl:if test="not(page)"><xsl:attribute name="class">ametys-submenu__item ametys-submenu__item__leaf</xsl:attribute></xsl:if>
            
            <xsl:choose>
                <xsl:when test="@sitemap:current = 'true'">
                    <span class="ametys-submenu__item__current">
                        <span class="vl"></span>
                        <xsl:value-of select="@sitemap:title"/>
                    </span>
                </xsl:when>
                <xsl:otherwise>
                    <a href="{resolver:resolve('page', @sitemap:id)}" class="ametys-submenu__item__link">
                        <xsl:if test="@sitemap:in-path">
                            <xsl:attribute name="class">ametys-submenu__item__link active</xsl:attribute>
                        </xsl:if>
                        <span class="vl"></span>
                        <xsl:value-of select="@sitemap:title"/>
                    </a>
                </xsl:otherwise>
            </xsl:choose>
            
            
            <xsl:if test="page[not(@sitemap:invisible)]">
                <ul class="ametys-submenu">
                    <xsl:apply-templates select="page[not(@sitemap:invisible)]" mode="submenu"/>
                </ul>
            </xsl:if>
        </li>
    </xsl:template>
    
    <xsl:template name="fo-toolbar-page">
        <xsl:call-template name="ametys-front-edition-page-toolbar">
            <xsl:with-param name="edition-mode-only" select="false()"/>
            <xsl:with-param name="items">['add-page', 'rename', {type: 'menu', label: "<i18n:text i18n:key="PLUGINS_FRONT_EDITION_TOOLBAR_PAGE_ACTIONS_MENU_LABEL"  i18n:catalogue="plugin.front-edition"/>", items: [ 'tag', 'move', 'delete']}]</xsl:with-param>
            <xsl:with-param name="add-page-config">{                 
                    "force": true,
                    "workflowInitActionId": "13",
                    "show-card-content" : false, 
                    "show-card-type" : false,  
                    "show-card-tags" : false,
                    "show-card-content-properties" : false,
                    "default-pagetype" : "template",
                    "default-template" : "project-minisite",
                    "default-zone" : "default",
                    "default-pagecontent-type" : "contenttype",
                    "default-contenttype" :  "org.ametys.plugins.workspaces.Content.projectArticle",
                    "pagecontent-service" : false      
           }</xsl:with-param>       
        </xsl:call-template>
    </xsl:template>
    
</xsl:stylesheet>