<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
		xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
		xmlns:xalan="http://xml.apache.org/xalan"
		xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:project="org.ametys.plugins.workspaces.project.helper.ProjectXsltHelper"
		xmlns:date="http://exslt.org/dates-and-times" extension-element-prefixes="date"
		exclude-result-prefixes="sitemap ametys resolver project">

	<xsl:import href="skin://stylesheets/main.xsl" />
    
    <xsl:variable name="project" select="project:projectInfo()"/>
    <xsl:variable name="projectName" select="$project/name"/>
    <xsl:variable name="projectTitle" select="$project/title"/>
    <xsl:variable name="projectDescription" select="$project/description"/>
    <xsl:variable name="projectLastActivityDate" select="$project/lastActivityDate"/>
    <xsl:variable name="projectCategoryLabel" select="$project/categoryLabel"/>
    <xsl:variable name="projectCategoryColor" select="$project/categoryColor"/>
    <xsl:variable name="projectKeywords" select="$project/keyword"/>
    <xsl:variable name="projectIllustration" select="resolver:resolve('site-parameter', concat(ametys:site(), ';illustration'))"/>

    <xsl:template name="main-banner">
        <xsl:variable name="bgImg"><xsl:call-template name="main-banner-background-url"/></xsl:variable>
        <div class="ametys-main-banner ametys-anchor" style="background-image: url({ametys:escapeURLforCSS($bgImg)});">
        
			<div class="ametys-main-banner-inner">
				
				<div class="container">
					
                    <xsl:call-template name="main-banner-content"/>
					
				</div>
			</div>
		</div>
    </xsl:template>
    
    <xsl:template name="main-banner-background-url">
        <xsl:choose>
            <xsl:when test="$projectIllustration != ''">
                <xsl:value-of select="$projectIllustration"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="main-banner-default-background-url"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="main-banner-default-background-url">
        <xsl:value-of select="ametys:pluginResourceURL('workspaces', 'img/catalog/library/writing.jpg')"/>
    </xsl:template>
    
    <xsl:template name="header-main-search-additional-fields">
        <input type="hidden" name="project" value="{$projectName}"/>
    </xsl:template>
    
    <xsl:template name="main-content">
        <div>
            <zone name="default" level="1"/>
        </div>
    </xsl:template>
    
    <xsl:template name="main-banner-content">
        <!-- Project's header -->
        <xsl:call-template name="project-header"/>
        
        <!-- Navigation in sections -->            
        <xsl:call-template name="main-menu"/>
        
        <!-- Project's actions -->
        <xsl:call-template name="project-actions"/>
    </xsl:template>
    
    <xsl:template name="project-header">
        <div class="mb-1">
            <!-- Theme -->
            <xsl:call-template name="project-theme"/>
            <!-- Keywords -->
            <xsl:call-template name="project-keywords"/>
        </div>
        <!-- Title -->            
        <xsl:call-template name="project-title"/>
    </xsl:template>
    
    <xsl:template name="project-theme">
        <xsl:if test="$projectCategoryLabel">
            <span class="ametys-tag ametys-tag--sm ametys-tag--success">
                <xsl:if test="$projectCategoryColor/main"><xsl:attribute name="style">background-color: <xsl:value-of select="$projectCategoryColor/main"/>;</xsl:attribute></xsl:if>
                <xsl:value-of select="$projectCategoryLabel"/>
            </span>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="project-keywords">
        <xsl:for-each select="$projectKeywords[position() &lt; 4]">
            <span class="ametys-tag ametys-tag--regular ametys-tag--sm ametys-tag--transparent">
                <i class="fas fa-hashtag"></i>
                <xsl:value-of select="title"/>
            </span>
        </xsl:for-each>
        
        <xsl:if test="$projectKeywords[position() &gt;= 4]">
            <a class="ametys-tag ametys-tag--regular ametys-tag--sm ametys-tag--transparent" href="javascript:;" data-ametys-tooltip-max-width="250px">
                 
	           <xsl:attribute name="data-ametys-tooltip">
	              <xsl:for-each select="$projectKeywords[position() &gt;=  4]"><xsl:value-of select="title"/><xsl:if test="position() != last()"><xsl:text>, </xsl:text></xsl:if></xsl:for-each>
	           </xsl:attribute>
                <i class="fas fa-plus"></i>
                <xsl:value-of select="count($projectKeywords[position() &gt;= 4])"/>
            </a>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="project-title">
        <div class="row mb-6">
            <div class="px-3 py-2">
                <div class="py-1 ametys-main-banner-text">
                    <h1><xsl:value-of select="$projectTitle"/></h1>
                </div>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="project-actions">
        <div class="ametys-actif__wrap">
            <xsl:call-template name="project-date"/>
            
            <xsl:call-template name="project-actions-menu"/>
        </div>
    </xsl:template>
    
    <xsl:template name="project-actions-menu">
        <xsl:if test="project:canAccessBO() or project:canLeaveProject()">
            <div class="ametys-actif_more">
                <span class="g-dot_wrap">
                    <span class="g-dot dot-1"></span>
                    <span class="g-dot dot-2"></span>
                    <span class="g-dot dot-3"></span>
                </span>
                <div class="ametys-actif__moredropdown">
                    <i class="material-icons ametys-color-purple">more_horiz</i>
                    <ul class="ametys-actif__moredropdown__list">
                        
                        <!-- <xsl:call-template name="project-action-edit"/>
                        <xsl:call-template name="project-action-delete"/> -->
                        <xsl:call-template name="project-action-open-cms"/>
                        <xsl:call-template name="project-action-leave"/>
                    </ul>
                </div>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="project-date">
        <span class="ametys-actif">
            <i18n:text i18n:key="SKIN_PROJECT_MENU" i18n:catalogue="skin.{$skin}"/><span data-momentdate="{$projectLastActivityDate}"></span>
        </span>
        <script type="text/javascript">
            let span = $j('.ametys-actif').find("span[data-momentdate]")[0];
            let eventDate = $j(span).data('momentdate');

            $j(span).html(AmetysFront.Utils.fromNow(eventDate));
    
        </script>
    </xsl:template>
    
    <xsl:template name="project-action-edit">
        <li>
            <a href="#!">
                <i class="fas fa-edit"></i>
                <span><i18n:text i18n:key="SKIN_EDIT_PROJECT" i18n:catalogue="skin.{$skin}"/></span>
            </a>
        </li>
    </xsl:template>
    
    <xsl:template name="project-action-delete">
        <li>
            <a href="#!">
                <i class="far fa-trash-alt"></i>
                <span><i18n:text i18n:key="SKIN_DELETE_PROJECT" i18n:catalogue="skin.{$skin}"/></span>
            </a>
        </li>
    </xsl:template>
    
    <xsl:template name="project-action-open-cms">
        <xsl:if test="project:canAccessBO()">
            <li>
                <a href="{concat(ametys:config('cms.url'), '/', $site, '/index.html')}" target="_blank">
                    <i class="icon-logo_ametys_small"></i>
                    <span><i18n:text i18n:key="SKIN_ACCESS_TO_BO" i18n:catalogue="skin.{$skin}"/></span>
                </a>
            </li>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="project-action-leave">
        <xsl:if test="project:canLeaveProject()">
            <li>
                <a href="javascript:leaveProject()">
	                <i class="fas fa-arrow-right-from-bracket"></i>
	                <span><i18n:text i18n:key="SKIN_LEAVE_PROJECT" i18n:catalogue="skin.{$skin}"/></span>
                </a>
            </li>
        </xsl:if>
    </xsl:template>
    
    <!-- Overriden configuration for mobile header -->
    <xsl:template name="mobile-header-title">
        <xsl:value-of select="$projectTitle"/>
    </xsl:template>
    
    <xsl:template name="mobile-header-banner"><xsl:call-template name="main-banner-background-url"/></xsl:template>
    
    <xsl:template name="mobile-header-simplemode">false</xsl:template>
    
    <!-- End Overriden configuration for mobile header -->
    
    <!-- No footer for module pages -->
    <xsl:template name="footer"/>
    
</xsl:stylesheet>