<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2020 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1">
    
    <xsl:template name="recent-activities">
        <div id="sidebar" class="ametys-q-panel">
            <div class="ametys-q-panel-header d-flex align-items-center justify-content-between">
                <h3 class="ametys-q-panel-header__title"><i18n:text i18n:key="SKIN_ACTIVITY_STREAM_TITLE" i18n:catalogue="skin.{$skin}"/></h3>
                <i class="ametys-q-panel-header_close" id="sidebarClose"></i>
            </div>
            
            <div class="ametys-q-panel-body">
                <div class="ametys-q-panel__scroll ametys-scroll-v" data-ametys-activitystream-role="results">
                    <!-- Activity stream event will be inserted in JS here -->
                </div>
            </div>
        </div>
            
        <div class="ametys-q-panel-overlay"></div>
        <div class="ametys-overlay-transparent"></div>
        <!-- END::ametys-q-panel -->
        
        <xsl:call-template name="recent-activities-js"/>
        
    </xsl:template>
    
    <xsl:template name="recent-activities-js">
        <script type="text/javascript">
            <!-- Configuration of the activity stream (by default the activity stream is refresh every 3min and display a max of 100 events) -->
            ActivityStream.configure('<xsl:value-of select="$site-uri-prefix"/>', '<xsl:value-of select="$site" />', '<xsl:value-of select="$lang" />');
            
            ActivityStream.getNumberOfUnreadEvents();
            
            AmetysFront.Event.listen("activity-stream-loading", function(data) {
            
                if ($j("#sidebar .ametys-q-panel__scroll").hasClass('mCustomScrollbar'))
                {
                    // destroy custom scrollbar
                    $j("#sidebar .ametys-q-panel__scroll").mCustomScrollbar("destroy");
                }
            
                $j("#sidebar .ametys-q-panel__scroll").html('&lt;div class="loader">&lt;/div>');
            });
            
            AmetysFront.Event.listen("activity-stream-opened", function(data) {
                // On open reload activity stream if necessary
                ActivityStream.open("#sidebar .ametys-q-panel-body", function() {
                    // init scrollbar
                    $j("#sidebar .ametys-q-panel__scroll").mCustomScrollbar();   
                    
                    // handle show more links
                    $j('.ametys-notifications__list .ametys-sidebar-voir').on('click', function () {
                        $j(this).addClass('d-none');
                        $j(this).parent().find('.ametys-q-panel__list_subtxt--limit').addClass('show');
                    });  
                });
            })
            
            AmetysFront.Event.listen("activity-stream-outofdate", function(data) {
                if (data.nbUnreadEvents > 0)
                {
                    $j("#qPanel .ametys-indicator").show();
                }
            })
            
            AmetysFront.Event.listen("activity-stream-uptodate", function(data) {
                // hide global unread indicator
                $j("#qPanel .ametys-indicator").hide();
            });
            
            AmetysFront.Event.listen("activity-stream-closed", function(data) {
                // On close hide unread indicator
                $j('.ametys-notifications__list_item .ametys-indicator').hide();
                $j("#qPanel .ametys-indicator").hide();
            });
        </script>
    </xsl:template>
    
</xsl:stylesheet>